/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.ui.http.requestlogviewer;

import com.subgraph.vega.api.model.requests.IRequestLogRecord;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class HttpViewLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final Map<Integer, Color> colorMap = new TreeMap<Integer, Color>();

    public void dispose() {
        for (Color color : this.colorMap.values()) {
            color.dispose();
        }
    }

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        if (!(object instanceof IRequestLogRecord)) {
            return null;
        }
        IRequestLogRecord iRequestLogRecord = (IRequestLogRecord)object;
        switch (n) {
            case 0: {
                return Long.toString(iRequestLogRecord.getRequestId());
            }
            case 1: {
                return iRequestLogRecord.getHttpHost().toURI();
            }
            case 2: {
                return iRequestLogRecord.getRequest().getRequestLine().getMethod();
            }
            case 3: {
                return iRequestLogRecord.getRequest().getRequestLine().getUri();
            }
            case 4: {
                return Integer.valueOf(iRequestLogRecord.getResponse().getStatusLine().getStatusCode()).toString();
            }
            case 5: {
                return this.getResponseLength(iRequestLogRecord.getResponse());
            }
            case 6: {
                return Long.toString(iRequestLogRecord.getRequestMilliseconds());
            }
            case 7: {
                int n2 = iRequestLogRecord.getTagCount();
                if (n2 != 0) {
                    return Integer.toString(n2);
                }
                return "";
            }
        }
        return null;
    }

    public String getResponseLength(HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader("Content-Length");
        if (header != null) {
            return header.getValue();
        }
        if (httpResponse.getEntity() == null) {
            return "";
        }
        return Long.toString(httpResponse.getEntity().getContentLength());
    }

    public Color getForeground(Object object, int n) {
        IRequestLogRecord iRequestLogRecord = (IRequestLogRecord)object;
        if (iRequestLogRecord.getTagCount() != 0) {
            return this.getColorInverse(iRequestLogRecord.getTag(0).getRowColor());
        }
        return null;
    }

    public Color getBackground(Object object, int n) {
        IRequestLogRecord iRequestLogRecord = (IRequestLogRecord)object;
        if (iRequestLogRecord.getTagCount() != 0) {
            return this.getColor(iRequestLogRecord.getTag(0).getRowColor());
        }
        return null;
    }

    private Color getColor(int n) {
        Color color = this.colorMap.get(n);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
            this.colorMap.put(n, color);
        }
        return color;
    }

    private Color getColorInverse(int n) {
        int n2 = 255 - (n >> 16 & 0xFF);
        int n3 = 255 - (n >> 8 & 0xFF);
        int n4 = 255 - (n & 0xFF);
        return this.getColor(n2 << 16 | n3 << 8 | n4);
    }
}

