/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class CertificateStore {
    private static final String STORE_FILENAME = "ca.p12";
    private static final String STORE_TYPE = "PKCS12";
    private static final String STORE_KEY = "CA";
    private final File storeFile;
    private final char[] password;
    private final KeyStore keyStore;
    private PrivateKey caPrivateKey;
    private X509Certificate caCertificate;

    CertificateStore(File file, String string) throws GeneralSecurityException, IOException {
        this.storeFile = new File(file, STORE_FILENAME);
        this.password = string.toCharArray();
        this.keyStore = KeyStore.getInstance(STORE_TYPE);
        this.initKeyStore();
    }

    private void initKeyStore() throws GeneralSecurityException, IOException {
        if (!this.storeFile.exists() || !this.loadFromFile()) {
            this.keyStore.load(null, this.password);
        }
    }

    private boolean loadFromFile() throws GeneralSecurityException, IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(this.storeFile);
            this.keyStore.load(fileInputStream, this.password);
            this.caPrivateKey = (PrivateKey)this.keyStore.getKey(STORE_KEY, this.password);
            Certificate[] certificateArray = this.keyStore.getCertificateChain(STORE_KEY);
            this.caCertificate = (X509Certificate)certificateArray[0];
            return true;
        }
    }

    public boolean containsCaCertificate() {
        return this.caPrivateKey != null && this.caCertificate != null;
    }

    public PrivateKey getCaPrivateKey() {
        return this.caPrivateKey;
    }

    public X509Certificate getCaCertificate() {
        return this.caCertificate;
    }

    public void saveCaCertificate(X509Certificate x509Certificate, PrivateKey privateKey) throws CertificateException {
        Certificate[] certificateArray = new Certificate[]{x509Certificate};
        try {
            this.keyStore.setKeyEntry(STORE_KEY, privateKey, this.password, certificateArray);
            FileOutputStream fileOutputStream = new FileOutputStream(this.storeFile);
            this.writeKeyStore(fileOutputStream);
            this.storeFile.setWritable(false, false);
            this.storeFile.setReadable(false, false);
            this.storeFile.setReadable(true, true);
            this.caCertificate = x509Certificate;
            this.caPrivateKey = privateKey;
        }
        catch (KeyStoreException keyStoreException) {
            throw new CertificateException("Failed to store CA certificate in key store: " + keyStoreException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CertificateException("Could not open key store file '" + this.storeFile + "' for writing.");
        }
    }

    private void writeKeyStore(OutputStream outputStream) throws CertificateException {
        try {
            try {
                this.keyStore.store(outputStream, this.password);
            }
            catch (KeyStoreException keyStoreException) {
                throw new CertificateException("Failed to store CA certificate in key store: " + keyStoreException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CertificateException("Failed to find algorithm for serializing certificate data: " + noSuchAlgorithmException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new CertificateException("Attempt to store invalid certificate: " + certificateException.getMessage());
            }
            catch (IOException iOException) {
                throw new CertificateException("I/O error writing to certificate store file: " + iOException.getMessage());
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new CertificateException("I/O error closing certificate store", iOException);
            }
        }
    }
}

