/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import com.subgraph.vega.internal.http.proxy.VegaHttpServerConnection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.RequestLine;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public class VegaHttpRequestParser
implements HttpMessageParser<HttpRequest> {
    private final VegaHttpServerConnection conn;
    private final SessionInputBuffer sessionBuffer;
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;
    private final LineParser lineParser;
    private final int maxHeaderCount;
    private final int maxLineLen;

    public VegaHttpRequestParser(VegaHttpServerConnection vegaHttpServerConnection, SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpRequestFactory httpRequestFactory, HttpParams httpParams) {
        if (httpRequestFactory == null) {
            throw new IllegalArgumentException("Request factory may not be null");
        }
        this.conn = vegaHttpServerConnection;
        this.sessionBuffer = sessionInputBuffer;
        this.lineParser = lineParser;
        this.requestFactory = httpRequestFactory;
        this.lineBuf = new CharArrayBuffer(128);
        this.maxHeaderCount = httpParams.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLen = httpParams.getIntParameter("http.connection.max-line-length", -1);
    }

    private RequestLine parseRequestLine(SessionInputBuffer sessionInputBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int n = sessionInputBuffer.readLine(this.lineBuf);
        if (n == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor parserCursor = new ParserCursor(0, this.lineBuf.length());
        return this.lineParser.parseRequestLine(this.lineBuf, parserCursor);
    }

    public HttpRequest parse() throws IOException, HttpException {
        Object object;
        RequestLine requestLine;
        try {
            requestLine = this.parseRequestLine(this.sessionBuffer);
        }
        catch (ParseException parseException) {
            throw new ProtocolException(parseException.getMessage(), (Throwable)parseException);
        }
        ArrayList arrayList = new ArrayList();
        Header[] headerArray = AbstractMessageParser.parseHeaders((SessionInputBuffer)this.sessionBuffer, (int)this.maxHeaderCount, (int)this.maxLineLen, (LineParser)this.lineParser, arrayList);
        if (this.conn.isSslConnection()) {
            try {
                object = new URI(requestLine.getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException("Invalid URI: " + requestLine.getUri(), (Throwable)uRISyntaxException);
            }
            if (((URI)object).getScheme() == null) {
                Header header = this.getFirstHeader(headerArray, "Host");
                StringBuilder stringBuilder = new StringBuilder();
                if (header != null) {
                    stringBuilder.append("https://");
                    stringBuilder.append(header.getValue());
                } else {
                    stringBuilder.append(this.conn.getSslHost().toURI());
                }
                stringBuilder.append(((URI)object).getRawPath());
                if (((URI)object).getRawQuery() != null) {
                    stringBuilder.append("?");
                    stringBuilder.append(((URI)object).getRawQuery());
                }
                requestLine = new BasicRequestLine(requestLine.getMethod(), stringBuilder.toString(), requestLine.getProtocolVersion());
            }
        }
        object = this.requestFactory.newHttpRequest(requestLine);
        object.setHeaders(headerArray);
        return object;
    }

    private Header getFirstHeader(Header[] headerArray, String string) {
        int n = 0;
        while (n < headerArray.length) {
            if (headerArray[n].getName().equalsIgnoreCase(string)) {
                return headerArray[n];
            }
            ++n;
        }
        return null;
    }
}

