/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.vega.internal.http.proxy;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.HttpContext;

public class ResponseContentCustom
implements HttpResponseInterceptor {
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        ProtocolVersion protocolVersion = httpResponse.getStatusLine().getProtocolVersion();
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            long l = httpEntity.getContentLength();
            if (httpEntity.isChunked() && !protocolVersion.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0)) {
                httpResponse.removeHeaders("Content-Length");
                httpResponse.setHeader("Transfer-Encoding", "chunked");
            } else if (l >= 0L) {
                httpResponse.removeHeaders("Transfer-Encoding");
                httpResponse.setHeader("Content-Length", Long.toString(httpEntity.getContentLength()));
            }
            if (httpEntity.getContentType() != null && !httpResponse.containsHeader("Content-Type")) {
                httpResponse.addHeader(httpEntity.getContentType());
            }
            if (httpEntity.getContentEncoding() != null && !httpResponse.containsHeader("Content-Encoding")) {
                httpResponse.addHeader(httpEntity.getContentEncoding());
            }
        } else {
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n != 204 && n != 304 && n != 205) {
                httpResponse.setHeader("Content-Length", "0");
            }
        }
    }
}

