#!/usr/bin/python
'''
//=============================================================================
//
//    File : ufo_jazztelgui.py
//    Creation date : Wed Dec 05 14:30:48 CEST 2012
//    Working on this file:    asterix (Cristian Steri)
//                            Grifisx (Antonino G. Imbesi)
//     This file is part of the Ufo Wardriving distribution
//
//    Websites: http://ufo-wardriving.com
//
//     This program is FREE software. You can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your opinion) any later version.
//
//    This program is distributed in the HOPE that it will be USEFUL,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//     See the GNU General Public License for more details.
//
//     You should have received a copy of the GNU General Public License
//     along with this program. If not, write to the Free Software Foundation,
//     Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import sys, os.path

from core import ufo_jazzteldecode

from core.ufo_picsfinder import get_icon

class UFOJazztelWidget(QWidget):
    def __init__(self, parent = None):
        super(UFOJazztelWidget, self).__init__(parent)

        hBoxLayoutSsid = QHBoxLayout()
        hBoxLayoutSsid.setSpacing(5)
        hBoxLayoutMac = QHBoxLayout()
        hBoxLayoutMac.setSpacing(5)

        vBoxLayout = QVBoxLayout()
        vBoxLayout.setSpacing(5)

        ssidLabel = QLabel("SSID:",self)
        self.ssidLineEdit= QLineEdit(self)
        self.ssidLineEdit.setToolTip("SSID "+_("Compatible")+" :\nJazztel*")
        self.ssidLineEdit.setMaxLength(4)
        self.ssidLineEdit.setInputMask("HHHH;-")

        macLabel = QLabel("MAC:",self)
        self.macLineEdit= QLineEdit(self)
        self.macLineEdit.setInputMask("HH:HH:HH:HH:HH:HH;_")

        self.outputTextEdit = QTextEdit(self)
        self.outputTextEdit.setReadOnly(True)

        self.calcPushButton = QPushButton(_("Find"),self)
        self.calcPushButton.setIcon(get_icon("key.png"))
        self.calcPushButton.setEnabled(0)

        hBoxLayoutSsid.addWidget(ssidLabel)
        hBoxLayoutSsid.addWidget(self.ssidLineEdit)
        hBoxLayoutMac.addWidget(macLabel)
        hBoxLayoutMac.addWidget(self.macLineEdit)

        hBoxLayoutSsid.addWidget(self.calcPushButton)

        vBoxLayout.addLayout(hBoxLayoutSsid)
        vBoxLayout.addLayout(hBoxLayoutMac)
        vBoxLayout.addWidget(self.outputTextEdit)


        self.setLayout(vBoxLayout)

        self.ssidLineEdit.textChanged.connect(self.enable_button)
        self.macLineEdit.textChanged.connect(self.enable_button)
        self.calcPushButton.clicked.connect(self.find_key)

    def enable_button(self):
        if self.macLineEdit.text().length()==17 and self.ssidLineEdit.text().length()==4:
            self.calcPushButton.setEnabled(1)
        else:
            self.calcPushButton.setEnabled(0)

    def find_key(self):
        mac_jazztel = str(self.macLineEdit.text())
        ssid_jazztel = str(self.ssidLineEdit.text())
        mac_jazztel = mac_jazztel.replace(" ","")
        ssid_jazztel = ssid_jazztel.replace(" ","")
        stdouterr_jazztel = ufo_jazzteldecode.calc(ssid_jazztel, mac_jazztel)
        if stdouterr_jazztel:
            self.outputTextEdit.setText(stdouterr_jazztel)
        else:
            self.outputTextEdit.setText(_("No key found."))
