#!/usr/bin/python
'''
//=============================================================================
//
//  File : ufo_mactools.py
//  Creation date : Thu Feb 14 14:30:48 CEST 2012
//  Working on this file:   asterix (Cristian Steri)
//                          Grifisx (Antonino G. Imbesi)
//   This file is part of the Ufo Wardriving distribution
//
//  Websites: http://ufo-wardriving.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//  This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

import sys
import os
import subprocess
import random
import time 
import platform
if platform.system() == "Windows":
    from win32con import CREATE_NO_WINDOW 


def get_mac_unix(iface):
    iface = str(iface)
    p = os.popen('/sbin/ifconfig '+iface)
    b = p.read().split('\n')
    p.close()
    addr = ""
    for m in b:
        f = m.find('HWaddr')
        if f is not -1:
            addr = m[f:].split()[1]
    return addr

def mac_random(iface):
    if platform.system() == "Windows":
        dir_loc = os.path.dirname(os.path.realpath(sys.argv[0]))+"\\bin\\"
        dir_loc = '"%smactool.exe"' % dir_loc
        iface = '"%s"' % (str(iface))
        output = subprocess.Popen(["powershell", "start-process","-windowstyle", "hidden", dir_loc, "-ArgumentList", "\'-i", iface, "-r\'", "-Verb", "runas"], stdout=subprocess.PIPE, creationflags=CREATE_NO_WINDOW)
        output = output.stdout.read()
        if output:
            return 
        else:
            return True
    else:
        mac = [ 0x00, 0x16, 0x3e,  
        random.randint(0x00, 0x7f),  
        random.randint(0x00, 0xff),  
        random.randint(0x00, 0xff) ] 
        mac = ':'.join(map(lambda x: "%02x" % x, mac)) 
        mac_change(iface,mac)

def mac_funny(iface):
    i = random.randint(0,3)
    if i == 0:
        mac = "00:f1:ca:0c:0c:a0"
    elif i == 1:
        mac = "00:c0:ca:c0:14:00"
    elif i == 2:
        mac = "00:31:33:73:00:00"
    elif i == 3:
        mac = "00:69:69:69:69:69"
    mac_change(iface,mac)

def mac_change(iface,mac):
    if platform.system() == "Windows":
        dir_loc = os.path.dirname(os.path.realpath(sys.argv[0]))+"\\bin\\"
        dir_loc = '"%smactool.exe"' % dir_loc
        mac = str(mac)
        mac = "%s\'" % (mac)
        iface = '"%s"' % (str(iface))
        output = subprocess.Popen(["powershell", "start-process","-windowstyle", "hidden", dir_loc, "-ArgumentList", "\'-i", iface, mac, "-Verb", "runas"], stdout=subprocess.PIPE, creationflags=CREATE_NO_WINDOW)
        output = output.stdout.read()
        if output:
            return 
        else:
            return True
        
    else:
        print iface+"    "+mac
        subprocess.call(["ifconfig",iface,"down"])
        time.sleep(1)
        subprocess.call(["ifconfig",iface,"hw","ether",mac])
        subprocess.call(["ifconfig",iface,"up"])
        time.sleep(1)
