/*
 * Decompiled with CFR 0.152.
 */
package Utility_Code.GlobalSettings.Preferences_Window;

import File_Operations.File_Readers.DetermineDocType_Ckl;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import Utility_Code.GlobalSettings.Preferences_Window.PreferenceWindow_Ctl;
import Utility_Code.GlobalSettings.SV_Logger;
import java.util.Collection;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import stigviewer.STIGViewer;

public final class PreferencesWindow {
    private final Scene PrgScene;
    private final Stage PrgStage;
    private final PreferenceWindow_Ctl PreferenceControl = new PreferenceWindow_Ctl();
    private static PreferencesWindow PWindow;

    private PreferencesWindow() {
        TabPane tPane = new TabPane();
        Tab genTab = new Tab();
        Tab cklTab = new Tab();
        GridPane panelGen = new GridPane();
        GridPane panelCkl = new GridPane();
        panelGen.setHgap(10.0);
        panelGen.setVgap(10.0);
        panelGen.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        panelCkl.setHgap(10.0);
        panelCkl.setVgap(10.0);
        panelCkl.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.createGenPane(panelGen);
        this.createCklPane(panelCkl);
        genTab.setText("General");
        genTab.setContent((Node)panelGen);
        genTab.setClosable(false);
        cklTab.setText("Checklist");
        cklTab.setContent((Node)panelCkl);
        cklTab.setClosable(false);
        tPane.getTabs().addAll((Object[])new Tab[]{genTab, cklTab});
        this.PrgScene = new Scene((Parent)tPane);
        this.PrgStage = new Stage();
        this.PrgStage.setScene(this.PrgScene);
        this.PrgStage.setTitle("Preferences");
        this.PrgStage.initModality(Modality.WINDOW_MODAL);
        this.PrgStage.initOwner(STIGViewer.getSV().getPrimaryStage().getScene().getWindow());
    }

    public void Open() {
        this.PrgStage.show();
    }

    private CheckBox createLogOutputCheckBox() {
        CheckBox ckbax = new CheckBox();
        if (SV_Logger.getSVLog().getLogging()) {
            ckbax.selectedProperty().setValue(Boolean.TRUE);
        }
        ckbax.setOnAction(this.PreferenceControl.getLogOutputCheckControl(ckbax));
        return ckbax;
    }

    private CheckBox createChecklistValidationCheckbox() {
        CheckBox cb = new CheckBox();
        cb.setSelected(DetermineDocType_Ckl.getDetermineDoctype_Ckl().getValidate());
        cb.setOnAction(this.PreferenceControl.getChecklistValidationCheckControl(cb));
        return cb;
    }

    private ComboBox createFontBox() {
        ComboBox cbax = new ComboBox();
        cbax.getItems().setAll((Collection)Font.getFamilies());
        cbax.getSelectionModel().select((Object)PrefSet.getPS().getFontType());
        cbax.setOnAction(this.PreferenceControl.getFontBoxControl(cbax));
        return cbax;
    }

    private TextField createFontSizeBox() {
        TextField texf = new TextField();
        texf.setMaxHeight(30.0);
        texf.setMaxWidth(50.0);
        texf.setText(PrefSet.getPS().getFontSize());
        texf.setOnKeyPressed(this.PreferenceControl.getFontSizeBoxControl(texf));
        texf.focusedProperty().addListener(this.PreferenceControl.getFontSizeBoxFocusControl(texf));
        return texf;
    }

    private ComboBox createStyleBox() {
        ComboBox cbax = new ComboBox();
        cbax.getItems().setAll(new Object[]{"Light Theme", "Dark Theme", "SV 2.x Classic Light", "SV 2.x Classic Dark"});
        cbax.getSelectionModel().select((Object)PrefSet.getPS().getStyle());
        cbax.setOnAction(this.PreferenceControl.getStyleBoxControl(cbax));
        return cbax;
    }

    private void createGenPane(GridPane panelGen) {
        ComboBox fontBox = this.createFontBox();
        Text fontBoxLabel = new Text("Font: ");
        GridPane.setConstraints((Node)fontBoxLabel, (int)0, (int)0);
        GridPane.setConstraints((Node)fontBox, (int)1, (int)0);
        panelGen.add((Node)fontBoxLabel, 0, 0);
        panelGen.add((Node)fontBox, 1, 0);
        TextField fontSizeBox = this.createFontSizeBox();
        Text fontSizeBoxLabel = new Text("Font Size: ");
        GridPane.setConstraints((Node)fontSizeBoxLabel, (int)0, (int)1);
        GridPane.setConstraints((Node)fontSizeBox, (int)1, (int)1);
        panelGen.add((Node)fontSizeBoxLabel, 0, 1);
        panelGen.add((Node)fontSizeBox, 1, 1);
        ComboBox programStyle = this.createStyleBox();
        Text programStyleLabel = new Text("Visual Style: ");
        GridPane.setConstraints((Node)programStyleLabel, (int)2, (int)0);
        GridPane.setConstraints((Node)programStyle, (int)3, (int)0);
        panelGen.add((Node)programStyleLabel, 2, 0);
        panelGen.add((Node)programStyle, 3, 0);
        CheckBox logCheck = this.createLogOutputCheckBox();
        Text logCheckLabel = new Text("Output Logging to File: ");
        GridPane.setConstraints((Node)logCheckLabel, (int)4, (int)0);
        GridPane.setConstraints((Node)logCheck, (int)5, (int)0);
        panelGen.add((Node)logCheckLabel, 4, 0);
        panelGen.add((Node)logCheck, 5, 0);
    }

    private ColorPicker createCATIColor() {
        ColorPicker cp = new ColorPicker();
        cp.setValue((Object)PrefSet.getPS().getSV_FONT_OPEN1_COLOR_RGB_FX());
        cp.setOnAction(this.PreferenceControl.getCATIColorControl(cp));
        return cp;
    }

    private ColorPicker createCAT2Color() {
        ColorPicker cp = new ColorPicker();
        cp.setValue((Object)PrefSet.getPS().getSV_FONT_OPEN2_COLOR_RGB_FX());
        cp.setOnAction(this.PreferenceControl.getCAT2ColorControl(cp));
        return cp;
    }

    private ColorPicker createCAT3Color() {
        ColorPicker cp = new ColorPicker();
        cp.setValue((Object)PrefSet.getPS().getSV_FONT_OPEN3_COLOR_RGB_FX());
        cp.setOnAction(this.PreferenceControl.getCAT3ColorControl(cp));
        return cp;
    }

    private ColorPicker createNAColor() {
        ColorPicker cp = new ColorPicker();
        cp.setValue((Object)PrefSet.getPS().getSV_FONT_NA_COLOR_RGB_FX());
        cp.setOnAction(this.PreferenceControl.getNAColorControl(cp));
        return cp;
    }

    private ColorPicker createNFColor() {
        ColorPicker cp = new ColorPicker();
        cp.setValue((Object)PrefSet.getPS().getSV_FONT_NAF_COLOR_RGB_FX());
        cp.setOnAction(this.PreferenceControl.getNFColorControl(cp));
        return cp;
    }

    private void createCklPane(GridPane panelCkl) {
        Text colorTitle = new Text("Text Colors: ");
        GridPane.setConstraints((Node)colorTitle, (int)0, (int)0);
        panelCkl.add((Node)colorTitle, 0, 0);
        ColorPicker colorO1 = this.createCATIColor();
        Text o1Text = new Text("CAT I Open: ");
        GridPane.setConstraints((Node)o1Text, (int)0, (int)1);
        GridPane.setConstraints((Node)colorO1, (int)1, (int)1);
        panelCkl.add((Node)o1Text, 0, 1);
        panelCkl.add((Node)colorO1, 1, 1);
        ColorPicker colorO2 = this.createCAT2Color();
        Text o2Text = new Text("CAT II Open: ");
        GridPane.setConstraints((Node)o2Text, (int)0, (int)2);
        GridPane.setConstraints((Node)colorO2, (int)1, (int)2);
        panelCkl.add((Node)o2Text, 0, 2);
        panelCkl.add((Node)colorO2, 1, 2);
        ColorPicker colorO3 = this.createCAT3Color();
        Text o3Text = new Text("CAT III Open: ");
        GridPane.setConstraints((Node)o3Text, (int)0, (int)3);
        GridPane.setConstraints((Node)colorO3, (int)1, (int)3);
        panelCkl.add((Node)o3Text, 0, 3);
        panelCkl.add((Node)colorO3, 1, 3);
        ColorPicker colorNA = this.createNAColor();
        Text naText = new Text("Not Applicable: ");
        GridPane.setConstraints((Node)naText, (int)2, (int)1);
        GridPane.setConstraints((Node)colorNA, (int)3, (int)1);
        panelCkl.add((Node)naText, 2, 1);
        panelCkl.add((Node)colorNA, 3, 1);
        ColorPicker colorNF = this.createNFColor();
        Text nfText = new Text("Not A Finding: ");
        GridPane.setConstraints((Node)nfText, (int)4, (int)1);
        GridPane.setConstraints((Node)colorNF, (int)5, (int)1);
        panelCkl.add((Node)nfText, 4, 1);
        panelCkl.add((Node)colorNF, 5, 1);
        Text fileTitle = new Text("File Settings:");
        GridPane.setConstraints((Node)fileTitle, (int)0, (int)4);
        panelCkl.add((Node)fileTitle, 0, 4);
        CheckBox cbValidate = this.createChecklistValidationCheckbox();
        Text validateText = new Text("Validate Checklists:");
        GridPane.setConstraints((Node)validateText, (int)0, (int)5);
        GridPane.setConstraints((Node)cbValidate, (int)1, (int)5);
        panelCkl.add((Node)validateText, 0, 5);
        panelCkl.add((Node)cbValidate, 1, 5);
    }

    public static PreferencesWindow getPreferencesWindow() {
        if (PWindow == null) {
            PWindow = new PreferencesWindow();
        }
        return PWindow;
    }
}

