/*
 * Decompiled with CFR 0.152.
 */
package Utility_Code.GlobalSettings.Preferences_Window;

import File_Operations.File_Readers.DetermineDocType_Ckl;
import File_Operations.File_Writers.PreferencesWriter;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import Utility_Code.GlobalSettings.SV_Logger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import stigviewer.STIGViewer;

class PreferenceWindow_Ctl {
    public EventHandler getLogOutputCheckControl(final CheckBox ckbax) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (ckbax.isSelected()) {
                    SV_Logger.getSVLog().configureRootLoggerOn();
                } else {
                    SV_Logger.getSVLog().configureRootLoggerOff();
                }
                PreferencesWriter.getPreferencesWriter().Write("SV_LOG=" + SV_Logger.getSVLog().getLogging());
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: Logging set to: " + SV_Logger.getSVLog().getLogging());
            }
        };
        return onSelection;
    }

    public EventHandler getChecklistValidationCheckControl(final CheckBox cb) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                DetermineDocType_Ckl.getDetermineDoctype_Ckl().setValidate(cb.isSelected());
                PreferencesWriter.getPreferencesWriter().Write("SV_CKL_VALIDATE=" + DetermineDocType_Ckl.getDetermineDoctype_Ckl().getValidate());
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: Checklist validation set to: " + DetermineDocType_Ckl.getDetermineDoctype_Ckl().getValidate());
            }
        };
        return onSelection;
    }

    public EventHandler getFontBoxControl(final ComboBox cbax) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                String selection = (String)cbax.getSelectionModel().getSelectedItem();
                PrefSet.getPS().setSV_FONT_TYPE(selection);
                STIGViewer.getSV().updateAllDisplays();
                PreferencesWriter.getPreferencesWriter().Write("SV_FONT_TYPE=" + selection);
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: Font Selected: " + selection);
            }
        };
        return onSelection;
    }

    private void updateFontSize(TextField texf) {
        String selection = texf.getText();
        try {
            int n = Integer.parseInt(selection);
        }
        catch (Exception e) {
            selection = "14";
        }
        texf.setText(selection);
        PrefSet.getPS().setSV_FONT_SIZE(selection);
        STIGViewer.getSV().updateAllDisplays();
        PreferencesWriter.getPreferencesWriter().Write("SV_FONT_SIZE=" + selection);
        Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: Font Size Selected: " + selection);
    }

    public EventHandler<KeyEvent> getFontSizeBoxControl(final TextField texf) {
        EventHandler<KeyEvent> onSelection = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode().equals((Object)KeyCode.ENTER)) {
                    PreferenceWindow_Ctl.this.updateFontSize(texf);
                }
            }
        };
        return onSelection;
    }

    public ChangeListener<Boolean> getFontSizeBoxFocusControl(TextField texf) {
        ChangeListener onChange = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue()) {
                this.updateFontSize(texf);
            }
        };
        return onChange;
    }

    public EventHandler getStyleBoxControl(final ComboBox cbax) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                String selection = (String)cbax.getSelectionModel().getSelectedItem();
                PrefSet.getPS().setSV_STYLE(selection);
                STIGViewer.getSV().updateAllDisplays();
                PreferencesWriter.getPreferencesWriter().Write("SV_STYLE=" + selection);
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: Style Selected: " + selection);
            }
        };
        return onSelection;
    }

    public EventHandler getCATIColorControl(final ColorPicker cp) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Color clr = (Color)cp.getValue();
                PrefSet.getPS().set_SV_FONT_OPEN1_COLOR_RGB_FX(clr);
                STIGViewer.getSV().updateAllDisplays();
                PreferencesWriter.getPreferencesWriter().Write("SV_CO1=" + clr.getRed() + "_" + clr.getGreen() + "_" + clr.getBlue());
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: 1: Color Selected: " + clr.toString());
            }
        };
        return onSelection;
    }

    public EventHandler getCAT2ColorControl(final ColorPicker cp) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Color clr = (Color)cp.getValue();
                PrefSet.getPS().set_SV_FONT_OPEN2_COLOR_RGB_FX(clr);
                STIGViewer.getSV().updateAllDisplays();
                PreferencesWriter.getPreferencesWriter().Write("SV_CO2=" + clr.getRed() + "_" + clr.getGreen() + "_" + clr.getBlue());
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: 2: Color Selected: " + clr.toString());
            }
        };
        return onSelection;
    }

    public EventHandler getCAT3ColorControl(final ColorPicker cp) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Color clr = (Color)cp.getValue();
                PrefSet.getPS().set_SV_FONT_OPEN3_COLOR_RGB_FX(clr);
                STIGViewer.getSV().updateAllDisplays();
                PreferencesWriter.getPreferencesWriter().Write("SV_CO3=" + clr.getRed() + "_" + clr.getGreen() + "_" + clr.getBlue());
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: 3: Color Selected: " + clr.toString());
            }
        };
        return onSelection;
    }

    public EventHandler getNFColorControl(final ColorPicker cp) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Color clr = (Color)cp.getValue();
                PrefSet.getPS().set_SV_FONT_NF_COLOR_RGB_FX(clr);
                STIGViewer.getSV().updateAllDisplays();
                PreferencesWriter.getPreferencesWriter().Write("SV_CNF=" + clr.getRed() + "_" + clr.getGreen() + "_" + clr.getBlue());
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: 4: Color Selected: " + clr.toString());
            }
        };
        return onSelection;
    }

    public EventHandler getNAColorControl(final ColorPicker cp) {
        EventHandler<ActionEvent> onSelection = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Color clr = (Color)cp.getValue();
                PrefSet.getPS().set_SV_FONT_NA_COLOR_RGB_FX(clr);
                STIGViewer.getSV().updateAllDisplays();
                PreferencesWriter.getPreferencesWriter().Write("SV_CNA=" + clr.getRed() + "_" + clr.getGreen() + "_" + clr.getBlue());
                Logger.getLogger(PreferenceWindow_Ctl.class.getName()).log(Level.INFO, "INFO: Preferences: 5: Color Selected: " + clr.toString());
            }
        };
        return onSelection;
    }
}

