/*
 * Decompiled with CFR 0.152.
 */
package Utility_Code.GlobalSettings.Preferences_Window;

import File_Operations.File_Readers.DetermineDocType_Ckl;
import File_Operations.File_Readers.PreferencesReader;
import Utility_Code.GlobalSettings.SV_Logger;
import java.util.List;
import javafx.scene.paint.Color;

public class PrefSet {
    private static PrefSet Psettings;
    private String SV_FONT_TYPE;
    private String SV_FONT_SIZE;
    private String SV_STYLE;
    private String SV_FONT_COLOR;
    private String SV_BACKGROUND_COLOR;
    private String SV_BACKGROUND_COLOR_HIGHLIGHT;
    private String SV_BORDER_RGB;
    private String SV_FONT_TYPE_HTML;
    private String SV_FONT_SIZE_HTML;
    private String SV_FONT_COLOR_HTML;
    private String SV_BACKGROUND_COLOR_HTML;
    private String SV_FILTER_HIGHLIGHT;
    private String SV_FONT_TYPE_FX;
    private String SV_FONT_SIZE_FX;
    private String SV_FONT_COLOR_FX;
    private String SV_BACKGROUND_COLOR_FX;
    private String SV_INNER_BACKGROUND_COLOR_FX;
    private String SV_BACKGROUND_COLOR_HIGHLIGHT_FX;
    private String SV_BORDER_RGB_FX;
    private Color SV_FONT_DEFAULT_COLOR_RGB_FX;
    private Color SV_FONT_NR_COLOR_RGB_FX;
    private Color SV_FONT_OPEN1_COLOR_RGB_FX;
    private Color SV_FONT_OPEN2_COLOR_RGB_FX;
    private Color SV_FONT_OPEN3_COLOR_RGB_FX;
    private Color SV_FONT_NF_COLOR_RGB_FX;
    private Color SV_FONT_NA_COLOR_RGB_FX;

    private PrefSet() {
        SV_Logger.getSVLog();
        List prefsRead = (List)PreferencesReader.getPreferencesReader().importPref();
        for (String s : prefsRead) {
            String[] tempSp = s.split("=");
            switch (tempSp[0]) {
                case "SV_FONT_TYPE": {
                    this.setSV_FONT_TYPE(tempSp[1]);
                    break;
                }
                case "SV_FONT_SIZE": {
                    this.setSV_FONT_SIZE(tempSp[1]);
                    break;
                }
                case "SV_STYLE": {
                    this.setSV_STYLE(tempSp[1]);
                    break;
                }
                case "SV_LOG": {
                    if (tempSp[1].equalsIgnoreCase("true")) {
                        SV_Logger.getSVLog().configureRootLoggerOn();
                        break;
                    }
                    SV_Logger.getSVLog().configureRootLoggerOff();
                    break;
                }
                case "SV_CO1": {
                    String[] cSp = tempSp[1].split("_");
                    this.SV_FONT_OPEN1_COLOR_RGB_FX = Color.color((double)Double.parseDouble(cSp[0]), (double)Double.parseDouble(cSp[1]), (double)Double.parseDouble(cSp[2]));
                    break;
                }
                case "SV_CO2": {
                    String[] cSp = tempSp[1].split("_");
                    this.SV_FONT_OPEN2_COLOR_RGB_FX = Color.color((double)Double.parseDouble(cSp[0]), (double)Double.parseDouble(cSp[1]), (double)Double.parseDouble(cSp[2]));
                    break;
                }
                case "SV_CO3": {
                    String[] cSp = tempSp[1].split("_");
                    this.SV_FONT_OPEN3_COLOR_RGB_FX = Color.color((double)Double.parseDouble(cSp[0]), (double)Double.parseDouble(cSp[1]), (double)Double.parseDouble(cSp[2]));
                    break;
                }
                case "SV_CNA": {
                    String[] cSp = tempSp[1].split("_");
                    this.SV_FONT_NA_COLOR_RGB_FX = Color.color((double)Double.parseDouble(cSp[0]), (double)Double.parseDouble(cSp[1]), (double)Double.parseDouble(cSp[2]));
                    break;
                }
                case "SV_CNF": {
                    String[] cSp = tempSp[1].split("_");
                    this.SV_FONT_NF_COLOR_RGB_FX = Color.color((double)Double.parseDouble(cSp[0]), (double)Double.parseDouble(cSp[1]), (double)Double.parseDouble(cSp[2]));
                    break;
                }
                case "SV_CKL_VALIDATE": {
                    DetermineDocType_Ckl.getDetermineDoctype_Ckl().setValidate(tempSp[1].equalsIgnoreCase("true"));
                }
            }
        }
        if (this.SV_FONT_TYPE == null) {
            this.setSV_FONT_TYPE("Segoe UI");
        }
        if (this.SV_FONT_SIZE == null) {
            this.setSV_FONT_SIZE("14");
        }
        if (this.SV_STYLE == null) {
            this.setSV_STYLE("Light Theme");
        }
        this.SV_FONT_NR_COLOR_RGB_FX = Color.rgb((int)255, (int)255, (int)255);
        if (this.SV_FONT_OPEN1_COLOR_RGB_FX == null) {
            this.SV_FONT_OPEN1_COLOR_RGB_FX = Color.RED;
        }
        if (this.SV_FONT_OPEN2_COLOR_RGB_FX == null) {
            this.SV_FONT_OPEN2_COLOR_RGB_FX = Color.DARKORANGE;
        }
        if (this.SV_FONT_OPEN3_COLOR_RGB_FX == null) {
            this.SV_FONT_OPEN3_COLOR_RGB_FX = Color.DARKGOLDENROD;
        }
        if (this.SV_FONT_NF_COLOR_RGB_FX == null) {
            this.SV_FONT_NF_COLOR_RGB_FX = Color.color((double)0.078431, (double)0.760784, (double)0.229412);
        }
        if (this.SV_FONT_NA_COLOR_RGB_FX == null) {
            this.SV_FONT_NA_COLOR_RGB_FX = Color.rgb((int)180, (int)180, (int)180);
        }
    }

    public final void setSV_STYLE(String theme) {
        this.SV_STYLE = theme;
        switch (theme) {
            case "Light Theme": {
                this.setSV_FONT_COLOR("");
                this.setSV_FONT_DEFAULT_COLOR_FX(Color.rgb((int)0, (int)0, (int)0));
                this.setSV_BACKGROUND_COLOR("");
                this.setSV_BACKGROUND_COLOR_HIGHLIGHT("");
                this.setSV_INNER_BACKGROUND_COLOR_FX("white");
                this.setSV_BORDER_RGB("");
                this.setSV_FILTER_HIGHLIGHT("yellow");
                break;
            }
            case "Dark Theme": {
                this.setSV_FONT_COLOR("white");
                this.setSV_FONT_DEFAULT_COLOR_FX(Color.rgb((int)255, (int)255, (int)255));
                this.setSV_BACKGROUND_COLOR("black");
                this.setSV_INNER_BACKGROUND_COLOR_FX("black");
                this.setSV_BACKGROUND_COLOR_HIGHLIGHT("dodgerblue");
                this.setSV_BORDER_RGB("rgb(255, 255, 255)");
                this.setSV_FILTER_HIGHLIGHT("red");
                break;
            }
            case "SV 2.x Classic Light": {
                this.setSV_FONT_COLOR("");
                this.setSV_FONT_DEFAULT_COLOR_FX(Color.rgb((int)0, (int)0, (int)0));
                this.setSV_BACKGROUND_COLOR("");
                this.setSV_BACKGROUND_COLOR_HIGHLIGHT("");
                this.setSV_INNER_BACKGROUND_COLOR_FX("white");
                this.setSV_BORDER_RGB("");
                this.setSV_FILTER_HIGHLIGHT("yellow");
                break;
            }
            case "SV 2.x Classic Dark": {
                this.setSV_FONT_COLOR("white");
                this.setSV_FONT_DEFAULT_COLOR_FX(Color.rgb((int)255, (int)255, (int)255));
                this.setSV_BACKGROUND_COLOR("black");
                this.setSV_INNER_BACKGROUND_COLOR_FX("black");
                this.setSV_BACKGROUND_COLOR_HIGHLIGHT("dodgerblue");
                this.setSV_BORDER_RGB("rgb(255, 255, 255)");
                this.setSV_FILTER_HIGHLIGHT("red");
                break;
            }
        }
    }

    private void setSV_INNER_BACKGROUND_COLOR_FX(String s) {
        this.SV_INNER_BACKGROUND_COLOR_FX = "-fx-control-inner-background: " + s + ";";
    }

    private void setSV_FONT_DEFAULT_COLOR_FX(Color defColor) {
        this.SV_FONT_DEFAULT_COLOR_RGB_FX = defColor;
    }

    public void set_SV_FONT_NR_COLOR_RGB_FX(Color nrColor) {
        this.SV_FONT_NR_COLOR_RGB_FX = nrColor;
    }

    public void set_SV_FONT_OPEN1_COLOR_RGB_FX(Color openColor) {
        this.SV_FONT_OPEN1_COLOR_RGB_FX = openColor;
    }

    public void set_SV_FONT_OPEN2_COLOR_RGB_FX(Color openColor) {
        this.SV_FONT_OPEN2_COLOR_RGB_FX = openColor;
    }

    public void set_SV_FONT_OPEN3_COLOR_RGB_FX(Color openColor) {
        this.SV_FONT_OPEN3_COLOR_RGB_FX = openColor;
    }

    public void set_SV_FONT_NF_COLOR_RGB_FX(Color nfColor) {
        this.SV_FONT_NF_COLOR_RGB_FX = nfColor;
    }

    public void set_SV_FONT_NA_COLOR_RGB_FX(Color naColor) {
        this.SV_FONT_NA_COLOR_RGB_FX = naColor;
    }

    public void setSV_FILTER_HIGHLIGHT(String color) {
        this.SV_FILTER_HIGHLIGHT = color;
    }

    public final void setSV_FONT_TYPE(String fontType) {
        this.SV_FONT_TYPE = fontType;
        this.SV_FONT_TYPE_HTML = "font-family: " + this.SV_FONT_TYPE + ";";
        this.SV_FONT_TYPE_FX = "-fx-font-family: " + this.SV_FONT_TYPE + ";";
    }

    public final void setSV_FONT_SIZE(String fontSize) {
        this.SV_FONT_SIZE = fontSize;
        this.SV_FONT_SIZE_HTML = "font-size: " + this.SV_FONT_SIZE + ";";
        this.SV_FONT_SIZE_FX = "-fx-font-size: " + this.SV_FONT_SIZE + ";";
    }

    private void setSV_FONT_COLOR(String fontColor) {
        this.SV_FONT_COLOR = fontColor;
        if (!fontColor.equals("")) {
            this.SV_FONT_COLOR_HTML = "color: " + this.SV_FONT_COLOR + ";";
            this.SV_FONT_COLOR_FX = "-fx-text-fill: " + this.SV_FONT_COLOR + "; -fx-text-base-color: " + this.SV_FONT_COLOR + ";";
        } else {
            this.SV_FONT_COLOR_FX = "";
            this.SV_FONT_COLOR_HTML = "";
        }
    }

    private void setSV_BORDER_RGB(String borderColor) {
        if (!borderColor.equals("")) {
            this.SV_BORDER_RGB = borderColor;
            this.SV_BORDER_RGB_FX = "-fx-border-color: " + this.SV_BORDER_RGB + ";";
        } else {
            this.SV_BORDER_RGB = "";
            this.SV_BORDER_RGB_FX = "";
        }
    }

    private void setSV_BACKGROUND_COLOR(String backgroundColor) {
        this.SV_BACKGROUND_COLOR = backgroundColor;
        if (!backgroundColor.equals("")) {
            this.SV_BACKGROUND_COLOR_HTML = "background-color: " + this.SV_BACKGROUND_COLOR + ";";
            this.SV_BACKGROUND_COLOR_FX = "-fx-background-color: " + this.SV_BACKGROUND_COLOR + ";";
        } else {
            this.SV_BACKGROUND_COLOR_HTML = "";
            this.SV_BACKGROUND_COLOR_FX = "";
        }
    }

    private void setSV_BACKGROUND_COLOR_HIGHLIGHT(String backgroundHColor) {
        this.SV_BACKGROUND_COLOR_HIGHLIGHT = backgroundHColor;
        this.SV_BACKGROUND_COLOR_HIGHLIGHT_FX = !backgroundHColor.equals("") ? "-fx-background-color: " + this.SV_BACKGROUND_COLOR_HIGHLIGHT + ";" : "";
    }

    public String getOpenPieColor() {
        String s = this.SV_FONT_OPEN1_COLOR_RGB_FX + "";
        return "-fx-pie-color: #" + s.substring(2) + ";";
    }

    public String getNFPieColor() {
        String s = this.SV_FONT_NF_COLOR_RGB_FX + "";
        return "-fx-pie-color: #" + s.substring(2) + ";";
    }

    public String getNAPieColor() {
        String s = this.SV_FONT_NA_COLOR_RGB_FX + "";
        return "-fx-pie-color: #" + s.substring(2) + ";";
    }

    public String getSVFilterHighlight() {
        return this.SV_FILTER_HIGHLIGHT;
    }

    public String getJfxFontSpec() {
        return this.SV_FONT_TYPE_FX + this.SV_FONT_SIZE_FX;
    }

    public String getCombinedPrefSettingsHtml() {
        return this.SV_FONT_COLOR_HTML + this.SV_FONT_TYPE_HTML + this.SV_FONT_SIZE_HTML + this.SV_BACKGROUND_COLOR_HTML;
    }

    public String getJfxTableDefault() {
        return this.SV_BORDER_RGB_FX + this.SV_BACKGROUND_COLOR_FX + "-fx-border-width: .4;";
    }

    public String getJfxTableHighlight() {
        return this.SV_BORDER_RGB_FX + this.SV_BACKGROUND_COLOR_HIGHLIGHT_FX;
    }

    public String getJfxTextBoxStyle() {
        if (!this.SV_BACKGROUND_COLOR_FX.equals("")) {
            return this.SV_BACKGROUND_COLOR_FX + this.SV_FONT_COLOR_FX + "-fx-base: black; -fx-prompt-text-fill: lightgray;";
        }
        return this.SV_BACKGROUND_COLOR_FX + this.SV_FONT_COLOR_FX;
    }

    public String getJfxTextAreaStyle() {
        return this.SV_INNER_BACKGROUND_COLOR_FX + this.SV_FONT_COLOR_FX + this.SV_FONT_TYPE_FX + this.SV_FONT_SIZE_FX;
    }

    public String getJfxBackground() {
        return this.SV_BACKGROUND_COLOR_FX;
    }

    public String getFontSize() {
        return this.SV_FONT_SIZE;
    }

    public String getFontType() {
        return this.SV_FONT_TYPE;
    }

    public String getStyle() {
        return this.SV_STYLE;
    }

    public Color getSV_FONT_DEFAULT_COLOR() {
        return this.SV_FONT_DEFAULT_COLOR_RGB_FX;
    }

    public Color getSV_FONT_NR_COLOR_RGB_FX() {
        return this.SV_FONT_NR_COLOR_RGB_FX;
    }

    public Color getSV_FONT_OPEN1_COLOR_RGB_FX() {
        return this.SV_FONT_OPEN1_COLOR_RGB_FX;
    }

    public Color getSV_FONT_OPEN2_COLOR_RGB_FX() {
        return this.SV_FONT_OPEN2_COLOR_RGB_FX;
    }

    public Color getSV_FONT_OPEN3_COLOR_RGB_FX() {
        return this.SV_FONT_OPEN3_COLOR_RGB_FX;
    }

    public Color getSV_FONT_NAF_COLOR_RGB_FX() {
        return this.SV_FONT_NF_COLOR_RGB_FX;
    }

    public Color getSV_FONT_NA_COLOR_RGB_FX() {
        return this.SV_FONT_NA_COLOR_RGB_FX;
    }

    public static PrefSet getPS() {
        if (Psettings == null) {
            Psettings = new PrefSet();
        }
        return Psettings;
    }

    public double getFontSizeN() {
        return Double.parseDouble(this.SV_FONT_SIZE);
    }
}

