/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.STIGList;

import File_Operations.File_Objects.STIG;
import Program_Tabs.interfaces.STIGDisplayTab;
import Shared_Constructs.STIGList.STIGTableItem;
import Shared_Constructs.STIGList.StigList_Abstract;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class StigList_Checklist
extends StigList_Abstract {
    public StigList_Checklist(STIGDisplayTab Parent2, ArrayList<StigList_Abstract.STIGDispColumn> ColumnSet) {
        super(Parent2, ColumnSet);
    }

    @Override
    public TableView createTable() {
        this.myTable = new TableView();
        this.myTable.setRowFactory(this.getSLRowFactory());
        this.columns = FXCollections.observableArrayList();
        for (StigList_Abstract.STIGDispColumn dc : this.myDispSet) {
            switch (dc) {
                case STIGName: {
                    super.createSTIGNameColumn();
                    this.STIGNameColumn.setVisible(true);
                    this.columns.add((Object)this.STIGNameColumn);
                    break;
                }
                case Score: {
                    this.createScoreColumn();
                    this.ScoreColumn.setVisible(true);
                    this.columns.add((Object)this.ScoreColumn);
                    break;
                }
                case STIGVersion: {
                    this.createSTIGVersionColumn();
                    this.STIGVersionColumn.setVisible(false);
                    this.columns.add((Object)this.STIGVersionColumn);
                    break;
                }
                case ReleaseID: {
                    this.createSTIGReleaseIDColumn();
                    this.STIGReleaseIDColumn.setVisible(false);
                    this.columns.add((Object)this.STIGReleaseIDColumn);
                    break;
                }
                case Check: {
                    this.createSTIGCheckColumn();
                    this.STIGCheckColumn.setVisible(true);
                    this.columns.add((Object)this.STIGCheckColumn);
                    break;
                }
            }
        }
        this.myTable.getColumns().addAll((Collection)this.columns);
        this.myTable.setEditable(true);
        this.myTable.setTableMenuButtonVisible(true);
        this.myTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ContextMenu ctxm = this.createContextMenu();
        this.myTable.setContextMenu(ctxm);
        return this.myTable;
    }

    private ContextMenu createContextMenu() {
        ContextMenu ctxm = new ContextMenu();
        MenuItem SelectAll = new MenuItem("Check All");
        SelectAll.setOnAction(new EventHandler(){

            public void handle(Event t) {
                StigList_Checklist.this.setChecks(true);
            }
        });
        MenuItem DeselectAll = new MenuItem("Uncheck All");
        DeselectAll.setOnAction(new EventHandler(){

            public void handle(Event t) {
                StigList_Checklist.this.setChecks(false);
            }
        });
        MenuItem RemoveHighlighted = new MenuItem("Remove Highlighted STIG(s)");
        RemoveHighlighted.setOnAction(new EventHandler(){

            public void handle(Event t) {
                StigList_Checklist.this.removeHighlighted();
            }
        });
        ctxm.getItems().addAll((Object[])new MenuItem[]{SelectAll, DeselectAll, RemoveHighlighted});
        return ctxm;
    }

    @Override
    public void changeSTIGList(ArrayList<STIG> STIGList) {
        ObservableList CkStigTableItem = FXCollections.observableArrayList();
        for (STIG s : STIGList) {
            CkStigTableItem.add((Object)new STIGTableItem(s, this));
        }
        if (this.STIGNameColumn != null) {
            this.STIGNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGName"));
        }
        if (this.ScoreColumn != null) {
            this.ScoreColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGScore"));
        }
        if (this.STIGVersionColumn != null) {
            this.STIGVersionColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGVersion"));
        }
        if (this.STIGCheckColumn != null) {
            this.STIGCheckColumn.setCellValueFactory((Callback)new PropertyValueFactory("STIGCheck"));
        }
        this.myTable.setItems(CkStigTableItem);
        for (STIGTableItem row : this.myTable.getItems()) {
            row.setIsChecked(false);
        }
        for (STIGTableItem row : this.myTable.getItems()) {
            for (STIG s : this.myParent.getCurrentSTIGs()) {
                if (!row.getSTIG().equals(s)) continue;
                row.setIsChecked(true);
            }
        }
    }

    private void setChecks(boolean onOff) {
        for (STIGTableItem row : this.myTable.getItems()) {
            row.setIsChecked(onOff);
        }
        this.signalStigListUpdate();
    }

    private void removeHighlighted() {
        ArrayList<STIG> incSTIGs = new ArrayList<STIG>();
        for (STIGTableItem row : this.myTable.getSelectionModel().getSelectedItems()) {
            this.myTable.getItems().remove((Object)row);
        }
        for (STIGTableItem row : this.myTable.getItems()) {
            incSTIGs.add(row.getSTIG());
        }
        this.myParent.RemoveSTIGs(incSTIGs);
    }
}

