/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.STIGList;

import File_Operations.File_Objects.STIG;
import Shared_Constructs.STIGList.StigList_Abstract;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class STIGTableItem {
    private final SimpleStringProperty STIGName;
    private final SimpleStringProperty STIGScore;
    private final SimpleStringProperty STIGFileName;
    private final SimpleStringProperty CustomName;
    private final SimpleStringProperty STIGVersion;
    private final SimpleStringProperty ReleaseID;
    private final BooleanProperty STIGCheck;
    private final STIG mySTIG;
    private final StigList_Abstract myParent;

    public STIGTableItem(STIG sSTIG, StigList_Abstract parent) {
        this.mySTIG = sSTIG;
        this.myParent = parent;
        this.CustomName = new SimpleStringProperty(sSTIG.getSTIG_CustomName());
        this.STIGFileName = new SimpleStringProperty(this.mySTIG.getSTIG_FileName_NoExt());
        this.STIGName = new SimpleStringProperty(this.mySTIG.getSTIG_Title());
        this.STIGVersion = new SimpleStringProperty(this.mySTIG.getSTIG_Version());
        this.STIGScore = new SimpleStringProperty(this.mySTIG.getSTIGScore());
        this.STIGCheck = new SimpleBooleanProperty(false);
        this.ReleaseID = this.mySTIG.getReleaseID() >= 1.0f ? new SimpleStringProperty(this.mySTIG.getReleaseID() + "") : (this.mySTIG.getReleaseID() > 0.0f && this.mySTIG.getReleaseID() < 1.0f ? new SimpleStringProperty("DRAFT " + this.mySTIG.getReleaseID()) : new SimpleStringProperty("N/A"));
        this.STIGCheck.addListener(new ChangeListener(){

            public void changed(ObservableValue ov, Object t, Object t1) {
                STIGTableItem.this.myParent.handleCheckChange();
            }
        });
    }

    public String getSTIGName() {
        return this.STIGName.get();
    }

    public String getSTIGFileName() {
        return this.STIGFileName.get();
    }

    public String getCustomName() {
        return this.CustomName.get();
    }

    public String getSTIGVersion() {
        return this.STIGVersion.get();
    }

    public String getReleaseID() {
        return this.ReleaseID.get();
    }

    public UUID getSTIGUUID() {
        return this.mySTIG.getSTIG_UUID();
    }

    public STIG getSTIG() {
        return this.mySTIG;
    }

    public BooleanProperty STIGCheckProperty() {
        return this.STIGCheck;
    }

    public void setIsChecked(boolean b) {
        this.STIGCheck.set(b);
    }

    public boolean bGetIsChecked() {
        return this.STIGCheck.get();
    }

    public String getSTIGScore() {
        return this.STIGScore.get();
    }
}

