/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.Rule_Display;

import Program_Tabs.interfaces.Controller;
import Shared_Constructs.Rule_Display.Abs_Rule_Display;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import stigviewer.STIGViewer;

public class Checklist_Rule_Display
extends Abs_Rule_Display {
    private ChoiceBox StatusBox;
    private ChoiceBox SeverityBox;
    private TextArea FindDetText;
    private TextArea CommentText;
    private String SevJust = "";

    public Checklist_Rule_Display() {
        this.VDisplay.getItems().addAll((Object[])new Node[]{this.setupFDBox(), this.setupComBox()});
        this.RDisplay.getChildren().addAll((Object[])new Node[]{this.setupCklActionBar(), this.VDisplay});
    }

    private VBox setupFDBox() {
        this.FindDetText = new TextArea();
        this.FindDetText.setStyle(PrefSet.getPS().getJfxTextAreaStyle());
        this.FindDetText.setPrefHeight(3000.0);
        this.FindDetText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                for (Controller c : Checklist_Rule_Display.this.DOControllers) {
                    c.Signal_Update("fdetail");
                }
            }
        });
        this.FindDetText.setWrapText(true);
        HBox label = new HBox();
        Text title = new Text("Finding Details");
        label.getChildren().add((Object)title);
        VBox fdBox = new VBox();
        fdBox.getChildren().addAll((Object[])new Node[]{label, this.FindDetText});
        return fdBox;
    }

    private VBox setupComBox() {
        this.CommentText = new TextArea();
        this.CommentText.setStyle(PrefSet.getPS().getJfxTextAreaStyle());
        this.CommentText.setPrefHeight(3000.0);
        this.CommentText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                for (Controller c : Checklist_Rule_Display.this.DOControllers) {
                    c.Signal_Update("comment");
                }
            }
        });
        this.CommentText.setWrapText(true);
        HBox label = new HBox();
        Text title = new Text("Comments");
        label.getChildren().add((Object)title);
        VBox comBox = new VBox();
        comBox.getChildren().addAll((Object[])new Node[]{label, this.CommentText});
        return comBox;
    }

    private HBox setupCklActionBar() {
        HBox titleBox = new HBox(4.0);
        Text StatusText = new Text("  Status: ");
        StatusText.setFont(new Font(PrefSet.getPS().getFontSizeN()));
        Text SevText = new Text("  Severity Override: ");
        SevText.setFont(new Font(PrefSet.getPS().getFontSizeN()));
        this.StatusBox = new ChoiceBox();
        this.SeverityBox = new ChoiceBox();
        this.StatusBox.getItems().setAll(new Object[]{"Not Reviewed", "Open", "Not A Finding", "Not Applicable"});
        this.SeverityBox.getItems().setAll(new Object[]{"CAT I", "CAT II", "CAT III"});
        this.StatusBox.setOnAction(signal -> {
            for (Controller c : this.DOControllers) {
                c.Signal_Update("status");
            }
        });
        this.SeverityBox.setOnAction(signal -> {
            for (Controller c : this.DOControllers) {
                c.Signal_Update("severity");
            }
        });
        titleBox.getChildren().addAll((Object[])new Node[]{StatusText, this.StatusBox, SevText, this.SeverityBox});
        return titleBox;
    }

    EventHandler remStatusEH() {
        EventHandler eh = this.StatusBox.getOnAction();
        return eh;
    }

    void addStatusEH(EventHandler eh) {
        this.StatusBox.setOnAction(eh);
    }

    void setFDBox(String fdText) {
        this.FindDetText.setText(fdText);
    }

    void setComBox(String comText) {
        this.CommentText.setText(comText);
    }

    void setSeverity(String sev) {
        this.SeverityBox.setValue((Object)sev);
    }

    void setStatus(String status) {
        this.StatusBox.getSelectionModel().select((Object)status);
    }

    public void setDividers() {
        this.VDisplay.setDividerPositions(new double[]{0.25, 0.995f, 1.0});
    }

    private void setJust(String j) {
        this.SevJust = j;
    }

    public void clearSevJust() {
        this.SevJust = "";
    }

    void changeBodyBorder() {
        String stat = (String)this.StatusBox.getSelectionModel().getSelectedItem();
        if (stat == null) {
            stat = "";
        }
        switch (stat) {
            case "Not Reviewed": {
                this.VDisplay.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)PrefSet.getPS().getSV_FONT_NR_COLOR_RGB_FX(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.2))}));
                break;
            }
            case "Open": {
                this.VDisplay.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)PrefSet.getPS().getSV_FONT_OPEN1_COLOR_RGB_FX(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.2))}));
                break;
            }
            case "Not A Finding": {
                this.VDisplay.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)PrefSet.getPS().getSV_FONT_NAF_COLOR_RGB_FX(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.2))}));
                break;
            }
            case "Not Applicable": {
                this.VDisplay.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)PrefSet.getPS().getSV_FONT_NA_COLOR_RGB_FX(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.2))}));
                break;
            }
        }
    }

    public String getCommentAreaText() {
        return this.CommentText.getText();
    }

    public String getFDetailAreaText() {
        return this.FindDetText.getText();
    }

    public String getSelectedSeverity() {
        String tmp = (String)this.SeverityBox.getValue();
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public int getSelectedStatus() {
        return this.StatusBox.getSelectionModel().getSelectedIndex();
    }

    public String getSevJust() {
        return this.SevJust;
    }

    public void getsetSevOverJust(String ovrr) {
        Stage getJust = new Stage();
        getJust.initModality(Modality.WINDOW_MODAL);
        getJust.initOwner(STIGViewer.getSV().getPrimaryStage().getScene().getWindow());
        VBox vb1 = new VBox(20.0);
        TextArea tfJust = new TextArea();
        HBox hb1 = new HBox(20.0);
        vb1.getChildren().addAll((Object[])new Node[]{new Text("Enter Severity Override Justifcation: " + ovrr), tfJust, hb1});
        Scene getJustScene = new Scene((Parent)vb1, 300.0, 200.0);
        getJust.setScene(getJustScene);
        getJust.setTitle("Severity Override Justification");
        Button bSubmit = new Button("OK");
        bSubmit.setOnAction(event -> {
            if (!tfJust.getText().equals("")) {
                this.setJust(tfJust.getText());
            }
            getJust.close();
        });
        Button bCancel = new Button("Cancel");
        bCancel.setOnAction(event -> getJust.close());
        hb1.getChildren().addAll((Object[])new Node[]{bCancel, bSubmit});
        getJust.showAndWait();
    }

    @Override
    public void graphicsUpdate() {
        for (Controller c : this.DOControllers) {
            c.Signal_Update("c");
        }
        this.CommentText.setStyle(PrefSet.getPS().getJfxTextAreaStyle());
        this.FindDetText.setStyle(PrefSet.getPS().getJfxTextAreaStyle());
    }

    @Override
    public List<DisplayObject> getChildDisplayObjects() {
        return new ArrayList<DisplayObject>();
    }

    public TextArea getComPanel() {
        return this.CommentText;
    }

    public TextArea getFDPanel() {
        return this.FindDetText;
    }

    public ChoiceBox getStatusBox() {
        return this.StatusBox;
    }
}

