/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.Legacy.STIGDataView;

import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import Program_Tabs.interfaces.DisplayTab;
import Shared_Constructs.FilteredEventDispatcher;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import Utility_Code.GlobalSettings.Util;
import Utility_Code.Static_Methods.TextReplace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class STIG_DataViews {
    private final DisplayTab myParent;
    private final boolean bIsCheckList;
    private WebView STIGInfoTextArea;
    ToggleGroup CheckStatusToggleGroup;
    private ChoiceBox StatusBox;
    private ChoiceBox SevOverride;
    private WebView DiscussionTextArea;
    private WebView CheckContentTextArea;
    private WebView FixTextTextArea;
    private WebView CCITextArea;
    private WebView MiscTextArea;
    private final String NL = "\n";

    public STIG_DataViews(DisplayTab parent, boolean IsCheckList) {
        this.myParent = parent;
        this.bIsCheckList = IsCheckList;
        this.CheckStatusToggleGroup = new ToggleGroup();
    }

    public VBox createSTIGInfoTextArea() {
        VBox content = new VBox(1.0);
        this.STIGInfoTextArea = new WebView();
        this.STIGInfoTextArea.setStyle("-fx-font-size: 14; -fx-font-family: Segoe UI; -fx-font-weight: normal;");
        this.STIGInfoTextArea.setPrefHeight(1000.0);
        FilteredEventDispatcher.register((Node)this.STIGInfoTextArea);
        content.getChildren().add((Object)this.STIGInfoTextArea);
        if (this.bIsCheckList) {
            this.STIGInfoTextArea.setMinWidth(400.0);
            Label CheckStatusLabel = new Label("Status: ");
            CheckStatusLabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)14.0));
            CheckStatusLabel.setMinWidth(50.0);
            CheckStatusLabel.setAlignment(Pos.CENTER_RIGHT);
            final RadioButton NotReviewedStatusButton = new RadioButton("Not Reviewed");
            final RadioButton OpenStatusButton = new RadioButton("Open");
            final RadioButton NotAFindingStatusButton = new RadioButton("Not a Finding");
            final RadioButton NotApplicableStatusButton = new RadioButton("Not Applicable");
            HBox CheckStatusHBox = new HBox(5.0);
            CheckStatusHBox.setPadding(new Insets(10.0));
            this.StatusBox = new ChoiceBox();
            this.StatusBox.getItems().addAll(new Object[]{"Not Reviewed", "Open", "Not a Finding", "Not Applicable"});
            this.StatusBox.setStyle("-fx-font:10pt");
            this.StatusBox.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    switch ((String)STIG_DataViews.this.StatusBox.getSelectionModel().getSelectedItem()) {
                        case "Open": {
                            OpenStatusButton.fire();
                            break;
                        }
                        case "Not a Finding": {
                            NotAFindingStatusButton.fire();
                            break;
                        }
                        case "Not Applicable": {
                            NotApplicableStatusButton.fire();
                            break;
                        }
                        case "Not Reviewed": {
                            NotReviewedStatusButton.fire();
                            break;
                        }
                    }
                    STIG_DataViews.this.myParent.updateDisplay();
                }
            });
            NotReviewedStatusButton.setUserData((Object)0);
            NotReviewedStatusButton.setToggleGroup(this.CheckStatusToggleGroup);
            NotReviewedStatusButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    STIG_DataViews.this.vulnStatusChange(Vuln.CheckState.Not_Reviewed);
                    Logger.getLogger(STIG_DataViews.class.getName()).log(Level.INFO, "INFO: DV: NR Toggle");
                }
            });
            OpenStatusButton.setUserData((Object)1);
            OpenStatusButton.setToggleGroup(this.CheckStatusToggleGroup);
            OpenStatusButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    STIG_DataViews.this.vulnStatusChange(Vuln.CheckState.Open);
                    Logger.getLogger(STIG_DataViews.class.getName()).log(Level.INFO, "INFO: DV: O Toggle");
                }
            });
            NotAFindingStatusButton.setUserData((Object)2);
            NotAFindingStatusButton.setToggleGroup(this.CheckStatusToggleGroup);
            NotAFindingStatusButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    STIG_DataViews.this.vulnStatusChange(Vuln.CheckState.NotAFinding);
                    Logger.getLogger(STIG_DataViews.class.getName()).log(Level.INFO, "INFO: DV: NF Toggle");
                }
            });
            NotApplicableStatusButton.setUserData((Object)3);
            NotApplicableStatusButton.setToggleGroup(this.CheckStatusToggleGroup);
            NotApplicableStatusButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    STIG_DataViews.this.vulnStatusChange(Vuln.CheckState.Not_Applicable);
                    Logger.getLogger(STIG_DataViews.class.getName()).log(Level.INFO, "INFO: DV: NA Toggle");
                }
            });
            this.SevOverride = new ChoiceBox();
            this.SevOverride.getItems().addAll(new Object[]{"Severity Override", "CAT I", "CAT II", "CAT III"});
            this.SevOverride.getSelectionModel().select(0);
            this.SevOverride.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue ov, Number value, Number new_value) {
                    String sSOCheck = STIG_DataViews.this.myParent.GetCurrentSelectedVul().getCheckSevOverride();
                    if (sSOCheck.equals("")) {
                        sSOCheck = STIG_DataViews.this.myParent.GetCurrentSelectedVul().getAttr(Vuln.VulnAttr.Severity);
                    }
                    if (!value.equals(new_value)) {
                        switch (new_value.intValue()) {
                            case 1: {
                                if (sSOCheck.equals("high")) break;
                                STIG_DataViews.this.getsetSevOverJust("high");
                                break;
                            }
                            case 2: {
                                if (sSOCheck.equals("medium")) break;
                                STIG_DataViews.this.getsetSevOverJust("medium");
                                break;
                            }
                            case 3: {
                                if (sSOCheck.equals("low")) break;
                                STIG_DataViews.this.getsetSevOverJust("low");
                                break;
                            }
                            default: {
                                if (sSOCheck.equals("")) break;
                                STIG_DataViews.this.myParent.GetCurrentSelectedVul().setCheckSevOverride("");
                                STIG_DataViews.this.myParent.GetCurrentSelectedVul().setCheckSevJust("");
                            }
                        }
                    }
                }
            });
            CheckStatusHBox.getChildren().addAll((Object[])new Node[]{CheckStatusLabel, NotReviewedStatusButton, OpenStatusButton, NotAFindingStatusButton, NotApplicableStatusButton, this.SevOverride});
            CheckStatusHBox.setAlignment(Pos.TOP_LEFT);
            content.getChildren().add((Object)CheckStatusHBox);
        }
        return content;
    }

    private void vulnStatusChange(Vuln.CheckState state) {
        ArrayList<Vuln> vuls = this.myParent.GetCurrentSelectedVuls();
        if (vuls != null) {
            for (Vuln v : vuls) {
                v.setCheckState(state);
            }
            this.myParent.updateDisplay();
        }
    }

    private void getsetSevOverJust(String sOverride) {
        final Stage getJust = new Stage();
        final String sOVR = sOverride;
        getJust.initModality(Modality.WINDOW_MODAL);
        getJust.initOwner(this.myParent.getPrimaryStage().getScene().getWindow());
        VBox vb1 = new VBox(20.0);
        final TextArea tfJust = new TextArea();
        HBox hb1 = new HBox(20.0);
        String sText = "";
        switch (sOverride) {
            case "high": {
                sText = "CAT I";
                break;
            }
            case "medium": {
                sText = "CAT II";
                break;
            }
            case "low": {
                sText = "CAT III";
            }
        }
        vb1.getChildren().addAll((Object[])new Node[]{new Text("Enter Severity Override Justifcation: " + sText), tfJust, hb1});
        Scene getJustScene = new Scene((Parent)vb1, 300.0, 200.0);
        getJust.setScene(getJustScene);
        getJust.setTitle("Severity Override Justification");
        getJust.show();
        getJust.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                STIG_DataViews.this.myParent.updateDisplay();
            }
        });
        Button bSubmit = new Button("OK");
        bSubmit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String sJustification = "";
                sJustification = tfJust.getText();
                if (!sJustification.equals("")) {
                    Logger.getLogger(STIG_DataViews.class.getName()).log(Level.INFO, "INFO: DV: Severity Change");
                    STIG_DataViews.this.myParent.GetCurrentSelectedVul().setCheckSevOverride(sOVR);
                    STIG_DataViews.this.myParent.GetCurrentSelectedVul().setCheckSevJust(sJustification);
                }
                getJust.close();
                STIG_DataViews.this.myParent.updateDisplay();
            }
        });
        Button bCancel = new Button("Cancel");
        bCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                STIG_DataViews.this.myParent.GetCurrentSelectedVul().setCheckSevOverride("");
                STIG_DataViews.this.myParent.GetCurrentSelectedVul().setCheckSevJust("");
                getJust.close();
                STIG_DataViews.this.myParent.updateDisplay();
            }
        });
        hb1.getChildren().addAll((Object[])new Node[]{bCancel, bSubmit});
    }

    public WebView createDiscussionTextArea() {
        this.DiscussionTextArea = new WebView();
        this.DiscussionTextArea.setPrefHeight(1000.0);
        FilteredEventDispatcher.register((Node)this.DiscussionTextArea);
        return this.DiscussionTextArea;
    }

    public WebView createCheckContentTextArea() {
        this.CheckContentTextArea = new WebView();
        this.CheckContentTextArea.setPrefHeight(1000.0);
        FilteredEventDispatcher.register((Node)this.CheckContentTextArea);
        return this.CheckContentTextArea;
    }

    public WebView createFixTextTextArea() {
        this.FixTextTextArea = new WebView();
        this.FixTextTextArea.setPrefHeight(1000.0);
        FilteredEventDispatcher.register((Node)this.FixTextTextArea);
        return this.FixTextTextArea;
    }

    public WebView createCCITextArea() {
        this.CCITextArea = new WebView();
        this.CCITextArea.setPrefHeight(1000.0);
        FilteredEventDispatcher.register((Node)this.CCITextArea);
        return this.CCITextArea;
    }

    public WebView createMiscTextArea() {
        this.MiscTextArea = new WebView();
        this.MiscTextArea.setPrefHeight(1000.0);
        FilteredEventDispatcher.register((Node)this.MiscTextArea);
        return this.MiscTextArea;
    }

    public boolean updateSTIGInfoTextArea(Vuln currVuln, Map<String, ArrayList<String>> Highlights) {
        boolean bRet = true;
        if (currVuln != null && !currVuln.isEmpty()) {
            String Severity = "";
            switch (currVuln.getAttr(Vuln.VulnAttr.Severity)) {
                case "medium": {
                    Severity = "CAT II";
                    break;
                }
                case "low": {
                    Severity = "CAT III";
                    break;
                }
                case "high": {
                    Severity = "CAT I";
                    break;
                }
                default: {
                    Severity = currVuln.getAttr(Vuln.VulnAttr.Severity);
                }
            }
            String sRuleInfo = "";
            sRuleInfo = sRuleInfo + "<body style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><table align='center'><tr><td><b><center style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(currVuln.getAttr(Vuln.VulnAttr.STIGRef)), (List<String>)Highlights.get("General")) + "</center></b></td></tr><tr><td style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><b>Rule Title:</b> " + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(currVuln.getAttr(Vuln.VulnAttr.Rule_Title)), (List<String>)Highlights.get("RuleTitle")) + "</td></tr><tr><td><table align='center'><tr><td><table style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><tr><td><b>STIG ID:</b></td><td>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(currVuln.getAttr(Vuln.VulnAttr.Rule_Ver)), (List<String>)Highlights.get("STIGID")) + "</td></tr><tr><td><b>Rule ID:</b></td><td>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(currVuln.getAttr(Vuln.VulnAttr.Rule_ID)), (List<String>)Highlights.get("RuleID")) + "</td></tr><tr><td><b>Vul ID:</b></td><td>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(currVuln.getAttr(Vuln.VulnAttr.Vuln_Num)), (List<String>)Highlights.get("VulnID")) + "</td></tr></table></td><td><table valign='top' style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><tr><td><b>Severity:</b></td><td>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(Severity), (List<String>)Highlights.get("Severity")) + "</td></tr><tr><td><b>Class:</b></td><td>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(currVuln.getAttr(Vuln.VulnAttr.Class)), (List<String>)Highlights.get("General")) + "</td></tr></table></td></tr></table></td></tr></table></body>";
            this.STIGInfoTextArea.getEngine().loadContent(sRuleInfo);
            if (this.bIsCheckList) {
                switch (currVuln.getCheckSevOverride()) {
                    case "high": {
                        this.SevOverride.getSelectionModel().select(1);
                        break;
                    }
                    case "medium": {
                        this.SevOverride.getSelectionModel().select(2);
                        break;
                    }
                    case "low": {
                        this.SevOverride.getSelectionModel().select(3);
                        break;
                    }
                    default: {
                        this.SevOverride.getSelectionModel().select(0);
                    }
                }
            }
        } else {
            bRet = false;
            this.STIGInfoTextArea.getEngine().loadContent("");
        }
        return bRet;
    }

    public boolean updateDiscussionTextArea(Vuln currVuln, List<String> Highlights) {
        boolean bRet = true;
        if (currVuln != null) {
            String sTemp = "";
            sTemp = currVuln.getAttr(Vuln.VulnAttr.Vuln_Discuss);
            if (sTemp.equals("")) {
                bRet = false;
            }
            this.DiscussionTextArea.getEngine().loadContent("<body style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><div>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(sTemp), Highlights) + "</div></body>");
        } else {
            bRet = false;
            this.DiscussionTextArea.getEngine().loadContent("");
        }
        return bRet;
    }

    public boolean updateCheckContentTextArea(Vuln currVuln, List<String> Highlights) {
        boolean bRet = true;
        if (currVuln != null) {
            String sTemp = "";
            sTemp = currVuln.getAttr(Vuln.VulnAttr.Check_Content);
            if (sTemp.equals("")) {
                bRet = false;
            }
            this.CheckContentTextArea.getEngine().loadContent("<body style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><div>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(sTemp), Highlights) + "</div></body>");
        } else {
            bRet = false;
            this.CheckContentTextArea.getEngine().loadContent("");
        }
        return bRet;
    }

    public boolean updateFixTextTextArea(Vuln currVuln, List<String> Highlights) {
        boolean bRet = true;
        if (currVuln != null) {
            String sTemp = "";
            sTemp = currVuln.getAttr(Vuln.VulnAttr.Fix_Text);
            if (sTemp.equals("")) {
                bRet = false;
            }
            this.FixTextTextArea.getEngine().loadContent("<body style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><div>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(sTemp), Highlights) + "</div></body>");
        } else {
            bRet = false;
            this.FixTextTextArea.getEngine().loadContent("");
        }
        return bRet;
    }

    public boolean updateCCITextArea(Vuln currVuln, List<String> Highlights, boolean bSTIGHasCCI) {
        boolean bRet = true;
        if (currVuln != null) {
            this.CCITextArea.getEngine().loadContent("");
            if (bSTIGHasCCI) {
                ArrayList<CCIReader.CCI_Store> CCIs = currVuln.GetCCIs();
                if (CCIs.size() == currVuln.GetCCIVals().size() && currVuln.GetCCIVals().size() > 0) {
                    String sText = "";
                    for (String sCCI : currVuln.GetCCIVals()) {
                        sText = sText + "CCI: ";
                        sText = sText + sCCI + "\n";
                        CCIReader.CCI_Store cci = currVuln.GetCCIbyName(sCCI);
                        if (cci != null) {
                            sText = sText + cci.sDefinition + "\n";
                            for (int k = 0; k < cci.sRefs.size(); ++k) {
                                sText = sText + cci.sRefs.get(k).getFirst() + " :: " + cci.sRefs.get(k).getSecond() + "\n";
                            }
                        }
                        sText = sText + "\n";
                    }
                    if (!Util.bHasAlphNum(sText)) {
                        bRet = false;
                    } else {
                        this.CCITextArea.getEngine().loadContent("<body style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><div>" + TextReplace.Highlight(TextReplace.NLToBreak_LtGtSwap(sText), Highlights) + "</div></body>");
                    }
                } else {
                    bRet = false;
                }
            } else {
                bRet = false;
            }
        } else {
            bRet = false;
            this.CCITextArea.getEngine().loadContent("");
        }
        return bRet;
    }

    public boolean updateMiscTextArea(Vuln currVuln, List<String> Highlights) {
        boolean bRet = true;
        if (currVuln != null) {
            ArrayList<Vuln.VulnAttr> MiscAttributes = new ArrayList<Vuln.VulnAttr>();
            MiscAttributes.add(Vuln.VulnAttr.IA_Controls);
            MiscAttributes.add(Vuln.VulnAttr.False_Negatives);
            MiscAttributes.add(Vuln.VulnAttr.False_Positives);
            MiscAttributes.add(Vuln.VulnAttr.Mitigation_Control);
            MiscAttributes.add(Vuln.VulnAttr.Mitigations);
            MiscAttributes.add(Vuln.VulnAttr.Potential_Impact);
            MiscAttributes.add(Vuln.VulnAttr.Security_Override_Guidance);
            MiscAttributes.add(Vuln.VulnAttr.Third_Party_Tools);
            String sText = "";
            for (Vuln.VulnAttr vi : MiscAttributes) {
                String sMisc = currVuln.getAttr(vi);
                if (sMisc.equals("")) continue;
                if (!vi.equals((Object)Vuln.VulnAttr.IA_Controls)) {
                    sText = sText + vi.toString() + ":" + "\n";
                    sText = sText + sMisc + "\n" + "\n";
                    continue;
                }
                sText = sText + vi.toString() + ":" + "\n";
                sText = sText + TextReplace.Highlight(sMisc, Highlights) + "\n" + "\n";
            }
            if (sText.equals("")) {
                bRet = false;
            }
            this.MiscTextArea.getEngine().loadContent("<body style='" + PrefSet.getPS().getCombinedPrefSettingsHtml() + "'><div>" + TextReplace.NLToBreak_LtGtSwap(sText) + "</div></body>");
        } else {
            bRet = false;
            this.MiscTextArea.getEngine().loadContent("");
        }
        return bRet;
    }

    public ToggleGroup getCheckToggleGroup() {
        return this.CheckStatusToggleGroup;
    }
}

