/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.Legacy.STIGDataView;

import Program_Tabs.Tab_Checklist.ChecklistViewTab;
import Shared_Constructs.Legacy.STIGDataView.STIG_DataViews;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class Ckl_SDV_Setup {
    private final TitledPane STIGInfoTP;
    private final TabPane VulnTabPane;
    private final Tab DiscussionTab;
    private final Tab CheckContentTab;
    private final Tab FixTextTab;
    private final Tab CCITab;
    private final Tab MiscTab;
    private VBox STIGInfoVB;
    private VBox BottomHalfRightColumnVBox;
    private TextArea FindingDetailsTextArea;
    private TextArea CommentsTextArea;
    private STIG_DataViews SDV;
    private TitledPane STIGDataTP;
    private VBox RightPane;

    public Ckl_SDV_Setup(final ChecklistViewTab vt, boolean isCkl) {
        this.SDV = new STIG_DataViews(vt, true);
        this.STIGInfoTP = new TitledPane();
        this.STIGInfoTP.setText("General Information");
        this.STIGInfoVB = new VBox(2.0);
        this.STIGInfoVB.getChildren().addAll((Object[])new Node[]{this.SDV.createSTIGInfoTextArea()});
        this.STIGInfoTP.setContent((Node)this.STIGInfoVB);
        this.VulnTabPane = new TabPane();
        this.VulnTabPane.setMinWidth(5.0);
        Label DiscussionLabel = new Label("Discussion");
        DiscussionLabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.DiscussionTab = new Tab();
        this.DiscussionTab.setClosable(false);
        this.DiscussionTab.setContent((Node)this.SDV.createDiscussionTextArea());
        this.DiscussionTab.setText(DiscussionLabel.getText());
        Label CheckContentLabel = new Label("Check Content");
        CheckContentLabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.CheckContentTab = new Tab();
        this.CheckContentTab.setClosable(false);
        this.CheckContentTab.setContent((Node)this.SDV.createCheckContentTextArea());
        this.CheckContentTab.setText(CheckContentLabel.getText());
        Label FixTextLabel = new Label("Fix Text");
        FixTextLabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.FixTextTab = new Tab();
        this.FixTextTab.setClosable(false);
        this.FixTextTab.setContent((Node)this.SDV.createFixTextTextArea());
        this.FixTextTab.setText(FixTextLabel.getText());
        Label CCILabel = new Label("CCI");
        CCILabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.CCITab = new Tab();
        this.CCITab.setClosable(false);
        this.CCITab.setContent((Node)this.SDV.createCCITextArea());
        this.CCITab.setText(CCILabel.getText());
        Label MiscLabel = new Label("Misc");
        MiscLabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)12.0));
        this.MiscTab = new Tab();
        this.MiscTab.setClosable(false);
        this.MiscTab.setContent((Node)this.SDV.createMiscTextArea());
        this.MiscTab.setText(MiscLabel.getText());
        this.VulnTabPane.getTabs().addAll((Object[])new Tab[]{this.DiscussionTab, this.CheckContentTab, this.FixTextTab, this.CCITab, this.MiscTab});
        this.STIGDataTP = new TitledPane();
        this.STIGDataTP.setText("Vul Information");
        this.STIGDataTP.setContent((Node)this.VulnTabPane);
        TitledPane FindingDetailsTP = new TitledPane();
        FindingDetailsTP.setText("Finding Details");
        this.FindingDetailsTextArea = new TextArea();
        this.FindingDetailsTextArea.setMinHeight(100.0);
        this.FindingDetailsTextArea.setWrapText(true);
        FindingDetailsTP.setContent((Node)this.FindingDetailsTextArea);
        this.FindingDetailsTextArea.setStyle(PrefSet.getPS().getJfxTextAreaStyle());
        this.FindingDetailsTextArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                vt.getCklDrive().getCurrentVuln().setCHK_Notes(newValue);
            }
        });
        TitledPane CommentsTP = new TitledPane();
        CommentsTP.setText("Comments");
        this.CommentsTextArea = new TextArea();
        this.CommentsTextArea.setWrapText(true);
        this.CommentsTextArea.setMinHeight(100.0);
        CommentsTP.setContent((Node)this.CommentsTextArea);
        this.CommentsTextArea.setStyle(PrefSet.getPS().getJfxTextAreaStyle());
        this.CommentsTextArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                vt.getCklDrive().getCurrentVuln().setCheckComment(newValue);
            }
        });
        this.BottomHalfRightColumnVBox = new VBox(2.0);
        this.BottomHalfRightColumnVBox.setPrefWidth(400.0);
        this.BottomHalfRightColumnVBox.getChildren().addAll((Object[])new Node[]{FindingDetailsTP, CommentsTP});
        VBox.setVgrow((Node)this.STIGDataTP, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)FindingDetailsTP, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)CommentsTP, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.BottomHalfRightColumnVBox, (Priority)Priority.ALWAYS);
        this.RightPane = new VBox();
        this.RightPane.setFillWidth(true);
        this.RightPane.setMinWidth(5.0);
        this.RightPane.setPrefWidth(600.0);
        VBox.setVgrow((Node)this.RightPane, (Priority)Priority.ALWAYS);
        this.RightPane.getChildren().addAll((Object[])new Node[]{this.STIGInfoTP, this.STIGDataTP, this.BottomHalfRightColumnVBox});
    }

    public STIG_DataViews getSDV() {
        return this.SDV;
    }

    public VBox getRCVBox() {
        return this.RightPane;
    }

    public TextArea getFDPanel() {
        return this.FindingDetailsTextArea;
    }

    public TextArea getComPanel() {
        return this.CommentsTextArea;
    }

    public void clearVulnDisp() {
        this.STIGInfoTP.setContent(null);
        this.VulnTabPane.getTabs().clear();
    }

    public void addPan(int i) {
        switch (i) {
            case 0: {
                this.STIGInfoTP.setContent((Node)this.STIGInfoVB);
                break;
            }
            case 1: {
                this.VulnTabPane.getTabs().add((Object)this.DiscussionTab);
                break;
            }
            case 2: {
                this.VulnTabPane.getTabs().add((Object)this.CheckContentTab);
                break;
            }
            case 3: {
                this.VulnTabPane.getTabs().add((Object)this.FixTextTab);
                break;
            }
            case 4: {
                this.VulnTabPane.getTabs().add((Object)this.CCITab);
                break;
            }
            case 5: {
                this.VulnTabPane.getTabs().add((Object)this.MiscTab);
                break;
            }
        }
    }

    public TabPane getVulnTabPane() {
        return this.VulnTabPane;
    }
}

