/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.Filter.Parents;

import File_Operations.File_Objects.Vuln;
import Program_Tabs.interfaces.GuiDriver;
import Shared_Constructs.Filter.Parents.FilterEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class StringFilter
implements FilterEvent {
    protected ArrayList<Vuln> visible;
    protected String filterString;
    protected Boolean filterBool;
    protected GuiDriver.FilterMode filterMode = GuiDriver.FilterMode.ALL;
    protected HashMap<String, Boolean> filterStringList;

    protected StringFilter() {
        this.visible = new ArrayList();
        this.filterStringList = new HashMap();
    }

    @Override
    public void updateFilter(ArrayList<Vuln> vis) {
        this.visible = (ArrayList)vis.clone();
    }

    @Override
    public boolean addFilter(String filt, Boolean InEx) {
        boolean trigger = true;
        HashMap filtListTemp = (HashMap)this.filterStringList.clone();
        if (!this.filterStringList.isEmpty()) {
            for (Map.Entry val : filtListTemp.entrySet()) {
                if (!filt.equals((String)val.getKey())) continue;
                trigger = false;
            }
        }
        if (trigger) {
            this.filterString = filt;
            this.filterBool = InEx;
            this.filterStringList.put(filt, InEx);
            this.filter();
        }
        return trigger;
    }

    @Override
    public void removeFilter(String remFilt, Boolean type) {
        HashMap filtListTemp = (HashMap)this.filterStringList.clone();
        if (!this.filterStringList.isEmpty()) {
            for (Map.Entry val : filtListTemp.entrySet()) {
                if (!remFilt.equals((String)val.getKey()) || !type.equals((Boolean)val.getValue())) continue;
                this.filterStringList.remove((String)val.getKey());
            }
            this.filterString = "";
        }
    }

    @Override
    public ArrayList<Vuln> reFilter() {
        if (!this.filterStringList.isEmpty()) {
            Iterator<Map.Entry<String, Boolean>> i = this.filterStringList.entrySet().iterator();
            if (this.filterMode == GuiDriver.FilterMode.ALL) {
                while (i.hasNext()) {
                    Map.Entry<String, Boolean> val = i.next();
                    this.filterString = val.getKey();
                    this.filterBool = val.getValue();
                    this.filter();
                }
            } else if (this.filterMode == GuiDriver.FilterMode.ANY) {
                HashSet<Vuln> filteredSet = new HashSet<Vuln>();
                ArrayList master = (ArrayList)this.visible.clone();
                while (i.hasNext()) {
                    Map.Entry<String, Boolean> val = i.next();
                    this.filterString = val.getKey();
                    this.filterBool = val.getValue();
                    this.visible = (ArrayList)master.clone();
                    this.filter();
                    filteredSet.addAll(this.visible);
                }
                this.visible = new ArrayList(filteredSet);
            }
        }
        return (ArrayList)this.visible.clone();
    }

    @Override
    public void setFilterMode(GuiDriver.FilterMode mode) {
        this.filterMode = mode;
    }

    @Override
    public boolean isActive() {
        return !this.filterStringList.isEmpty();
    }
}

