/*
 * Decompiled with CFR 0.152.
 */
package Shared_Constructs.Filter.GUI;

import Program_Tabs.interfaces.DisplayTab;
import Program_Tabs.interfaces.GuiDriver;
import Shared_Constructs.Filter.GUI.FilterTableRecord;
import Shared_Constructs.Filter.Parents.FilterEvent;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.util.Callback;

public class FilterPane
extends DisplayObject {
    private final GuiDriver myDriver;
    private final DisplayTab myParent;
    private TableView<FilterTableRecord> CurrentListOfFilters;
    private HashMap<String, ArrayList<String>> FilterTextMap;
    private TextField FilterInputField;
    private String filterSelection;
    private String FilterText;
    private List<FilterEvent> Filters;
    private FilterEvent CurrentFilter;

    public FilterPane(DisplayTab Parent2, GuiDriver Driver) {
        this.myParent = Parent2;
        this.myDriver = Driver;
        this.CurrentFilter = null;
    }

    public TitledPane createFilterPane() {
        final ComboBox FilterKind = new ComboBox();
        this.Filters = this.myDriver.getFilters();
        this.initFilterTextMap();
        Label allAnyLabel = new Label("Must match:");
        ToggleGroup tgAllAny = new ToggleGroup();
        RadioButton filterAllButton = new RadioButton("All");
        filterAllButton.setMinWidth(40.0);
        filterAllButton.setAlignment(Pos.CENTER);
        filterAllButton.setToggleGroup(tgAllAny);
        filterAllButton.fire();
        RadioButton filterAnyButton = new RadioButton("Any");
        filterAnyButton.setMinWidth(40.0);
        filterAnyButton.setAlignment(Pos.CENTER);
        filterAnyButton.setToggleGroup(tgAllAny);
        tgAllAny.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == filterAllButton) {
                this.myDriver.setFilterMode(GuiDriver.FilterMode.ALL);
            } else if (newValue == filterAnyButton) {
                this.myDriver.setFilterMode(GuiDriver.FilterMode.ANY);
            }
            this.myDriver.filterRun();
            this.myParent.changeVulnList(this.myDriver.getVisibleVulnList());
        });
        final ToggleGroup tgFilters = new ToggleGroup();
        final RadioButton AddInclusiveFilterButton = new RadioButton("Inclusive (+) Filter");
        AddInclusiveFilterButton.setMinWidth(97.0);
        AddInclusiveFilterButton.setAlignment(Pos.CENTER);
        AddInclusiveFilterButton.setToggleGroup(tgFilters);
        AddInclusiveFilterButton.fire();
        RadioButton AddExclusiveFilterButton = new RadioButton("Exclusive (-) Filter");
        AddExclusiveFilterButton.setMinWidth(97.0);
        AddExclusiveFilterButton.setAlignment(Pos.CENTER);
        AddExclusiveFilterButton.setToggleGroup(tgFilters);
        this.CurrentListOfFilters = new TableView();
        this.CurrentListOfFilters.setPrefHeight(3000.0);
        TableColumn inExclusive = new TableColumn("+ / -");
        inExclusive.setCellValueFactory((Callback)new PropertyValueFactory("InExclusive"));
        TableColumn filterName = new TableColumn("Keyword");
        filterName.setCellValueFactory((Callback)new PropertyValueFactory("FilterName"));
        TableColumn filterType = new TableColumn("Filter");
        filterType.setCellValueFactory((Callback)new PropertyValueFactory("FilterType"));
        final ObservableList data = FXCollections.observableArrayList();
        this.CurrentListOfFilters.setItems(data);
        this.CurrentListOfFilters.getColumns().addAll((Object[])new TableColumn[]{inExclusive, filterName, filterType});
        this.CurrentListOfFilters.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setFilterTableGraphics();
        this.CurrentListOfFilters.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        final Button AddFilter = new Button("Add");
        AddFilter.setMinWidth(40.0);
        AddFilter.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String tgString = "-";
                Boolean filBool = false;
                if (tgFilters.getSelectedToggle().equals(AddInclusiveFilterButton)) {
                    tgString = "+";
                    filBool = true;
                }
                if (FilterPane.this.CurrentFilter != null && !FilterPane.this.FilterText.equals("")) {
                    FilterPane.this.CurrentFilter.updateFilter(FilterPane.this.myDriver.getVisibleVulnList());
                    if (FilterPane.this.CurrentFilter.addFilter(FilterPane.this.FilterText, filBool)) {
                        data.add((Object)new FilterTableRecord(tgString, FilterPane.this.FilterText, FilterPane.this.filterSelection));
                        if (FilterPane.this.myDriver.getFilterMode() == GuiDriver.FilterMode.ALL) {
                            FilterPane.this.myParent.changeVulnList(FilterPane.this.CurrentFilter.filter());
                        } else if (FilterPane.this.myDriver.getFilterMode() == GuiDriver.FilterMode.ANY) {
                            FilterPane.this.myDriver.filterRun();
                            FilterPane.this.myParent.changeVulnList(FilterPane.this.myDriver.getVisibleVulnList());
                        }
                        String choice = (String)FilterKind.getSelectionModel().getSelectedItem();
                        Logger.getLogger(FilterPane.class.getName()).log(Level.INFO, "INFO: Filter: Filter Added With Parameters: " + tgString + " " + FilterPane.this.filterSelection + " " + FilterPane.this.FilterText);
                        if (!choice.contains("CAT")) {
                            FilterPane.this.FilterText = "";
                        }
                    }
                }
                if (FilterPane.this.FilterInputField.isEditable()) {
                    FilterPane.this.FilterInputField.clear();
                }
            }
        });
        TitledPane FilterTP = new TitledPane();
        FilterTP.setText("Filter Panel");
        VBox Content = new VBox(2.0);
        HBox AddFilterButtonsContainer = new HBox(5.0);
        HBox RemoveFilterButtonsContainer = new HBox(5.0);
        this.FilterInputField = new TextField();
        this.FilterInputField.setMinHeight(20.0);
        this.FilterInputField.setPromptText("Enter filter keyword");
        this.FilterInputField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.FilterInputField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode().equals((Object)KeyCode.ENTER)) {
                    AddFilter.fire();
                }
            }
        });
        this.FilterInputField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FilterPane.this.FilterText = FilterPane.this.FilterInputField.getText();
                FilterPane.this.FilterText = FilterPane.this.inputTranslate(FilterPane.this.FilterText);
            }
        });
        HBox filterTypeBox = new HBox();
        FilterKind.setPromptText("Select Filter");
        FilterKind.getItems().addAll(new Object[]{"Keyword", "Rule Title", "STIG ID", "Vulnerability ID", "Rule ID", "IA Control", "CAT I", "CAT II", "CAT III", "CCI"});
        filterTypeBox.getChildren().addAll((Object[])new Node[]{FilterKind});
        filterTypeBox.setAlignment(Pos.CENTER);
        FilterKind.setOnAction((EventHandler)new EventHandler<Event>(){

            public void handle(Event t) {
                String choice = (String)FilterKind.getSelectionModel().getSelectedItem();
                FilterPane.this.filterSelection = choice;
                if (FilterPane.this.filterSelection.contains("CAT")) {
                    FilterPane.this.FilterText = choice;
                    FilterPane.this.FilterInputField.setEditable(false);
                    FilterPane.this.FilterInputField.setStyle("-fx-background-color:TRANSPARENT;");
                    FilterPane.this.FilterInputField.setText(choice);
                } else {
                    FilterPane.this.FilterInputField.setEditable(true);
                    FilterPane.this.FilterInputField.setText("");
                    FilterPane.this.FilterText = "";
                    FilterPane.this.FilterInputField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
                }
                FilterPane.this.CurrentFilter = FilterPane.this.selectFilter(choice);
            }
        });
        FilterKind.getSelectionModel().select(0);
        FilterKind.fireEvent((Event)new ActionEvent());
        Button RemoveFilterButton = new Button("Remove Filter(s)");
        RemoveFilterButton.setMinWidth(97.0);
        RemoveFilterButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                FilterEvent tempCurr = FilterPane.this.CurrentFilter;
                ObservableList selected = FilterPane.this.CurrentListOfFilters.getSelectionModel().getSelectedItems();
                ArrayList<FilterTableRecord> forRemoval = new ArrayList<FilterTableRecord>();
                if (!selected.isEmpty()) {
                    for (FilterTableRecord recs : selected) {
                        FilterPane.this.CurrentFilter = FilterPane.this.selectFilter(recs.getFilterType());
                        Boolean InEx = false;
                        if (recs.getInExclusive().equals("+")) {
                            InEx = true;
                        }
                        Logger.getLogger(FilterPane.class.getName()).log(Level.INFO, "INFO: Filter: Filter Removed With Parameters: " + recs.getInExclusive() + " :: " + recs.getFilterType() + " :: " + recs.getFilterName());
                        FilterPane.this.CurrentFilter.removeFilter(recs.getFilterName(), InEx);
                        forRemoval.add(recs);
                    }
                    for (FilterTableRecord r : forRemoval) {
                        FilterPane.this.CurrentListOfFilters.getItems().remove((Object)r);
                    }
                    FilterPane.this.myDriver.filterRun();
                    FilterPane.this.myParent.changeVulnList(FilterPane.this.myDriver.getVisibleVulnList());
                }
                FilterPane.this.CurrentListOfFilters.getSelectionModel().clearSelection();
                FilterPane.this.CurrentFilter = tempCurr;
            }
        });
        Button RemoveAllFiltersButton = new Button("Remove All Filters");
        RemoveAllFiltersButton.setMinWidth(97.0);
        RemoveAllFiltersButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FilterEvent tempCurr = FilterPane.this.CurrentFilter;
                for (FilterTableRecord recs : FilterPane.this.CurrentListOfFilters.getItems()) {
                    FilterPane.this.CurrentFilter = FilterPane.this.selectFilter(recs.getFilterType());
                    Boolean InEx = false;
                    if (recs.getInExclusive().equals("+")) {
                        InEx = true;
                    }
                    Logger.getLogger(FilterPane.class.getName()).log(Level.INFO, "INFO: Filter: Filter Removed With Parameters: " + recs.getInExclusive() + " :: " + recs.getFilterType() + " :: " + recs.getFilterName());
                    FilterPane.this.CurrentFilter.removeFilter(recs.getFilterName(), InEx);
                }
                FilterPane.this.CurrentListOfFilters.getItems().removeAll((Collection)FilterPane.this.CurrentListOfFilters.getItems());
                FilterPane.this.myDriver.filterRun();
                FilterPane.this.myParent.changeVulnList(FilterPane.this.myDriver.getVisibleVulnList());
                FilterPane.this.CurrentFilter = tempCurr;
            }
        });
        HBox filterAllAnyContainer = new HBox(3.0);
        filterAllAnyContainer.setAlignment(Pos.CENTER);
        filterAllAnyContainer.getChildren().addAll((Object[])new Node[]{allAnyLabel, filterAllButton, filterAnyButton});
        AddFilterButtonsContainer.getChildren().addAll((Object[])new Node[]{AddInclusiveFilterButton, AddExclusiveFilterButton});
        AddFilterButtonsContainer.setAlignment(Pos.CENTER);
        RemoveFilterButtonsContainer.getChildren().addAll((Object[])new Node[]{RemoveFilterButton, RemoveAllFiltersButton});
        RemoveFilterButtonsContainer.setAlignment(Pos.CENTER);
        HBox FilterEntry = new HBox(2.0);
        FilterEntry.getChildren().addAll((Object[])new Node[]{filterTypeBox, this.FilterInputField, AddFilter});
        FilterEntry.setAlignment(Pos.CENTER);
        Separator blank = new Separator();
        blank.setVisible(false);
        Content.getChildren().add((Object)filterAllAnyContainer);
        Content.getChildren().add((Object)FilterEntry);
        Content.getChildren().add((Object)AddFilterButtonsContainer);
        Content.getChildren().add(this.CurrentListOfFilters);
        Content.getChildren().add((Object)RemoveFilterButtonsContainer);
        Content.getChildren().add((Object)blank);
        FilterTP.setContent((Node)Content);
        return FilterTP;
    }

    public FilterEvent selectFilter(String choice) {
        int filIndex = 0;
        switch (choice) {
            case "Keyword": {
                filIndex = 0;
                break;
            }
            case "Rule Title": {
                filIndex = 1;
                break;
            }
            case "STIG ID": {
                filIndex = 2;
                break;
            }
            case "Vulnerability ID": {
                filIndex = 3;
                break;
            }
            case "Rule ID": {
                filIndex = 4;
                break;
            }
            case "IA Control": {
                filIndex = 5;
                break;
            }
            case "CAT I": {
                filIndex = 6;
                break;
            }
            case "CAT II": {
                filIndex = 7;
                break;
            }
            case "CAT III": {
                filIndex = 8;
                break;
            }
            case "CCI": {
                filIndex = 9;
                break;
            }
            default: {
                filIndex = 0;
            }
        }
        return this.Filters.get(filIndex);
    }

    public List<String> getFilterText(String field) {
        this.computeFilterTextMap();
        return this.FilterTextMap.get(field);
    }

    private void computeFilterTextMap() {
        this.initFilterTextMap();
        for (FilterTableRecord ftr : this.CurrentListOfFilters.getItems()) {
            if (!ftr.getInExclusive().equals("+")) continue;
            switch (ftr.getFilterType()) {
                case "Keyword": {
                    this.FilterTextMap.get("RuleTitle").add(ftr.getFilterName());
                    this.FilterTextMap.get("STIGID").add(ftr.getFilterName());
                    this.FilterTextMap.get("VulnID").add(ftr.getFilterName());
                    this.FilterTextMap.get("RuleID").add(ftr.getFilterName());
                    this.FilterTextMap.get("General").add(ftr.getFilterName());
                    this.FilterTextMap.get("Severity").add(ftr.getFilterName());
                    this.FilterTextMap.get("Discussion").add(ftr.getFilterName());
                    this.FilterTextMap.get("CheckContent").add(ftr.getFilterName());
                    this.FilterTextMap.get("FixText").add(ftr.getFilterName());
                    this.FilterTextMap.get("MiscText").add(ftr.getFilterName());
                    this.FilterTextMap.get("CCIText").add(ftr.getFilterName());
                    this.FilterTextMap.get("General").add(ftr.getFilterName());
                    break;
                }
                case "Rule Title": {
                    this.FilterTextMap.get("RuleTitle").add(ftr.getFilterName());
                    break;
                }
                case "STIG ID": {
                    this.FilterTextMap.get("STIGID").add(ftr.getFilterName());
                    break;
                }
                case "Vulnerability ID": {
                    this.FilterTextMap.get("VulnID").add(ftr.getFilterName());
                    break;
                }
                case "Rule ID": {
                    this.FilterTextMap.get("RuleID").add(ftr.getFilterName());
                    break;
                }
                case "IA Control": {
                    this.FilterTextMap.get("MiscText").add(ftr.getFilterName());
                    break;
                }
                case "CAT I": {
                    this.FilterTextMap.get("Severity").add("CAT I");
                    break;
                }
                case "CAT II": {
                    this.FilterTextMap.get("Severity").add("CAT II");
                    break;
                }
                case "CAT III": {
                    this.FilterTextMap.get("Severity").add("CAT III");
                    break;
                }
                case "CCI": {
                    this.FilterTextMap.get("CCIText").add(ftr.getFilterName());
                    break;
                }
            }
        }
    }

    private void initFilterTextMap() {
        this.FilterTextMap = new HashMap();
        ArrayList dis = new ArrayList();
        ArrayList ck = new ArrayList();
        ArrayList fix = new ArrayList();
        ArrayList misc = new ArrayList();
        ArrayList cci = new ArrayList();
        this.FilterTextMap.put("Discussion", dis);
        this.FilterTextMap.put("CheckContent", ck);
        this.FilterTextMap.put("FixText", fix);
        this.FilterTextMap.put("MiscText", misc);
        this.FilterTextMap.put("CCIText", cci);
        ArrayList stigid = new ArrayList();
        ArrayList ruletitle = new ArrayList();
        ArrayList ruleid = new ArrayList();
        ArrayList vulnid = new ArrayList();
        ArrayList severity = new ArrayList();
        ArrayList general = new ArrayList();
        this.FilterTextMap.put("STIGID", stigid);
        this.FilterTextMap.put("RuleTitle", ruletitle);
        this.FilterTextMap.put("RuleID", ruleid);
        this.FilterTextMap.put("VulnID", vulnid);
        this.FilterTextMap.put("Severity", severity);
        this.FilterTextMap.put("General", general);
    }

    private String inputTranslate(String text) {
        text = text.replaceAll(">", "&gt");
        text = text.replaceAll("<", "&lt");
        return text;
    }

    private void setFilterTableGraphics() {
        this.CurrentListOfFilters.setStyle(PrefSet.getPS().getJfxTableDefault());
        this.CurrentListOfFilters.setRowFactory(this.getFPRowFactory());
        for (TableColumn tc : this.CurrentListOfFilters.getColumns()) {
            tc.setCellFactory(this.getFPCellFactory());
        }
    }

    private Callback getFPCellFactory() {
        return new Callback<TableColumn<FilterTableRecord, ?>, TableCell<FilterTableRecord, ?>>(){

            public TableCell<FilterTableRecord, ?> call(TableColumn p) {
                TableCell<FilterTableRecord, String> tc = new TableCell<FilterTableRecord, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(item == null || empty ? null : item.toString());
                        this.setGraphic(null);
                    }
                };
                tc.setTextFill((Paint)PrefSet.getPS().getSV_FONT_DEFAULT_COLOR());
                tc.setStyle(PrefSet.getPS().getJfxFontSpec());
                return tc;
            }
        };
    }

    private Callback<TableView<FilterTableRecord>, TableRow<FilterTableRecord>> getFPRowFactory() {
        return new Callback<TableView<FilterTableRecord>, TableRow<FilterTableRecord>>(){

            public TableRow call(TableView p) {
                final TableRow row = new TableRow();
                row.setStyle(PrefSet.getPS().getJfxTableDefault());
                row.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean old, Boolean rec) {
                        if (rec.booleanValue()) {
                            row.setStyle(PrefSet.getPS().getJfxTableHighlight());
                        } else {
                            row.setStyle(PrefSet.getPS().getJfxTableDefault());
                        }
                    }
                });
                return row;
            }
        };
    }

    @Override
    public List<DisplayObject> getChildDisplayObjects() {
        ArrayList<DisplayObject> dispOs = new ArrayList<DisplayObject>();
        return dispOs;
    }

    @Override
    public void graphicsUpdate() {
        this.FilterInputField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.setFilterTableGraphics();
    }
}

