/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_STIG;

import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import Program_Tabs.Tab_STIG.ProfileSelect.ProfileList;
import Program_Tabs.Tab_STIG.STIGDriver;
import Program_Tabs.interfaces.DisplayTab;
import Program_Tabs.interfaces.STIGDisplayTab;
import Shared_Constructs.Filter.GUI.FilterPane;
import Shared_Constructs.Legacy.STIGDataView.STIGs_SDV_Setup;
import Shared_Constructs.Rule_Display.STIGs_Rule_Display;
import Shared_Constructs.STIGList.StigList_Abstract;
import Shared_Constructs.STIGList.StigList_Explorer;
import Shared_Constructs.VulnTable;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import stigviewer.STIGViewer;

public class STIGViewTab
extends DisplayObject
implements DisplayTab,
STIGDisplayTab {
    private static Tab STIGTab;
    private static STIGViewer stigviewer;
    private static STIGDriver STIGDriverParent;
    private final VBox LeftPane;
    private final SplitPane RootPane;
    private final ScrollPane MiddlePane;
    private static StigList_Abstract STIGView;
    private final ProfileList ProfList;
    private final FilterPane FilPane;
    private final VulnTable VDisplay;
    private ScrollPane RightColumnScrollPane;
    private VBox RightPane;
    private STIGs_SDV_Setup SDV_Set;
    private STIGs_Rule_Display RDisplay;

    public STIGViewTab(STIGViewer sv, STIGDriver p) {
        this.ProfList = new ProfileList(p, this);
        STIGDriverParent = p;
        stigviewer = sv;
        this.LeftPane = new VBox(5.0);
        this.LeftPane.setPrefWidth(400.0);
        STIGDriverParent.setMainPane((Pane)this.LeftPane);
        this.MiddlePane = new ScrollPane();
        this.MiddlePane.setPrefWidth(150.0);
        this.RightColumnScrollPane = new ScrollPane();
        this.RightColumnScrollPane.setPrefWidth(1000.0);
        this.RightColumnScrollPane.setFitToWidth(true);
        this.RightColumnScrollPane.setFitToHeight(true);
        this.RightColumnScrollPane.setStyle(PrefSet.getPS().getJfxTableDefault());
        this.RootPane = new SplitPane();
        this.RootPane.getItems().addAll((Object[])new Node[]{this.LeftPane, this.MiddlePane, this.RightColumnScrollPane});
        this.RootPane.setDividerPositions(new double[]{0.3f, 0.5, 0.9f});
        this.RootPane.setStyle(PrefSet.getPS().getJfxTableDefault());
        TitledPane mySTIGList = new TitledPane();
        VBox TopLeft = new VBox(5.0);
        ArrayList<StigList_Abstract.STIGDispColumn> myColumns = new ArrayList<StigList_Abstract.STIGDispColumn>();
        myColumns.add(StigList_Abstract.STIGDispColumn.Check);
        myColumns.add(StigList_Abstract.STIGDispColumn.STIGName);
        myColumns.add(StigList_Abstract.STIGDispColumn.STIGVersion);
        myColumns.add(StigList_Abstract.STIGDispColumn.STIGFileName);
        myColumns.add(StigList_Abstract.STIGDispColumn.ReleaseID);
        STIGView = new StigList_Explorer(this, myColumns);
        TopLeft.getChildren().add((Object)STIGView.createTable());
        TopLeft.getChildren().add((Object)this.ProfList.createProfileDropdown());
        mySTIGList.setText("STIGs");
        mySTIGList.setContent((Node)TopLeft);
        this.LeftPane.getChildren().add((Object)mySTIGList);
        this.FilPane = new FilterPane(this, STIGDriverParent);
        this.LeftPane.getChildren().add((Object)this.FilPane.createFilterPane());
        this.LeftPane.setMinWidth(5.0);
        this.LeftPane.setPrefWidth(375.0);
        ArrayList<VulnTable.DispColumn> TableColumns = new ArrayList<VulnTable.DispColumn>();
        TableColumns.add(VulnTable.DispColumn.VulID);
        TableColumns.add(VulnTable.DispColumn.STIGID);
        TableColumns.add(VulnTable.DispColumn.RuleID);
        TableColumns.add(VulnTable.DispColumn.CCI);
        TableColumns.add(VulnTable.DispColumn.STIGName);
        this.VDisplay = new VulnTable(this, TableColumns);
        TableView MidPaneTable = this.VDisplay.createTable();
        MidPaneTable.setPrefHeight(3000.0);
        HBox StatusBar = this.VDisplay.createTableStatusBar();
        VBox MiddleBox = new VBox();
        MiddleBox.getChildren().addAll((Object[])new Node[]{MidPaneTable, StatusBar});
        this.MiddlePane.setContent((Node)MiddleBox);
        this.MiddlePane.setPrefWidth(400.0);
        this.MiddlePane.setFitToWidth(true);
        this.MiddlePane.setFitToHeight(true);
        this.MiddlePane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.SDV_Set = new STIGs_SDV_Setup(this, false);
        this.RDisplay = new STIGs_Rule_Display();
        this.swapRDisplay();
        Separator RightColumnSeparator = new Separator();
        RightColumnSeparator.setMinHeight(20.0);
        this.RightColumnScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.RightColumnScrollPane.setContent((Node)this.RightPane);
        STIGTab = new Tab();
        STIGTab.setClosable(false);
        STIGTab.setText("STIG Explorer");
        STIGTab.setContent((Node)this.RootPane);
        Logger.getLogger(STIGViewTab.class.getName()).log(Level.INFO, "INFO: ST: STIG Explorer tab graphics Setup");
        STIGTab.setOnSelectionChanged(new EventHandler(){

            public void handle(Event e) {
                STIGViewer.getSV().getMainPane().setTop((Node)STIGDriverParent.getMenuBar());
            }
        });
    }

    public DisplayObject getVulnTable() {
        return this.VDisplay;
    }

    @Override
    public FilterPane getFilterPane() {
        return this.FilPane;
    }

    public Tab getTab() {
        return STIGTab;
    }

    private void swapRDisplay() {
        this.RightPane = PrefSet.getPS().getStyle().contains("Classic") ? this.SDV_Set.getRCVbox() : this.RDisplay.getRuleDisplay();
        this.RightColumnScrollPane.setContent((Node)this.RightPane);
    }

    @Override
    public void updateSTIGTabGUI() {
        ArrayList<STIG> STIGs = STIGDriverParent.getSTIGs();
        STIGView.changeSTIGList(STIGs);
    }

    @Override
    public void changeCurrentSTIG(ArrayList<STIG> STIGList) {
        if (STIGList == null || STIGList.size() <= 0 || STIGList.isEmpty()) {
            this.ProfList.updateProfileList(STIGList);
            ArrayList<STIG> emptyList = new ArrayList<STIG>();
            STIGDriverParent.UpdateCurrentSTIGList(emptyList);
            this.changeVulnList(null);
        } else {
            this.ProfList.updateProfileList(STIGList);
            STIGDriverParent.UpdateCurrentSTIGList(STIGList);
            ArrayList<Vuln> VulnList = STIGDriverParent.getVisibleVulnList();
            this.changeVulnList(VulnList);
        }
    }

    @Override
    public void RemoveSTIGs(ArrayList<STIG> s) {
        STIGDriverParent.RemoveSTIGs(s);
    }

    @Override
    public void changeVulnList(ArrayList<Vuln> vList) {
        boolean retB = this.VDisplay.changeVulnList(vList);
        this.VDisplay.selectionMonitor(retB);
        STIGDriverParent.setVisibleVulnList(vList);
    }

    @Override
    public void changeCurrentRule(VulnTable.VulnTableItem selectedItem) {
        Vuln currVuln = new Vuln();
        if (selectedItem != null) {
            currVuln = STIGDriverParent.getVulnbyRuleID(selectedItem.getRule_ID(), selectedItem.getSTIG_Name());
        }
        if (currVuln != null) {
            STIGDriverParent.setCurrentSelectedVuln(currVuln);
            this.updateRuleDisplay(currVuln);
        } else {
            currVuln = new Vuln();
            STIGDriverParent.setCurrentSelectedVuln(currVuln);
            this.updateRuleDisplay(currVuln);
        }
    }

    @Override
    public void updateDisplay() {
        this.VDisplay.UpdateDisplay();
    }

    @Override
    public void updateRuleDisplay(Vuln currVuln) {
        if (PrefSet.getPS().getStyle().contains("Classic")) {
            HashMap<String, ArrayList<String>> ft = new HashMap<String, ArrayList<String>>();
            ft.put("General", (ArrayList<String>)this.FilPane.getFilterText("General"));
            ft.put("RuleTitle", (ArrayList<String>)this.FilPane.getFilterText("RuleTitle"));
            ft.put("STIGID", (ArrayList<String>)this.FilPane.getFilterText("STIGID"));
            ft.put("RuleID", (ArrayList<String>)this.FilPane.getFilterText("RuleID"));
            ft.put("VulnID", (ArrayList<String>)this.FilPane.getFilterText("VulnID"));
            ft.put("Severity", (ArrayList<String>)this.FilPane.getFilterText("Severity"));
            this.SDV_Set.clearVBox();
            if (this.SDV_Set.getSDV().updateSTIGInfoTextArea(currVuln, ft)) {
                this.SDV_Set.addPan(0);
            }
            if (this.SDV_Set.getSDV().updateDiscussionTextArea(currVuln, this.FilPane.getFilterText("Discussion"))) {
                this.SDV_Set.addPan(1);
            }
            if (this.SDV_Set.getSDV().updateCheckContentTextArea(currVuln, this.FilPane.getFilterText("CheckContent"))) {
                this.SDV_Set.addPan(2);
            }
            if (this.SDV_Set.getSDV().updateFixTextTextArea(currVuln, this.FilPane.getFilterText("FixText"))) {
                this.SDV_Set.addPan(3);
            }
            if (this.SDV_Set.getSDV().updateCCITextArea(currVuln, this.FilPane.getFilterText("CCIText"), STIG.STIGArrayHasCCI(STIGDriverParent.getCurrentSTIGs()))) {
                this.SDV_Set.addPan(4);
            }
            if (this.SDV_Set.getSDV().updateMiscTextArea(currVuln, this.FilPane.getFilterText("MiscText"))) {
                this.SDV_Set.addPan(5);
            }
        }
    }

    @Override
    public void updateCurrentSelectedVuls(ArrayList<Vuln> vuls, boolean bool) {
    }

    @Override
    public Vuln GetCurrentSelectedVul() {
        Vuln vRet = null;
        return vRet;
    }

    @Override
    public ArrayList<Vuln> GetCurrentSelectedVuls() {
        ArrayList<Vuln> v = new ArrayList<Vuln>();
        return v;
    }

    @Override
    public Stage getPrimaryStage() {
        return stigviewer.getPrimaryStage();
    }

    @Override
    public Iterable<STIG> getCurrentSTIGs() {
        return STIGDriverParent.getCurrentSTIGs();
    }

    @Override
    public List<DisplayObject> getChildDisplayObjects() {
        ArrayList<DisplayObject> dispOs = new ArrayList<DisplayObject>();
        dispOs.add(STIGView);
        dispOs.add(this.FilPane);
        dispOs.add(this.VDisplay);
        dispOs.add(this.RDisplay);
        return dispOs;
    }

    public STIGs_Rule_Display getRDisplay() {
        return this.RDisplay;
    }

    @Override
    public void graphicsUpdate() {
        this.swapRDisplay();
        this.RightColumnScrollPane.setStyle(PrefSet.getPS().getJfxTableDefault());
        this.RootPane.setStyle(PrefSet.getPS().getJfxTableDefault());
        this.RightPane.setStyle(PrefSet.getPS().getJfxTableDefault());
    }
}

