/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_STIG;

import File_Operations.File_Objects.STIG;
import File_Operations.File_Writers.PreferencesWriter;
import File_Operations.Legacy.Export_Functions.CSV_Writer;
import File_Operations.Legacy.Export_Functions.HTML_Exporter;
import File_Operations.Legacy.Export_Functions.RTF_Exporter;
import Program_Tabs.Tab_Checklist.ChecklistControllerSetup;
import Program_Tabs.Tab_STIG.STIGDriver;
import Program_Tabs.Tab_STIG.STIGViewerGUIAboutBox;
import Program_Tabs.Tab_STIG.STIGViewerGUIChangeLog;
import Program_Tabs.Tab_STIG.STIGViewerGUIReadMe;
import Shared_Constructs.ListSelectionDialog;
import Utility_Code.CustomExceptions.NoFileSelected;
import Utility_Code.CustomExceptions.NotSTIGException;
import Utility_Code.GlobalSettings.Preferences_Window.PreferencesWindow;
import Utility_Code.Static_Methods.ErrorHandlers;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import stigviewer.CommonMenuBar;
import stigviewer.STIGViewer;

public class STIGMenuBar
implements CommonMenuBar {
    private static MenuBar STIGBar;
    private static STIGViewer stigviewer;
    private static String currentFileDirectory;
    private static STIGDriver STIGDriverparent;
    private static MenuItem OptionsDeleteSavepoint;
    private MenuItem OptionsSettings;
    ArrayList<ChecklistControllerSetup> CentralChecklistControllers;

    public STIGMenuBar(STIGViewer sv, STIGDriver p) {
        STIGBar = this.createMenuBar();
        stigviewer = sv;
        STIGDriverparent = p;
        currentFileDirectory = "";
        this.CentralChecklistControllers = new ArrayList();
    }

    private MenuBar createMenuBar() {
        MenuItem FileImportSTIG = new MenuItem("Import STIG");
        FileImportSTIG.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer STIG Import option selected");
                try {
                    STIGMenuBar.SelectSTIGFilesToLoad();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
                catch (NotSTIGException ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.SEVERE, "SEVERE: SM: STIG importing threw a data processing exception");
                }
            }
        });
        MenuItem FileExit = new MenuItem("Exit");
        FileExit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer Exit option selected");
                stigviewer.close();
            }
        });
        Menu FileMenu = new Menu("File");
        FileMenu.getItems().addAll((Object[])new MenuItem[]{FileImportSTIG, FileExit});
        Menu ExportMenu = new Menu("Export");
        MenuItem ExportHTMLFormat = new MenuItem("Webpage(.html)");
        ExportHTMLFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer HTML Export option selected");
                try {
                    STIGMenuBar.exportToHTML();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
            }
        });
        MenuItem ExportRTFFormat = new MenuItem("Document(.rtf)");
        ExportRTFFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer .rtf Export option selected");
                try {
                    STIGMenuBar.exportToRTF();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
            }
        });
        MenuItem ExportCSVFormat = new MenuItem("Spreadsheet(.csv)");
        ExportCSVFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer .csv Export option selected");
                try {
                    STIGMenuBar.exportToCSV();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
            }
        });
        ExportMenu.getItems().addAll((Object[])new MenuItem[]{ExportHTMLFormat, ExportRTFFormat, ExportCSVFormat});
        MenuItem ChecklistOpenFromFile = new MenuItem("Open Checklist from File");
        ChecklistOpenFromFile.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer Open Checklist from File option selected");
                try {
                    STIGMenuBar.this.SelectChecklistFilesToLoad();
                }
                catch (NoFileSelected ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.CONFIG, "'Cancel' or 'X' Selected in FileChooser");
                }
            }
        });
        MenuItem ChecklistCreateFromSTIG = new MenuItem("Create Checklist - Check Marked STIG(s)");
        ChecklistCreateFromSTIG.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer Create Checklist from Checked List option selected");
                if (STIGDriverparent.getCurrentSTIGs() != null && STIGDriverparent.getCurrentSTIGs().size() > 0) {
                    try {
                        ArrayList<STIG> checklist = new ArrayList<STIG>();
                        for (STIG s : STIGDriverparent.getCurrentSTIGs()) {
                            checklist.add(s.DeepCopy());
                        }
                        ChecklistControllerSetup tmp = new ChecklistControllerSetup(checklist);
                        STIGMenuBar.this.CentralChecklistControllers.add(tmp);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(STIGMenuBar.class.getName()).log(Level.SEVERE, "SEVERE: SM: An exception occured while attempting to open a Checklist from checked STIGs");
                    }
                } else {
                    ErrorHandlers.noStigSelected();
                }
            }
        });
        MenuItem ChecklistCreateFromList = new MenuItem("Create Checklist - Current List");
        ChecklistCreateFromList.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (STIGDriverparent.getCurrentSTIGs() == null || STIGDriverparent.getCurrentSTIGs().size() <= 0) {
                    ErrorHandlers.noStigSelected();
                }
            }
        });
        Menu ChecklistMenu = new Menu("Checklist");
        ChecklistMenu.getItems().addAll((Object[])new MenuItem[]{ChecklistOpenFromFile, ChecklistCreateFromSTIG});
        OptionsDeleteSavepoint = new MenuItem("Delete Local Data Cache");
        OptionsDeleteSavepoint.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer Local Data Cache Deletion option selected");
                stigviewer.getSavePoint().DeleteSavePoint();
                stigviewer.getSavePoint().CreateSavePoint();
                PreferencesWriter.getPreferencesWriter();
            }
        });
        this.OptionsSettings = new MenuItem("Preferences");
        this.OptionsSettings.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                PreferencesWindow.getPreferencesWindow().Open();
            }
        });
        Menu OptionsMenu = new Menu("Options");
        OptionsMenu.getItems().add((Object)OptionsDeleteSavepoint);
        OptionsMenu.getItems().add((Object)this.OptionsSettings);
        MenuItem HelpAbout = new MenuItem("About...");
        HelpAbout.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                STIGViewerGUIAboutBox aboutBox = new STIGViewerGUIAboutBox();
            }
        });
        MenuItem HelpReadme = new MenuItem("View Readme");
        HelpReadme.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                try {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer open Readme option selected");
                    STIGViewerGUIReadMe sTIGViewerGUIReadMe = new STIGViewerGUIReadMe();
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.SEVERE, "SEVERE: SM: Opening the readme caused an exception");
                }
                catch (IOException ex) {
                    Logger.getLogger(STIGMenuBar.class.getName()).log(Level.SEVERE, "SEVERE: SM: Opening the readme caused an IO exception to occur");
                }
            }
        });
        MenuItem HelpChangeLog = new MenuItem("View Change Log");
        HelpChangeLog.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Logger.getLogger(STIGMenuBar.class.getName()).log(Level.INFO, "INFO: SM: STIG Explorer open Change Log option selected");
                STIGViewerGUIChangeLog changeLog = new STIGViewerGUIChangeLog();
            }
        });
        Menu HelpMenu = new Menu("Help");
        HelpMenu.getItems().add((Object)HelpAbout);
        HelpMenu.getItems().add((Object)HelpReadme);
        HelpMenu.getItems().add((Object)HelpChangeLog);
        MenuBar DefaultMenu = new MenuBar();
        DefaultMenu.getMenus().add((Object)FileMenu);
        DefaultMenu.getMenus().add((Object)ExportMenu);
        DefaultMenu.getMenus().add((Object)ChecklistMenu);
        DefaultMenu.getMenus().add((Object)OptionsMenu);
        DefaultMenu.getMenus().add((Object)HelpMenu);
        return DefaultMenu;
    }

    @Override
    public MenuBar getMenuBar() {
        return STIGBar;
    }

    private void SelectChecklistFilesToLoad() throws NoFileSelected {
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Checklist files(*.ckl)", new String[]{"*.ckl"}));
        List<File> FilesList = STIGMenuBar.loadDirectorySelector(fileSelector);
        for (File f : FilesList) {
            try {
                ChecklistControllerSetup tmp = new ChecklistControllerSetup(f);
                this.CentralChecklistControllers.add(tmp);
            }
            catch (Exception e) {
                ErrorHandlers.checklistImportError(e.getMessage());
            }
        }
    }

    private static void SelectSTIGFilesToLoad() throws NoFileSelected, NotSTIGException {
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("STIG XML or zip files (*.xml), (*.zip)", new String[]{"*.xml", "*.zip"}));
        List<File> FileList = STIGMenuBar.loadDirectorySelector(fileSelector);
        STIGDriverparent.LoadSTIGs(FileList);
    }

    private static void exportToHTML() throws NoFileSelected {
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("HTML files (*.html)", new String[]{"*.html"}));
        File FileToWrite = STIGMenuBar.exportFileSelector(fileSelector);
        HTML_Exporter.export(FileToWrite.getPath(), STIGDriverparent, 800);
    }

    private static void exportToRTF() throws NoFileSelected {
        FileChooser fileSelector = new FileChooser();
        fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("rtf files (*.rtf)", new String[]{"*.rtf"}));
        File FileToWrite = STIGMenuBar.exportFileSelector(fileSelector);
        RTF_Exporter.export(FileToWrite.getAbsolutePath(), STIGDriverparent);
    }

    private static void exportToCSV() throws NoFileSelected {
        if (STIGDriverparent.getCurrentSTIGs().isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Export Error");
            alert.setHeaderText("Export Error");
            alert.setContentText("You must select one or more STIGs for CSV export.");
            alert.showAndWait();
            return;
        }
        HashSet<String> selected = new HashSet<String>(CSV_Writer.stigFields);
        ListSelectionDialog lsd = new ListSelectionDialog(CSV_Writer.stigFields, selected);
        lsd.setTitle("Select fields to export");
        lsd.setMinimumSelectionCount(1);
        Optional fields = lsd.showAndWait();
        if (fields.isPresent()) {
            FileChooser fileSelector = new FileChooser();
            fileSelector.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV files(*.csv)", new String[]{"*.csv"}));
            File FileToWrite = STIGMenuBar.exportFileSelector(fileSelector);
            CSV_Writer.export(FileToWrite.getAbsolutePath(), STIGDriverparent, new HashSet<String>((Collection)fields.get()));
        }
    }

    private static List<File> loadDirectorySelector(FileChooser fChoose) throws NoFileSelected {
        List FileList;
        if (!currentFileDirectory.equals("")) {
            fChoose.setInitialDirectory(new File(currentFileDirectory));
        }
        if ((FileList = fChoose.showOpenMultipleDialog((Window)stigviewer.getPrimaryStage())) == null) {
            throw new NoFileSelected("No file selected in FileChooser before \"Cancel\" or \"X\" selected, file list set as null");
        }
        STIGMenuBar.setCurrentFileDirectory(((File)FileList.get(0)).getParent());
        return FileList;
    }

    private static File exportFileSelector(FileChooser fChoose) throws NoFileSelected {
        File FileToWrite;
        if (!currentFileDirectory.equals("")) {
            fChoose.setInitialDirectory(new File(currentFileDirectory));
        }
        if ((FileToWrite = fChoose.showSaveDialog((Window)stigviewer.getPrimaryStage())) == null) {
            throw new NoFileSelected("No file selected in FileChooser before \"Cancel\" or \"X\" selected, file list set as null");
        }
        STIGMenuBar.setCurrentFileDirectory(FileToWrite.getParent());
        return FileToWrite;
    }

    private static void setCurrentFileDirectory(String Path2) {
        currentFileDirectory = Path2;
    }
}

