/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_STIG.ProfileSelect;

import File_Operations.File_Objects.STIG;
import Program_Tabs.Tab_STIG.STIGDriver;
import Program_Tabs.Tab_STIG.STIGViewTab;
import Shared_Constructs.Filter.Parents.FilterEvent;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class ProfileList {
    private final ChoiceBox ProfileDropdown = new ChoiceBox();
    private FilterEvent ProfFilter;
    private STIGDriver Driver;
    private STIGViewTab VTab;

    public ProfileList(STIGDriver driver, STIGViewTab vtab) {
        this.ProfFilter = driver.getFilters().get(driver.getFilters().size() - 1);
        this.Driver = driver;
        this.VTab = vtab;
    }

    public HBox createProfileDropdown() {
        HBox HProfileBox = new HBox(5.0);
        HProfileBox.setAlignment(Pos.CENTER);
        HProfileBox.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.ProfileDropdown.getItems().setAll(new Object[]{"No Profile"});
        this.ProfileDropdown.setValue((Object)"No Profile");
        this.ProfileDropdown.setMinWidth(200.0);
        this.ProfileDropdown.setPrefWidth(this.ProfileDropdown.getMinWidth());
        this.setProfileBoxHandler();
        HProfileBox.getChildren().addAll((Object[])new Node[]{new Label("Profile: "), this.ProfileDropdown});
        return HProfileBox;
    }

    public void updateProfileList(List<STIG> stigs) {
        String selected = (String)this.ProfileDropdown.getSelectionModel().getSelectedItem();
        this.ProfileDropdown.getItems().removeAll((Collection)this.ProfileDropdown.getItems());
        this.ProfileDropdown.getItems().add((Object)"No Profile");
        if (stigs != null) {
            for (STIG s : stigs) {
                for (Object pl : s.getSTIG_ProfileMap().keySet()) {
                    String os = (String)pl;
                    boolean pExists = false;
                    for (String prEx : this.ProfileDropdown.getItems()) {
                        if (!prEx.equals(os)) continue;
                        pExists = true;
                        break;
                    }
                    if (pExists) continue;
                    this.ProfileDropdown.getItems().add((Object)os);
                }
            }
        }
        this.ProfileDropdown.getSelectionModel().select((Object)selected);
        if (this.ProfileDropdown.getSelectionModel().getSelectedIndex() < 0) {
            this.ProfileDropdown.getSelectionModel().select((Object)"No Profile");
        }
    }

    private void setProfileBoxHandler() {
        this.ProfileDropdown.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (t1 != null && !t1.equals("No Profile")) {
                    ProfileList.this.ProfFilter.addFilter(t1, true);
                    Logger.getLogger(ProfileList.class.getName()).log(Level.INFO, "INFO: PL: New profile selected: " + t1);
                } else {
                    ProfileList.this.ProfFilter.removeFilter(t1, false);
                }
                ProfileList.this.Driver.filterRun();
                ProfileList.this.VTab.changeVulnList(ProfileList.this.Driver.getVisibleVulnList());
            }
        });
    }
}

