/*
 * Decompiled with CFR 0.152.
 */
package Program_Tabs.Tab_Checklist;

import Program_Tabs.Tab_Checklist.ChecklistDriver;
import Utility_Code.GlobalSettings.DisplayObject;
import Utility_Code.GlobalSettings.Preferences_Window.PrefSet;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class TargetPane
extends DisplayObject {
    private ChecklistDriver myParent;
    private ComboBox isComputing;
    private TextField HostNameTextField;
    private TextField IPAddressTextField;
    private TextField MACAddressTextField;
    private TextField GUIDTextField;
    private TextField FQDNTextField;
    private RadioButton NoRole;
    private RadioButton WorkstationRole;
    private RadioButton MemberServerRole;
    private RadioButton DomainControllerRole;
    private ToggleGroup RoleSelectionToggleGroup;
    private CheckBox isWebDB;
    private TextField TD_Site;
    private TextField TD_Instance;

    public TargetPane(ChecklistDriver parent) {
        this.myParent = parent;
    }

    public void setAssetType(String s) {
        if (s.equalsIgnoreCase("Computing")) {
            this.isComputing.getSelectionModel().select((Object)"Computing");
        } else if (s.equalsIgnoreCase("Non-computing")) {
            this.isComputing.getSelectionModel().select((Object)"Non-Computing");
        }
    }

    public String getAssetType() {
        return this.isComputing.getValue().toString();
    }

    public String getHostName() {
        return this.HostNameTextField.getText();
    }

    public void setHostName(String s) {
        this.HostNameTextField.setText(s);
    }

    public String getIPAddress() {
        return this.IPAddressTextField.getText();
    }

    public void setIPAddress(String s) {
        this.IPAddressTextField.setText(s);
    }

    public String getMAC() {
        return this.MACAddressTextField.getText();
    }

    public void setMAC(String s) {
        this.MACAddressTextField.setText(s);
    }

    public String getFQDN() {
        return this.FQDNTextField.getText();
    }

    public void setFQDN(String fqdn) {
        this.FQDNTextField.setText(fqdn);
    }

    public String getGUID() {
        return this.GUIDTextField.getText();
    }

    public void setGUID(String s) {
        this.GUIDTextField.setText(s);
    }

    public String getRole() {
        return (String)this.RoleSelectionToggleGroup.getSelectedToggle().getUserData();
    }

    public boolean isWebOrDB() {
        return this.isWebDB.isSelected();
    }

    public String GetSite() {
        return this.TD_Site.getText();
    }

    public String GetInstance() {
        return this.TD_Instance.getText();
    }

    public TitledPane createTargetPane() {
        TitledPane Target = new TitledPane();
        Target.setText("Target Data");
        this.isComputing = new ComboBox();
        ObservableList ComputingOptions = FXCollections.observableArrayList((Object[])new String[]{"Computing", "Non-Computing"});
        this.isComputing.setItems(ComputingOptions);
        VBox TargetDataVBox = new VBox(5.0);
        TargetDataVBox.getChildren().addAll((Object[])new Node[]{this.isComputing});
        this.HostNameTextField = new TextField("");
        this.HostNameTextField.setPromptText("Host Name");
        this.HostNameTextField.setMinHeight(20.0);
        this.HostNameTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TargetPane.this.myParent.getChecklist().setHostName(TargetPane.this.HostNameTextField.getText());
            }
        });
        this.IPAddressTextField = new TextField("");
        this.IPAddressTextField.setPromptText("IP Address");
        this.IPAddressTextField.setMinHeight(20.0);
        this.IPAddressTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TargetPane.this.myParent.getChecklist().setIPAddress(TargetPane.this.IPAddressTextField.getText());
            }
        });
        this.MACAddressTextField = new TextField("");
        this.MACAddressTextField.setPromptText("MAC Address");
        this.MACAddressTextField.setMinHeight(20.0);
        this.MACAddressTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TargetPane.this.myParent.getChecklist().setMACAddress(TargetPane.this.MACAddressTextField.getText());
            }
        });
        this.FQDNTextField = new TextField("");
        this.FQDNTextField.setPromptText("Fully Qualified Domain Name");
        this.FQDNTextField.setMinHeight(20.0);
        this.FQDNTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TargetPane.this.myParent.getChecklist().setFullyQualifiedDN(TargetPane.this.FQDNTextField.getText());
            }
        });
        this.GUIDTextField = new TextField("");
        this.GUIDTextField.setPromptText("GUID Value");
        this.GUIDTextField.setMinHeight(20.0);
        this.GUIDTextField.setOnKeyReleased((EventHandler)new EventHandler<Event>(){

            public void handle(Event t) {
                TargetPane.this.myParent.getChecklist().setGUID(TargetPane.this.GUIDTextField.getText());
            }
        });
        TargetDataVBox.getChildren().add((Object)this.HostNameTextField);
        TargetDataVBox.getChildren().add((Object)this.IPAddressTextField);
        TargetDataVBox.getChildren().add((Object)this.MACAddressTextField);
        TargetDataVBox.getChildren().add((Object)this.FQDNTextField);
        final HBox ScanButtonsHBox = new HBox(5.0);
        ScanButtonsHBox.setAlignment(Pos.CENTER_RIGHT);
        ScanButtonsHBox.setPadding(new Insets(5.0, 10.0, 0.0, 0.0));
        final Label RoleLabel = new Label("Role");
        RoleLabel.setFont(Font.font((String)"Segoe UI", (FontWeight)FontWeight.BOLD, (double)13.0));
        this.NoRole = new RadioButton("None");
        this.NoRole.setUserData((Object)"None");
        this.NoRole.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                TargetPane.this.myParent.getChecklist().setRole("None");
                Logger.getLogger(TargetPane.class.getName()).log(Level.INFO, "INFO: CT: Checklist Role changed to None");
            }
        });
        this.WorkstationRole = new RadioButton("Workstation");
        this.WorkstationRole.setUserData((Object)"Workstation");
        this.WorkstationRole.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                TargetPane.this.myParent.getChecklist().setRole("Workstation");
                Logger.getLogger(TargetPane.class.getName()).log(Level.INFO, "INFO: CT: Checklist Role changed to Workstation");
            }
        });
        this.MemberServerRole = new RadioButton("Member Server");
        this.MemberServerRole.setUserData((Object)"Member Server");
        this.MemberServerRole.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                TargetPane.this.myParent.getChecklist().setRole("Member Server");
                Logger.getLogger(TargetPane.class.getName()).log(Level.INFO, "INFO: CT: Checklist Role changed to Member Server");
            }
        });
        this.DomainControllerRole = new RadioButton("Domain Controller");
        this.DomainControllerRole.setUserData((Object)"Domain Controller");
        this.DomainControllerRole.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                TargetPane.this.myParent.getChecklist().setRole("Domain Controller");
                Logger.getLogger(TargetPane.class.getName()).log(Level.INFO, "INFO: CT: Checklist Role changed to Domain Controller");
            }
        });
        this.RoleSelectionToggleGroup = new ToggleGroup();
        this.NoRole.setToggleGroup(this.RoleSelectionToggleGroup);
        this.WorkstationRole.setToggleGroup(this.RoleSelectionToggleGroup);
        this.MemberServerRole.setToggleGroup(this.RoleSelectionToggleGroup);
        this.DomainControllerRole.setToggleGroup(this.RoleSelectionToggleGroup);
        if (this.myParent.getChecklist().getRole().equals("")) {
            this.RoleSelectionToggleGroup.selectToggle((Toggle)this.NoRole);
            this.myParent.getChecklist().setRole("None");
        } else {
            if (this.myParent.getChecklist().getRole().equals("None")) {
                this.RoleSelectionToggleGroup.selectToggle((Toggle)this.NoRole);
                this.myParent.getChecklist().setRole("None");
            }
            if (this.myParent.getChecklist().getRole().equals("Workstation")) {
                this.RoleSelectionToggleGroup.selectToggle((Toggle)this.WorkstationRole);
                this.myParent.getChecklist().setRole("Workstation");
            }
            if (this.myParent.getChecklist().getRole().equals("Member Server")) {
                this.RoleSelectionToggleGroup.selectToggle((Toggle)this.MemberServerRole);
                this.myParent.getChecklist().setRole("Member Server");
            }
            if (this.myParent.getChecklist().getRole().equals("Domain Controller")) {
                this.RoleSelectionToggleGroup.selectToggle((Toggle)this.DomainControllerRole);
                this.myParent.getChecklist().setRole("Domain Controller");
            }
        }
        final HBox RoleSelectionHBox = new HBox(5.0);
        RoleSelectionHBox.getChildren().addAll((Object[])new Node[]{this.NoRole, this.WorkstationRole, this.MemberServerRole, this.DomainControllerRole});
        Button GetHostDataBtn = new Button("Get Host Data");
        ScanButtonsHBox.getChildren().addAll((Object[])new Node[]{GetHostDataBtn});
        GetHostDataBtn.setOnAction(e -> {
            try {
                InetAddress ip = InetAddress.getLocalHost();
                this.FQDNTextField.setText(ip.getCanonicalHostName());
                this.IPAddressTextField.setText(ip.getHostAddress());
                this.HostNameTextField.setText(ip.getHostName());
                this.myParent.getChecklist().setFullyQualifiedDN(this.FQDNTextField.getText());
                this.myParent.getChecklist().setHostName(this.HostNameTextField.getText());
                this.myParent.getChecklist().setIPAddress(this.IPAddressTextField.getText());
                NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                byte[] mac = network.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                this.MACAddressTextField.setText(sb.toString());
                this.myParent.getChecklist().setMACAddress(this.MACAddressTextField.getText());
                Logger.getLogger(TargetPane.class.getName()).log(Level.INFO, "INFO: CT: Checklist Get Host Data button selected");
            }
            catch (UnknownHostException event) {
                Logger.getLogger(TargetPane.class.getName()).log(Level.WARNING, "WARNING: CT: Checklist Get Host Data button encountered an error when obtaining the hostname");
            }
            catch (SocketException ex) {
                Logger.getLogger(TargetPane.class.getName()).log(Level.WARNING, "WARNING: CT: Checklist Get Host Data button encountered an error while obtaining addresses");
            }
        });
        TargetDataVBox.getChildren().add((Object)ScanButtonsHBox);
        TargetDataVBox.getChildren().addAll((Object[])new Node[]{RoleLabel, this.NoRole, this.WorkstationRole, this.MemberServerRole, this.DomainControllerRole});
        final Separator sep = new Separator();
        this.isWebDB = new CheckBox();
        this.isWebDB.setText("Web or Database STIG");
        this.TD_Site = new TextField("");
        this.TD_Site.setPromptText("Site");
        this.TD_Site.setVisible(false);
        this.TD_Site.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TargetPane.this.myParent.getChecklist().setSite(TargetPane.this.TD_Site.getText());
            }
        });
        this.TD_Instance = new TextField("");
        this.TD_Instance.setPromptText("Instance");
        this.TD_Instance.setVisible(false);
        this.TD_Instance.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TargetPane.this.myParent.getChecklist().setInstance(TargetPane.this.TD_Instance.getText());
            }
        });
        if (this.myParent.getChecklist().getBIsWebDB()) {
            this.isWebDB.fire();
            this.TD_Instance.setText(this.myParent.getChecklist().getInstance());
            this.TD_Site.setText(this.myParent.getChecklist().getSite());
            this.TD_Site.setVisible(true);
            this.TD_Instance.setVisible(true);
        }
        this.isWebDB.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.TD_Site.setVisible(true);
                this.TD_Instance.setVisible(true);
                this.TD_Instance.setText(this.myParent.getChecklist().getInstance());
                this.TD_Site.setText(this.myParent.getChecklist().getSite());
                this.myParent.getChecklist().setBIsWebDB(true);
            } else {
                this.TD_Site.setVisible(false);
                this.TD_Instance.setVisible(false);
                this.myParent.getChecklist().setBIsWebDB(false);
            }
            Logger.getLogger(TargetPane.class.getName()).log(Level.INFO, "INFO: CT: Checklist Web/DB checkbox selected");
        });
        this.isComputing.setValue(ComputingOptions.get(0));
        this.isComputing.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (TargetPane.this.isComputing.getValue().toString().equals("Computing")) {
                    TargetPane.this.HostNameTextField.setPromptText("Host Name");
                    TargetPane.this.IPAddressTextField.setVisible(true);
                    TargetPane.this.MACAddressTextField.setVisible(true);
                    TargetPane.this.GUIDTextField.setVisible(true);
                    TargetPane.this.WorkstationRole.setVisible(true);
                    TargetPane.this.MemberServerRole.setVisible(true);
                    TargetPane.this.DomainControllerRole.setVisible(true);
                    TargetPane.this.FQDNTextField.setVisible(true);
                    ScanButtonsHBox.setVisible(true);
                    RoleLabel.setVisible(true);
                    RoleSelectionHBox.setVisible(true);
                    sep.setVisible(true);
                    TargetPane.this.isWebDB.setVisible(true);
                    if (TargetPane.this.isWebDB.isSelected()) {
                        TargetPane.this.TD_Site.setVisible(true);
                        TargetPane.this.TD_Instance.setVisible(true);
                    }
                } else {
                    TargetPane.this.HostNameTextField.setPromptText("Display Name");
                    TargetPane.this.IPAddressTextField.setVisible(false);
                    TargetPane.this.MACAddressTextField.setVisible(false);
                    TargetPane.this.GUIDTextField.setVisible(false);
                    TargetPane.this.FQDNTextField.setVisible(false);
                    TargetPane.this.WorkstationRole.setVisible(false);
                    TargetPane.this.MemberServerRole.setVisible(false);
                    TargetPane.this.DomainControllerRole.setVisible(false);
                    ScanButtonsHBox.setVisible(false);
                    RoleLabel.setVisible(false);
                    RoleSelectionHBox.setVisible(false);
                    sep.setVisible(false);
                    TargetPane.this.isWebDB.setVisible(false);
                    TargetPane.this.TD_Site.setVisible(false);
                    TargetPane.this.TD_Instance.setVisible(false);
                }
                TargetPane.this.myParent.getChecklist().setIsComputing(TargetPane.this.isComputing.getValue().toString());
                Logger.getLogger(TargetPane.class.getName()).log(Level.INFO, "INFO: CT: Checklist Computing checkbox selected");
            }
        });
        TargetDataVBox.getChildren().addAll((Object[])new Node[]{sep, this.isWebDB, this.TD_Site, this.TD_Instance});
        TargetDataVBox.setPadding(new Insets(10.0, 5.0, 10.0, 5.0));
        this.FQDNTextField.setText(this.myParent.getChecklist().getFullyQualifiedDN());
        Target.setContent((Node)TargetDataVBox);
        this.graphicsUpdate();
        return Target;
    }

    public void updateValues() {
        this.HostNameTextField.setText(this.myParent.getChecklist().getHostName());
        this.IPAddressTextField.setText(this.myParent.getChecklist().getIPAddress());
        this.MACAddressTextField.setText(this.myParent.getChecklist().getMACAddress());
        this.GUIDTextField.setText(this.myParent.getChecklist().getGUID());
        this.FQDNTextField.setText(this.myParent.getChecklist().getFullyQualifiedDN());
        this.TD_Site.setText(this.myParent.getChecklist().getSite());
        this.TD_Instance.setText(this.myParent.getChecklist().getInstance());
        this.setAssetType(this.myParent.getChecklist().getIsComputing());
        String role = this.myParent.getChecklist().getRole();
        if (role.equalsIgnoreCase("none")) {
            this.RoleSelectionToggleGroup.selectToggle((Toggle)this.NoRole);
        } else if (role.equalsIgnoreCase("workstation")) {
            this.RoleSelectionToggleGroup.selectToggle((Toggle)this.WorkstationRole);
        } else if (role.equalsIgnoreCase("member server")) {
            this.RoleSelectionToggleGroup.selectToggle((Toggle)this.MemberServerRole);
        } else if (role.equalsIgnoreCase("domain controller")) {
            this.RoleSelectionToggleGroup.selectToggle((Toggle)this.DomainControllerRole);
        }
        if (this.myParent.getChecklist().getBIsWebDB()) {
            this.isWebDB.setSelected(true);
        }
    }

    @Override
    public List<DisplayObject> getChildDisplayObjects() {
        ArrayList<DisplayObject> dispOs = new ArrayList<DisplayObject>();
        return dispOs;
    }

    @Override
    public void graphicsUpdate() {
        this.HostNameTextField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.IPAddressTextField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.MACAddressTextField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.GUIDTextField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.FQDNTextField.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.TD_Site.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
        this.TD_Instance.setStyle(PrefSet.getPS().getJfxTextBoxStyle());
    }
}

