/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.Legacy.Export_Functions;

import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import Program_Tabs.Tab_STIG.STIGDriver;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTML_Exporter {
    private static String GetHTMLHeader(int iTableWidth, STIGDriver PrimarySTIGDriver) {
        return "";
    }

    public static String GetHTMLBody(int iTableWidth, STIGDriver PrimarySTIGDriver) {
        String asRet = "";
        ArrayList<Vuln> vOut = PrimarySTIGDriver.getMasterVulnList();
        for (int i = 0; i < vOut.size(); ++i) {
            ArrayList<CCIReader.CCI_Store> CCIs;
            String sTemp = "";
            sTemp = sTemp + "<table align = \"center\" width = \"" + iTableWidth + "\" border = \"1\">";
            sTemp = sTemp + " <tr><td>";
            sTemp = sTemp + HTML_Exporter.sHeadHTML("STIG", vOut.get(i).getAttr(Vuln.VulnAttr.STIGRef), true) + " <br>";
            sTemp = sTemp + HTML_Exporter.sHeadHTML("Group Title", vOut.get(i).getAttr(Vuln.VulnAttr.Group_Title), true) + " <br>";
            switch (vOut.get(i).getAttr(Vuln.VulnAttr.Severity)) {
                case "high": {
                    sTemp = sTemp + HTML_Exporter.sHeadHTML("Severity", "CAT I", true) + " <br>";
                    break;
                }
                case "medium": {
                    sTemp = sTemp + HTML_Exporter.sHeadHTML("Severity", "CAT II", true) + " <br>";
                    break;
                }
                case "low": {
                    sTemp = sTemp + HTML_Exporter.sHeadHTML("Severity", "CAT III", true) + " <br>";
                }
            }
            sTemp = sTemp + HTML_Exporter.sHeadHTML("Group ID (Vulid)", vOut.get(i).getAttr(Vuln.VulnAttr.Vuln_Num), true) + HTML_Exporter.sHeadHTML(" Rule ID", vOut.get(i).getAttr(Vuln.VulnAttr.Rule_ID), true) + HTML_Exporter.sHeadHTML(" Rule Version (STIG-ID)", vOut.get(i).getAttr(Vuln.VulnAttr.Rule_Ver), true) + " <br>";
            sTemp = sTemp + HTML_Exporter.sHeadHTML("Rule Title", vOut.get(i).getAttr(Vuln.VulnAttr.Rule_Title), true);
            if (vOut.get(i).getAttr(Vuln.VulnAttr.Check_Content_Ref) != null && vOut.get(i).getAttr(Vuln.VulnAttr.Check_Content_Ref).length() > 0 && !vOut.get(i).getAttr(Vuln.VulnAttr.Check_Content_Ref).equals("M")) {
                sTemp = sTemp + HTML_Exporter.sHeadHTML(" SCAP", vOut.get(i).getAttr(Vuln.VulnAttr.Check_Content_Ref), true);
            }
            sTemp = sTemp + " </td></tr>";
            sTemp = sTemp + " <tr><td>";
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Vuln_Discuss))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Vulnerability Discussion", vOut.get(i).getAttr(Vuln.VulnAttr.Vuln_Discuss), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.False_Positives))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("False Positives", vOut.get(i).getAttr(Vuln.VulnAttr.False_Positives), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.False_Negatives))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("False Negatives", vOut.get(i).getAttr(Vuln.VulnAttr.False_Negatives), true);
            }
            sTemp = vOut.get(i).getAttr(Vuln.VulnAttr.Documentable).equals("true") ? sTemp + HTML_Exporter.sBodyHTML("Documentable", "Yes", true) : sTemp + HTML_Exporter.sBodyHTML("Documentable", "No", true);
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Responsibility))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Responsibility", vOut.get(i).getAttr(Vuln.VulnAttr.Responsibility), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.IA_Controls))) {
                sTemp = sTemp + "<b>IA Controls: </b>";
                sTemp = sTemp + vOut.get(i).getAttr(Vuln.VulnAttr.IA_Controls);
                sTemp = sTemp + " <br><br>";
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Check_Content))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Check Content", vOut.get(i).getAttr(Vuln.VulnAttr.Check_Content), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Fix_Text))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Fix Text", vOut.get(i).getAttr(Vuln.VulnAttr.Fix_Text), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Mitigation_Control))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Mitigation Control", vOut.get(i).getAttr(Vuln.VulnAttr.Mitigation_Control), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Mitigations))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Mitigations", vOut.get(i).getAttr(Vuln.VulnAttr.Mitigations), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Potential_Impact))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Potential Impacts", vOut.get(i).getAttr(Vuln.VulnAttr.Potential_Impact), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Security_Override_Guidance))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Severity Override Guidance", vOut.get(i).getAttr(Vuln.VulnAttr.Security_Override_Guidance), true);
            }
            if (HTML_Exporter.bHasAlphNum(vOut.get(i).getAttr(Vuln.VulnAttr.Third_Party_Tools))) {
                sTemp = sTemp + HTML_Exporter.sBodyHTML("Third Party Tools", vOut.get(i).getAttr(Vuln.VulnAttr.Third_Party_Tools), true);
            }
            if (vOut.get(i).getmyCCI() != null && (CCIs = vOut.get(i).GetCCIs()).size() == vOut.get(i).GetCCIVals().size() && vOut.get(i).GetCCIVals().size() > 0) {
                for (String sCCI : vOut.get(i).GetCCIVals()) {
                    sTemp = sTemp + "<b> CCI: </b>";
                    sTemp = sTemp + sCCI + "<br>";
                    CCIReader.CCI_Store cci = vOut.get(i).GetCCIbyName(sCCI);
                    if (cci != null) {
                        sTemp = sTemp + cci.sDefinition + "<br>";
                        for (int k = 0; k < cci.sRefs.size(); ++k) {
                            sTemp = sTemp + cci.sRefs.get(k).getFirst() + " :: " + cci.sRefs.get(k).getSecond() + "<br>";
                        }
                    }
                    sTemp = sTemp + "<br>";
                }
            }
            sTemp = sTemp + "</td></tr><br>";
            sTemp = sTemp + "</table><br>";
            asRet = asRet + sTemp;
        }
        return asRet;
    }

    private static String sBRInsert(String s) {
        String sRet = "";
        int iLast = 0;
        if (s.length() > 1) {
            for (int i = 1; i < s.length(); ++i) {
                if (s.charAt(i) == '\n' && iLast <= i) {
                    sRet = sRet + s.substring(iLast, i) + " <br>";
                    iLast = i;
                }
                if (s.charAt(i) <= '\u2000' || iLast > i) continue;
                sRet = sRet + s.substring(iLast, i) + "&#x" + Integer.toHexString(s.charAt(i)) + ";";
                iLast = i + 1;
            }
            if (iLast <= s.length()) {
                sRet = sRet + s.substring(iLast, s.length());
            }
        }
        sRet = sRet + " <br><br>";
        return sRet;
    }

    private static String sHeadHTML(String sCaption, String sIn, boolean bHasCaption) {
        String sTemp = "";
        if (bHasCaption) {
            sTemp = sTemp + "<b>" + sCaption + ": </b>";
        }
        sTemp = sTemp + sIn;
        return sTemp;
    }

    private static String sBodyHTML(String sCaption, String sIn, boolean bHasCaption) {
        sIn = sIn.replace("<", "&lt;");
        sIn = sIn.replace(">", "&gt;");
        String sTemp = "";
        if (bHasCaption) {
            sTemp = sTemp + "<b>" + sCaption + ": </b><br>";
        }
        sTemp = sTemp + HTML_Exporter.sBRInsert(sIn);
        return sTemp;
    }

    public static boolean bHasAlphNum(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isLetterOrDigit(s.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void export(String FileToWrite, STIGDriver PrimarySTIGDriver, int TableWidth) {
        String sOut = "";
        String sHeader = "";
        String sVulns = "";
        String fileLoc = FileToWrite;
        if (!fileLoc.endsWith(".html")) {
            fileLoc = fileLoc + ".html";
        }
        sHeader = HTML_Exporter.GetHTMLHeader(TableWidth, PrimarySTIGDriver);
        sVulns = HTML_Exporter.GetHTMLBody(TableWidth, PrimarySTIGDriver);
        sOut = sOut + "<head>";
        sOut = sOut + "<h1 style=\"text-align:center\">" + PrimarySTIGDriver.getMasterClassification() + "</h1><br>";
        sOut = sOut + sHeader;
        sOut = sOut + "</head>";
        sOut = sOut + "<body>";
        sOut = sOut + sVulns;
        sOut = sOut + "<h1 style=\"text-align:center\">" + PrimarySTIGDriver.getMasterClassification() + "</h1><br>";
        sOut = sOut + "</body>";
        try {
            FileOutputStream FileWriter = new FileOutputStream(fileLoc);
            BufferedOutputStream bos = new BufferedOutputStream(FileWriter);
            bos.write(sOut.getBytes("US-ASCII"));
            bos.close();
        }
        catch (Exception e) {
            Logger.getLogger(HTML_Exporter.class.getName()).log(Level.SEVERE, "INFO: HTML: An exception occured while ");
        }
    }
}

