/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.Legacy.Export_Functions;

import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import Program_Tabs.Tab_Checklist.ChecklistDriver;
import Program_Tabs.Tab_STIG.STIGDriver;
import Utility_Code.Static_Methods.ErrorHandlers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSV_Writer {
    public static final List<String> stigFields = Arrays.asList("Vuln ID", "Severity", "Group Title", "Rule ID", "STIG ID", "Rule Title", "Discussion", "IA Controls", "Check Content", "Fix Text", "False Positives", "False Negatives", "Documentable", "Mitigations", "Potential Impact", "Third Party Tools", "Mitigation Control", "Responsibility", "Severity Override Guidance", "Check Content Reference", "Classification", "STIG", "VMS Asset Posture", "CCI");
    public static final List<String> checklistFields = Arrays.asList("TechnologyArea", "HostName", "IPAddress", "MACAddress", "Vuln ID", "Severity", "Group Title", "Rule ID", "STIG ID", "Rule Title", "Discussion", "IA Controls", "Check Content", "Fix Text", "False Positives", "False Negatives", "Documentable", "Mitigations", "Potential Impact", "Third Party Tools", "Mitigation Control", "Responsibility", "Severity Override Guidance", "Check Content Reference", "Classification", "STIG", "Status", "Comments", "Finding Details", "Severity Override", "Severity Override Justification", "CCI");

    public static void export(String fileAbsPath, STIGDriver PrimarySTIGDriver, Set<String> fields) {
        if (!fileAbsPath.endsWith(".csv")) {
            fileAbsPath = fileAbsPath + ".csv";
        }
        File FileToWrite = new File(fileAbsPath);
        String newLine = "\n";
        FileOutputStream csvOut = null;
        try {
            csvOut = new FileOutputStream(FileToWrite);
        }
        catch (FileNotFoundException ex) {
            ErrorHandlers.ioExportError(".csv export file");
            Logger.getLogger(CSV_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CSVW: 1: Exception occured while creating a csv export");
        }
        ArrayList<Vuln> vulns = PrimarySTIGDriver.getMasterVulnList();
        if (csvOut != null) {
            try {
                String header = "\"~~~~~" + PrimarySTIGDriver.getCurrentSTIGs().get(0).getSTIG_Classification() + "~~~~~\"\n";
                CSV_Writer.outputTextFilter(header);
                csvOut.write(header.getBytes("UTF8"));
                for (String field : stigFields) {
                    if (!fields.contains(field)) continue;
                    csvOut.write(CSV_Writer.outputTextFilter(field).getBytes("UTF8"));
                }
                csvOut.write("\n".getBytes("UTF8"));
                for (int i = 0; i < vulns.size(); ++i) {
                    ArrayList<String> element = vulns.get(i).getAttrs();
                    for (int j = 0; j < element.size(); ++j) {
                        if (j == 20 || !fields.contains(Vuln.VulnAttr.values()[j].toString())) continue;
                        String s = element.get(j);
                        csvOut.write(CSV_Writer.outputTextFilter(s).getBytes("UTF8"));
                    }
                    if (fields.contains("CCI")) {
                        csvOut.write(CSV_Writer.outputTextFilter(vulns.get(i).getAllCCIText()).getBytes("UTF8"));
                    }
                    csvOut.write(newLine.getBytes("UTF8"));
                }
                header = "\"~~~~~" + PrimarySTIGDriver.getCurrentSTIGs().get(0).getSTIG_Classification() + "~~~~~\"";
                CSV_Writer.outputTextFilter(header);
                csvOut.write(header.getBytes("UTF8"));
            }
            catch (IOException ex) {
                ErrorHandlers.ioExportError(".csv export file");
                Logger.getLogger(CSV_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CSVW: 2: Exception occured while creating a csv export");
            }
            try {
                csvOut.close();
            }
            catch (IOException ex) {
                ErrorHandlers.ioExportError(".csv export file");
                Logger.getLogger(CSV_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CSVW: 3: Exception occured while creating a csv export");
            }
        }
    }

    public static void exportCheckList(ArrayList<STIG> stig, ChecklistDriver VList, String FileToWrite, Set<String> fields) {
        String newLine = "\r\n";
        String comma = " ,";
        if (!FileToWrite.endsWith(".csv")) {
            FileToWrite = FileToWrite + ".csv";
        }
        FileOutputStream csvOut = null;
        try {
            csvOut = new FileOutputStream(FileToWrite);
        }
        catch (FileNotFoundException ex) {
            ErrorHandlers.ioExportError(".csv export file");
            Logger.getLogger(CSV_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CSVW: 4: Exception occured while creating a csv export");
        }
        if (csvOut != null) {
            try {
                for (String field : checklistFields) {
                    if (!fields.contains(field)) continue;
                    csvOut.write(CSV_Writer.outputTextFilter(field).getBytes("UTF8"));
                }
                csvOut.write("\n".getBytes("UTF8"));
                for (STIG one : stig) {
                    for (Vuln v : one.getVulnList()) {
                        if (fields.contains("TechnologyArea")) {
                            if (VList.getChecklist().getTechnologyArea() != "-- Please Select --") {
                                csvOut.write(CSV_Writer.outputTextFilter(VList.getChecklist().getTechnologyArea()).getBytes("UTF8"));
                            } else {
                                csvOut.write(comma.getBytes("UTF8"));
                            }
                        }
                        if (fields.contains("HostName")) {
                            csvOut.write(CSV_Writer.outputTextFilter(VList.getChecklist().getHostName()).getBytes("UTF8"));
                        }
                        if (fields.contains("IPAddress")) {
                            csvOut.write(CSV_Writer.outputTextFilter(VList.getChecklist().getIPAddress()).getBytes("UTF8"));
                        }
                        if (fields.contains("MACAddress")) {
                            csvOut.write(CSV_Writer.outputTextFilter(VList.getChecklist().getMACAddress()).getBytes("UTF8"));
                        }
                        for (int index = 0; index < 23; ++index) {
                            if (index == 20 || !fields.contains(Vuln.VulnAttr.values()[index].toString())) continue;
                            csvOut.write(CSV_Writer.outputTextFilter(v.getAttrs().get(index)).getBytes("UTF8"));
                        }
                        if (fields.contains("Status")) {
                            csvOut.write(CSV_Writer.outputTextFilter(CSV_Writer.returnStatus(v.getCheckState().toString())).getBytes("UTF8"));
                        }
                        if (fields.contains("Comments")) {
                            csvOut.write(CSV_Writer.outputTextFilter(v.getCheckComment()).getBytes("UTF8"));
                        }
                        if (fields.contains("Finding Details")) {
                            csvOut.write(CSV_Writer.outputTextFilter(v.getCHK_Notes()).getBytes("UTF8"));
                        }
                        if (fields.contains("Severity Override")) {
                            csvOut.write(CSV_Writer.outputTextFilter(v.getCheckSevOverride()).getBytes("UTF8"));
                        }
                        if (fields.contains("Severity Override Justification")) {
                            csvOut.write(CSV_Writer.outputTextFilter(v.getCheckSevJust()).getBytes("UTF8"));
                        }
                        if (fields.contains("CCI")) {
                            csvOut.write(CSV_Writer.outputTextFilter(v.getAllCCIText()).getBytes("UTF8"));
                        }
                        csvOut.write(newLine.getBytes("UTF8"));
                    }
                }
            }
            catch (IOException ex) {
                ErrorHandlers.ioExportError(".csv export file");
                Logger.getLogger(CSV_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CSVW: 5: Exception occured while creating a csv export");
            }
            try {
                csvOut.close();
            }
            catch (IOException ex) {
                ErrorHandlers.ioExportError(".csv export file");
                Logger.getLogger(CSV_Writer.class.getName()).log(Level.SEVERE, "SEVERE: CSVW: 6: Exception occured while creating a csv export");
            }
        }
    }

    private static String outputTextFilter(String text) {
        if (!text.isEmpty()) {
            text = text.replaceAll("&gt", ">");
            text = text.replaceAll("&lt", "<");
            if ((text = text.replaceAll("\"", "\"\"")).charAt(0) == '-') {
                text = text.substring(1);
            }
            if (text.length() > 32700) {
                text = text.substring(0, 32700);
            }
        }
        text = "\"" + text + "\",";
        return text;
    }

    private static String returnStatus(String code) {
        switch (code) {
            case "NF": {
                return "Not A Finding";
            }
            case "NR": {
                return "Not Reviewed";
            }
            case "O": {
                return "Open";
            }
            case "NA": {
                return "Not Applicable";
            }
        }
        return "Not Identified";
    }
}

