/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Writers;

import Utility_Code.GlobalSettings.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import stigviewer.STIGViewer;

public class PreferencesWriter {
    private static PreferencesWriter PrefWrite;
    private final File PreferencesFile;
    private FileOutputStream bWrite;

    private PreferencesWriter(File f) {
        this.PreferencesFile = f;
        if (!this.PreferencesFile.exists()) {
            try {
                Files.write(this.PreferencesFile.toPath(), new byte[0], StandardOpenOption.CREATE);
            }
            catch (IOException ex) {
                Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Preferences file unable to be created");
            }
        }
    }

    public void Write(String output) {
        String[] outSp = output.split("=");
        ArrayList oldFile = new ArrayList();
        try {
            oldFile = (ArrayList)Files.readAllLines(this.PreferencesFile.toPath(), Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Failed to read Preferences file");
        }
        try {
            this.PreferencesFile.delete();
            this.PreferencesFile.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Failed to clear Preferences file");
        }
        this.bWrite = null;
        try {
            this.bWrite = new FileOutputStream(this.PreferencesFile);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Failed to initialize write stream");
        }
        boolean notWrote = true;
        for (String s : oldFile) {
            if (!s.contains(outSp[0])) {
                try {
                    this.bWrite.write(s.getBytes("UTF8"));
                    this.bWrite.write("\r\n".getBytes("UTF8"));
                }
                catch (IOException ex) {
                    Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Failed to write to Preferences file");
                }
                continue;
            }
            try {
                this.bWrite.write(output.getBytes("UTF8"));
                this.bWrite.write("\r\n".getBytes("UTF8"));
            }
            catch (IOException ex) {
                Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Failed to write to Preferences file");
            }
            notWrote = false;
        }
        if (notWrote) {
            try {
                this.bWrite.write(output.getBytes("UTF8"));
                this.bWrite.write("\r\n".getBytes("UTF8"));
            }
            catch (IOException ex) {
                Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Failed to write to PReferences file");
            }
        }
        this.Close();
    }

    public void Close() {
        try {
            this.bWrite.close();
        }
        catch (IOException ex) {
            Logger.getLogger(PreferencesWriter.class.getName()).log(Level.SEVERE, "SEVERE: PW: Exception occured when attempting to close file stream writer");
        }
    }

    public static PreferencesWriter getPreferencesWriter() {
        if (PrefWrite == null) {
            PrefWrite = new PreferencesWriter(new File(STIGViewer.getSV().getSavePoint().GetSavePointLocation() + Util.GetSlash() + "Preferences.cnf"));
        }
        return PrefWrite;
    }
}

