/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Writers;

import File_Operations.File_Objects.Checklist;
import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Checklist_Writer_2x {
    private static Checklist_Writer_2x Writer;
    private Checklist CKL;
    private XMLStreamWriter XMLW = null;
    private int Depth = 0;

    private Checklist_Writer_2x() {
    }

    public void writeChecklist(File f, Checklist ckl) {
        this.Depth = 0;
        this.CKL = ckl;
        FileOutputStream fst = null;
        try {
            fst = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CW: 1: Exception occured while saving a Checklist");
        }
        XMLOutputFactory xmlFact = XMLOutputFactory.newInstance();
        try {
            this.XMLW = xmlFact.createXMLStreamWriter(new BufferedOutputStream(fst), "UTF-8");
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CW: 1.2: Exception occured while saving a Checklist");
        }
        try {
            this.XMLW.writeStartDocument("UTF-8", "1.0");
            this.XMLW.writeCharacters("\n");
            this.XMLW.writeComment("DISA STIG Viewer :: 2.8");
            this.nest();
            this.XMLW.writeStartElement("CHECKLIST");
            this.writeAsset();
            this.writeSTIGs();
            this.subD();
            this.nest();
            this.XMLW.writeEndElement();
            this.XMLW.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.XMLW.close();
            ((OutputStream)fst).close();
        }
        catch (IOException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CW: 1.3: Exception occured while saving a Checklist");
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CW: 1.45: Exception occured while saving a Checklist");
        }
    }

    private void writeAsset() {
        try {
            this.addD();
            this.nest();
            this.XMLW.writeStartElement("ASSET");
            if (!this.CKL.getRole().isEmpty()) {
                this.writeElementWithData("ROLE", this.CKL.getRole());
            } else {
                this.writeElementWithData("ROLE", "");
            }
            if (!this.CKL.getIsComputing().isEmpty()) {
                this.writeElementWithData("ASSET_TYPE", this.CKL.getIsComputing());
            } else {
                this.writeElementWithData("ASSET_TYPE", "");
            }
            if (!this.CKL.getHostName().isEmpty()) {
                this.writeElementWithData("HOST_NAME", this.CKL.getHostName());
            } else {
                this.writeElementWithData("HOST_NAME", "");
            }
            if (!this.CKL.getIPAddress().isEmpty()) {
                this.writeElementWithData("HOST_IP", this.CKL.getIPAddress());
            } else {
                this.writeElementWithData("HOST_IP", "");
            }
            if (!this.CKL.getMACAddress().isEmpty()) {
                this.writeElementWithData("HOST_MAC", this.CKL.getMACAddress());
            } else {
                this.writeElementWithData("HOST_MAC", "");
            }
            if (!this.CKL.getFullyQualifiedDN().isEmpty()) {
                this.writeElementWithData("HOST_FQDN", this.CKL.getFullyQualifiedDN());
            } else {
                this.writeElementWithData("HOST_FQDN", "");
            }
            if (!this.CKL.getTechnologyArea().isEmpty()) {
                this.writeElementWithData("TECH_AREA", this.CKL.getTechnologyArea());
            } else {
                this.writeElementWithData("TECH_AREA", "");
            }
            if (!this.CKL.getTargetKey().isEmpty()) {
                this.writeElementWithData("TARGET_KEY", this.CKL.getTargetKey());
            } else {
                this.writeElementWithData("TARGET_KEY", "");
            }
            if (this.CKL.getBIsWebDB()) {
                this.writeElementWithData("WEB_OR_DATABASE", "true");
            } else {
                this.writeElementWithData("WEB_OR_DATABASE", "false");
            }
            if (!this.CKL.getSite().isEmpty()) {
                this.writeElementWithData("WEB_DB_SITE", this.CKL.getSite());
            } else {
                this.writeElementWithData("WEB_DB_SITE", "");
            }
            if (!this.CKL.getInstance().isEmpty()) {
                this.writeElementWithData("WEB_DB_INSTANCE", this.CKL.getInstance());
            } else {
                this.writeElementWithData("WEB_DB_INSTANCE", "");
            }
            this.nest();
            this.XMLW.writeEndElement();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CW: 1.4: Exception occured while saving a Checklist");
        }
    }

    private void writeSTIGs() {
        try {
            this.nest();
            this.XMLW.writeStartElement("STIGS");
            for (STIG s : this.CKL.getChecklistSTIGList()) {
                this.addD();
                this.nest();
                this.XMLW.writeStartElement("iSTIG");
                this.addD();
                this.nest();
                this.XMLW.writeStartElement("STIG_INFO");
                if (!s.getSTIG_Version().isEmpty()) {
                    this.writeSTIGInfoGroupND("version", s.getSTIG_Version());
                } else {
                    this.writeSTIGInfoGroupN("version");
                }
                if (!s.getSTIG_Classification().isEmpty()) {
                    this.writeSTIGInfoGroupND("classification", s.getSTIG_Classification());
                } else {
                    this.writeSTIGInfoGroupN("classification");
                }
                if (!s.getSTIG_CustomName().isEmpty()) {
                    this.writeSTIGInfoGroupND("customname", s.getSTIG_CustomName());
                } else {
                    this.writeSTIGInfoGroupN("customname");
                }
                if (!s.getSTIG_BID().isEmpty()) {
                    this.writeSTIGInfoGroupND("stigid", s.getSTIG_BID());
                } else {
                    this.writeSTIGInfoGroupN("stigid");
                }
                if (!s.getSTIG_Description().isEmpty()) {
                    this.writeSTIGInfoGroupND("description", s.getSTIG_Description());
                } else {
                    this.writeSTIGInfoGroupN("description");
                }
                if (!s.getSTIG_FileName().isEmpty()) {
                    this.writeSTIGInfoGroupND("filename", s.getSTIG_FileName());
                } else {
                    this.writeSTIGInfoGroupN("filename");
                }
                if (!s.getSTIG_Release_Info().isEmpty()) {
                    this.writeSTIGInfoGroupND("releaseinfo", s.getSTIG_Release_Info());
                } else {
                    this.writeSTIGInfoGroupN("releaseinfo");
                }
                if (!s.getSTIG_Title().isEmpty()) {
                    this.writeSTIGInfoGroupND("title", s.getSTIG_Title());
                } else {
                    this.writeSTIGInfoGroupN("title");
                }
                if (s.getSTIG_UUID() != null) {
                    this.writeSTIGInfoGroupND("uuid", s.getSTIG_UUID().toString());
                } else {
                    this.writeSTIGInfoGroupN("uuid");
                }
                if (!s.getSTIG_notice().isEmpty()) {
                    this.writeSTIGInfoGroupND("notice", s.getSTIG_notice());
                } else {
                    this.writeSTIGInfoGroupN("notice");
                }
                if (!s.getSTIG_source().isEmpty()) {
                    this.writeSTIGInfoGroupND("source", s.getSTIG_source());
                } else {
                    this.writeSTIGInfoGroupN("source");
                }
                this.nest();
                this.XMLW.writeEndElement();
                for (Vuln v : s.getVulnList()) {
                    this.nest();
                    this.writeVuln(v);
                }
                this.subD();
                this.nest();
                this.XMLW.writeEndElement();
                this.subD();
            }
            this.nest();
            this.XMLW.writeEndElement();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CW: 1.5: Exception occured while saving a Checklist");
        }
    }

    private void writeVuln(Vuln v) {
        try {
            this.XMLW.writeStartElement("VULN");
            Vuln.VulnAttr[] vattribs = Vuln.VulnAttr.values();
            for (Vuln.VulnAttr va : vattribs) {
                if (va.equals((Object)Vuln.VulnAttr.NULL)) continue;
                this.writeVulnInfoGroupND(va.name(), v.getAttr(va));
            }
            if (!v.GetCCIs().isEmpty()) {
                for (CCIReader.CCI_Store c : v.GetCCIs()) {
                    this.writeVulnInfoGroupND("CCI_REF", c.sID);
                }
            } else {
                this.writeVulnInfoGroupN("CCI_REF");
            }
            if (!v.getCheckState().toString().isEmpty()) {
                this.writeElementWithData("STATUS", v.getCheckState().name());
            } else {
                this.writeElementWithData("STATUS", "Not_Reviewed");
            }
            if (!v.getCHK_Notes().isEmpty()) {
                this.writeElementWithData("FINDING_DETAILS", v.getCHK_Notes());
            } else {
                this.writeElementWithData("FINDING_DETAILS", "");
            }
            if (!v.getCheckComment().isEmpty()) {
                this.writeElementWithData("COMMENTS", v.getCheckComment());
            } else {
                this.writeElementWithData("COMMENTS", "");
            }
            if (!v.getCheckSevOverride().isEmpty()) {
                this.writeElementWithData("SEVERITY_OVERRIDE", v.getCheckSevOverride());
            } else {
                this.writeElementWithData("SEVERITY_OVERRIDE", "");
            }
            if (!v.getCheckSevJust().isEmpty()) {
                this.writeElementWithData("SEVERITY_JUSTIFICATION", v.getCheckSevJust());
            } else {
                this.writeElementWithData("SEVERITY_JUSTIFICATION", "");
            }
            this.nest();
            this.XMLW.writeEndElement();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Checklist_Writer_2x.class.getName()).log(Level.SEVERE, "SEVERE: CW: 1.6: Exception occured while saving a Checklist");
        }
    }

    private void writeSTIGInfoGroupND(String name, String data) throws XMLStreamException {
        this.addD();
        this.nest();
        this.XMLW.writeStartElement("SI_DATA");
        this.writeElementWithData("SID_NAME", name);
        this.writeElementWithData("SID_DATA", data);
        this.nest();
        this.XMLW.writeEndElement();
        this.subD();
    }

    private void writeSTIGInfoGroupN(String name) throws XMLStreamException {
        this.addD();
        this.nest();
        this.XMLW.writeStartElement("SI_DATA");
        this.writeElementWithData("SID_NAME", name);
        this.nest();
        this.XMLW.writeEndElement();
        this.subD();
    }

    private void writeElementWithData(String ename, String econtent) throws XMLStreamException {
        this.addD();
        this.nest();
        this.XMLW.writeStartElement(ename);
        this.XMLW.writeCharacters(econtent);
        this.XMLW.writeEndElement();
        this.subD();
    }

    private void writeVulnInfoGroupND(String name, String data) throws XMLStreamException {
        this.addD();
        this.nest();
        this.XMLW.writeStartElement("STIG_DATA");
        this.writeElementWithData("VULN_ATTRIBUTE", name);
        this.writeElementWithData("ATTRIBUTE_DATA", data);
        this.nest();
        this.XMLW.writeEndElement();
        this.subD();
    }

    private void writeVulnInfoGroupN(String name) throws XMLStreamException {
        this.addD();
        this.nest();
        this.XMLW.writeStartElement("STIG_DATA");
        this.writeElementWithData("VULN_ATTRIBUTE", name);
        this.XMLW.writeEmptyElement("ATTRIBUTE_DATA");
        this.nest();
        this.XMLW.writeEndElement();
        this.subD();
    }

    private void nest() throws XMLStreamException {
        this.XMLW.writeCharacters("\n");
        for (int i = 0; i < this.Depth; ++i) {
            this.XMLW.writeCharacters("\t");
        }
    }

    private void addD() {
        ++this.Depth;
    }

    private void subD() {
        --this.Depth;
    }

    public static Checklist_Writer_2x getChecklist_Writer_2x() {
        if (Writer == null) {
            Writer = new Checklist_Writer_2x();
        }
        return Writer;
    }
}

