/*
 * Decompiled with CFR 0.152.
 */
package File_Operations.File_Readers;

import File_Operations.File_Objects.STIG;
import File_Operations.File_Objects.Vuln;
import File_Operations.Legacy.File_Interfaces.CCIReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XCCDF_Read {
    private static XCCDF_Read Reader;
    private STIG ImportSTIG = new STIG();
    private File Fin = new File("");
    private XMLStreamReader XMLR;

    private XCCDF_Read() {
    }

    public void openBenchmarkFile(File f) {
        this.ImportSTIG = new STIG();
        if (f != null) {
            this.setFile(f);
            this.readFile();
        }
    }

    private void readFile() {
        FileInputStream inXml = null;
        try {
            inXml = new FileInputStream(this.Fin);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "SEVERE: XR: 1: Exception occured while reading XCCDF file");
        }
        XMLInputFactory xmlFact = XMLInputFactory.newInstance();
        this.XMLR = null;
        try {
            this.XMLR = xmlFact.createXMLStreamReader(inXml);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "SEVERE: XR: 2: Exception occured while reading XCCDF file");
        }
        this.parseStig();
        try {
            ((InputStream)inXml).close();
            this.XMLR.close();
        }
        catch (IOException | XMLStreamException ex) {
            Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "SEVERE: XR: 2.5: Exception occured while reading XCCDF file");
        }
    }

    private void parseStig() {
        this.ImportSTIG.setSTIG_FileName(this.Fin.getName());
        boolean metadataRead = false;
        boolean benchmarkRead = false;
        try {
            while (this.XMLR.hasNext()) {
                this.XMLR.next();
                if (!this.XMLR.isStartElement()) continue;
                if (!metadataRead) {
                    if (!benchmarkRead) {
                        if (!this.XMLR.getName().getLocalPart().equals("Benchmark")) continue;
                        this.ImportSTIG.setSTIG_BID(this.parseXMLAttr("id"));
                        benchmarkRead = true;
                        continue;
                    }
                    switch (this.XMLR.getName().getLocalPart()) {
                        case "notice": {
                            this.ImportSTIG.setSTIG_notice(this.parseXMLAttr("id"));
                            break;
                        }
                        case "title": {
                            if (!this.ImportSTIG.getSTIG_Title().isEmpty()) break;
                            this.cycleToText();
                            this.ImportSTIG.setSTIG_Title(this.XMLR.getText());
                            break;
                        }
                        case "description": {
                            this.cycleToText();
                            this.ImportSTIG.setSTIG_Description(this.XMLR.getText());
                            break;
                        }
                        case "front-matter": {
                            this.cycleToText();
                            this.ImportSTIG.setSTIG_OverviewDoc(this.XMLR.getText());
                            break;
                        }
                        case "plain-text": {
                            this.parsePlainTextRelease();
                            break;
                        }
                        case "version": {
                            this.cycleToText();
                            this.ImportSTIG.setSTIG_Version(this.XMLR.getText());
                            metadataRead = true;
                            break;
                        }
                        case "Profile": {
                            this.parseSTIGProfile();
                            metadataRead = true;
                            break;
                        }
                    }
                    continue;
                }
                switch (this.XMLR.getName().getLocalPart()) {
                    case "Profile": {
                        this.parseSTIGProfile();
                        break;
                    }
                    case "Group": {
                        this.parseSTIGGroups();
                        break;
                    }
                }
            }
            this.addVulnProfiles();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "SEVERE: XR: 3: Exception occured while reading XCCDF file");
        }
    }

    private void addVulnProfiles() {
        Map p = this.ImportSTIG.getSTIG_ProfileMap();
        for (Object s : p.keySet()) {
            String os = (String)s;
            ArrayList tepid = (ArrayList)p.get(s);
            for (String pSt : tepid) {
                for (Vuln v : this.ImportSTIG.getVulnList()) {
                    if (v.getAttr(Vuln.VulnAttr.Vuln_Num).equals(pSt)) {
                        v.addSTIGProfile(os);
                        continue;
                    }
                    if (!v.getAttr(Vuln.VulnAttr.Rule_ID).equals(pSt)) continue;
                    v.addSTIGProfile(os);
                }
            }
        }
    }

    private void parsePlainTextRelease() {
        if (this.parseXMLAttr("id").equals("release-info")) {
            try {
                String release = this.XMLR.getElementText();
                this.ImportSTIG.setSTIG_Release_Info(release);
                String[] releaseS = release.split("\\s");
                float relNum = -1.0f;
                if (releaseS[0].equals("Release:") || releaseS[0].equals("release:")) {
                    try {
                        relNum = Float.parseFloat(releaseS[1]);
                    }
                    catch (NumberFormatException e) {
                        relNum = -2.0f;
                    }
                }
                this.ImportSTIG.setReleaseID(relNum);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "", ex);
            }
        }
    }

    private void parseSTIGProfile() {
        try {
            String pName = this.splitProfile(this.parseXMLAttr("id"));
            ArrayList<String> ruleList = new ArrayList<String>();
            boolean trigger = true;
            while (this.XMLR.hasNext() && trigger) {
                this.XMLR.next();
                if (this.XMLR.isStartElement() && this.XMLR.getName().getLocalPart().equals("select")) {
                    if (!this.parseXMLAttr("selected").equalsIgnoreCase("false")) continue;
                    ruleList.add(this.splitScapId_RG(this.parseXMLAttr("idref")));
                    continue;
                }
                if (!this.XMLR.isEndElement() || !this.XMLR.getName().getLocalPart().equals("Profile")) continue;
                trigger = false;
            }
            this.ImportSTIG.addSTIG_ProfileMap(pName, ruleList);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "", ex);
        }
    }

    private void parseSTIGGroups() {
        try {
            int gpTagsLeft = 1;
            String gVID = this.parseXMLAttr("id");
            String gTitle = "";
            while (gpTagsLeft > 0 && this.XMLR.hasNext()) {
                this.XMLR.next();
                if (this.XMLR.isStartElement()) {
                    switch (this.XMLR.getLocalName()) {
                        case "title": {
                            gTitle = this.XMLR.getElementText();
                            break;
                        }
                        case "Group": {
                            ++gpTagsLeft;
                            String temp = this.parseXMLAttr("id");
                            if (temp.equals("")) break;
                            gVID = temp;
                            break;
                        }
                        case "Rule": {
                            Vuln vulnAdd = this.parseSTIGRule(gVID, gTitle);
                            this.ImportSTIG.addVulnObj(vulnAdd);
                        }
                    }
                    continue;
                }
                if (!this.XMLR.isEndElement() || !this.XMLR.getLocalName().equals("Group")) continue;
                --gpTagsLeft;
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "", ex);
        }
    }

    private Vuln parseSTIGRule(String vID, String vTitle) {
        Vuln newV = new Vuln();
        newV.setAttr(Vuln.VulnAttr.Vuln_Num, this.splitScapId_L(vID));
        newV.setAttr(Vuln.VulnAttr.Group_Title, vTitle);
        newV.setAttr(Vuln.VulnAttr.STIGRef, this.ImportSTIG.getSTIG_Title() + " :: Version " + this.ImportSTIG.getInterpretedVersion() + ", " + this.ImportSTIG.getInterpretedReleaseInfo());
        newV.setAttr(Vuln.VulnAttr.Rule_ID, this.splitScapId_RG(this.parseXMLAttr("id")));
        newV.setAttr(Vuln.VulnAttr.Severity, this.parseXMLAttr("severity"));
        newV.setAttr(Vuln.VulnAttr.Weight, this.parseXMLAttr("weight"));
        try {
            while (this.XMLR.hasNext()) {
                this.XMLR.next();
                if (this.XMLR.isStartElement()) {
                    block11 : switch (this.XMLR.getLocalName()) {
                        case "version": {
                            newV.setAttr(Vuln.VulnAttr.Rule_Ver, this.XMLR.getElementText());
                            break;
                        }
                        case "title": {
                            newV.setAttr(Vuln.VulnAttr.Rule_Title, this.XMLR.getElementText());
                            break;
                        }
                        case "description": {
                            this.parseRuleDescription(newV, this.XMLR.getElementText());
                            break;
                        }
                        case "reference": {
                            while (this.XMLR.hasNext()) {
                                if (this.XMLR.isStartElement() && this.XMLR.getLocalName().equals("identifier")) {
                                    newV.setAttr(Vuln.VulnAttr.TargetKey, this.XMLR.getElementText());
                                }
                                if (this.XMLR.isEndElement() && this.XMLR.getLocalName().equals("reference")) break block11;
                                this.XMLR.next();
                            }
                            break;
                        }
                        case "ident": {
                            this.parseCCI(newV);
                            break;
                        }
                        case "fixtext": {
                            newV.setAttr(Vuln.VulnAttr.Fix_Text, this.XMLR.getElementText());
                            break;
                        }
                        case "check-content": {
                            newV.setAttr(Vuln.VulnAttr.Check_Content, this.XMLR.getElementText());
                            break;
                        }
                        case "check-content-ref": {
                            newV.setAttr(Vuln.VulnAttr.Check_Content_Ref, this.parseXMLAttr("name"));
                        }
                    }
                    continue;
                }
                if (!this.XMLR.isEndElement() || !this.XMLR.getLocalName().equals("Rule")) continue;
                break;
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, "", ex);
        }
        return newV;
    }

    private void parseCCI(Vuln v) throws XMLStreamException {
        if (this.parseXMLAttr("system").contains("cci")) {
            String idText = this.XMLR.getElementText();
            this.ImportSTIG.setHasCCI(true);
            if (!idText.contains(",")) {
                v.addCCIVal(idText);
                CCIReader.CCI_Store TempCCI = CCIReader.getCCIReader().getCCIbyName(idText);
                v.addCCI(TempCCI);
            } else {
                String[] cciTok;
                for (String s : cciTok = idText.split(",")) {
                    v.addCCIVal(s);
                    CCIReader.CCI_Store TempCCI = CCIReader.getCCIReader().getCCIbyName(s);
                    v.addCCI(TempCCI);
                }
            }
        }
    }

    private void parseRuleDescription(Vuln v, String desc) {
        if (desc.contains("<VulnDiscussion>") && desc.contains("<FalsePositives>") && desc.contains("<FalseNegatives>")) {
            int begin = desc.indexOf("<VulnDiscussion>");
            int end = desc.indexOf("</VulnDiscussion>");
            v.setAttr(Vuln.VulnAttr.Vuln_Discuss, desc.substring(begin + 16, end));
            begin = desc.indexOf("<FalsePositives>", end);
            end = desc.indexOf("</FalsePositives>", begin);
            v.setAttr(Vuln.VulnAttr.False_Positives, desc.substring(begin + 16, end));
            begin = desc.indexOf("<FalseNegatives>", end);
            end = desc.indexOf("</FalseNegatives>", begin);
            v.setAttr(Vuln.VulnAttr.False_Negatives, desc.substring(begin + 16, end));
            begin = desc.indexOf("<Documentable>", end);
            end = desc.indexOf("</Documentable>", begin);
            v.setAttr(Vuln.VulnAttr.Documentable, desc.substring(begin + 14, end));
            begin = desc.indexOf("<Mitigations>", end);
            end = desc.indexOf("</Mitigations>", begin);
            v.setAttr(Vuln.VulnAttr.Mitigations, desc.substring(begin + 13, end));
            begin = desc.indexOf("<SeverityOverrideGuidance>", end);
            end = desc.indexOf("</SeverityOverrideGuidance>", begin);
            if (begin < 0 || end < 0) {
                begin = desc.indexOf("<SecurityOverrideGuidance>");
                end = desc.indexOf("</SecurityOverrideGuidance>");
            }
            v.setAttr(Vuln.VulnAttr.Security_Override_Guidance, desc.substring(begin + 26, end));
            begin = desc.indexOf("<PotentialImpacts>", end);
            end = desc.indexOf("</PotentialImpacts>", begin);
            v.setAttr(Vuln.VulnAttr.Potential_Impact, desc.substring(begin + 18, end));
            begin = desc.indexOf("<ThirdPartyTools>", end);
            end = desc.indexOf("</ThirdPartyTools>", begin);
            v.setAttr(Vuln.VulnAttr.Third_Party_Tools, desc.substring(begin + 17, end));
            begin = desc.indexOf("<MitigationControl>", end);
            end = desc.indexOf("</MitigationControl>", begin);
            v.setAttr(Vuln.VulnAttr.Mitigation_Control, desc.substring(begin + 19, end));
            begin = desc.indexOf("<Responsibility>", end);
            end = desc.indexOf("</Responsibility>", begin);
            v.setAttr(Vuln.VulnAttr.Responsibility, desc.substring(begin + 16, end));
            begin = desc.indexOf("<IAControls>", end);
            end = desc.indexOf("</IAControls>", begin);
            v.setAttr(Vuln.VulnAttr.IA_Controls, desc.substring(begin + 12, end));
        }
    }

    private String parseXMLAttr(String attr) {
        String ret = "";
        for (int i = 0; i < this.XMLR.getAttributeCount(); ++i) {
            if (!this.XMLR.getAttributeName(i).getLocalPart().equals(attr)) continue;
            ret = this.XMLR.getAttributeValue(i);
            break;
        }
        return ret;
    }

    private String splitProfile(String prof) {
        String spStr = prof;
        if (prof.contains("profile")) {
            int i;
            spStr = "";
            String[] split = prof.split("_");
            int idPos = 0;
            for (i = 0; i < split.length; ++i) {
                if (!split[i].equals("profile")) continue;
                idPos = i + 1;
                break;
            }
            for (i = idPos; i < split.length; ++i) {
                spStr = spStr + split[i] + "_";
            }
            spStr = spStr.substring(0, spStr.length() - 1);
        }
        return spStr;
    }

    private String splitScapId_L(String id) {
        String spStr = "";
        String[] split = id.split("_");
        spStr = split[split.length - 1];
        return spStr;
    }

    private String splitScapId_RG(String id) {
        String spStr = "";
        String[] split = id.split("_");
        spStr = split[split.length - 1].equals("rule") ? split[split.length - 2] + "_" + split[split.length - 1] : (split[split.length - 2].equals("group") ? split[split.length - 1] : id);
        return spStr;
    }

    private void cycleToText() {
        while (!this.XMLR.isCharacters()) {
            try {
                this.XMLR.next();
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(XCCDF_Read.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static XCCDF_Read getXCCDFReader() {
        if (Reader == null) {
            Reader = new XCCDF_Read();
        }
        return Reader;
    }

    private void setFile(File f) {
        this.Fin = f;
    }

    public STIG getImportStig() {
        return this.ImportSTIG;
    }

    private void printVuln(Vuln newV) {
        System.out.print(newV.getAttr(Vuln.VulnAttr.Vuln_Num));
        System.out.print("  " + newV.getAllCCIText());
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.STIGRef));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Check_Content));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Check_Content_Ref));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Fix_Text));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Severity));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Group_Title));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Rule_ID));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Rule_Ver));
        System.out.println("  " + newV.getAttr(Vuln.VulnAttr.Vuln_Discuss));
        System.out.println("  " + newV.getAttr(Vuln.VulnAttr.False_Positives));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.False_Negatives));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Documentable));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Mitigations));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Security_Override_Guidance));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Potential_Impact));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Third_Party_Tools));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Mitigation_Control));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Responsibility));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.IA_Controls));
        System.out.print("  " + newV.getAttr(Vuln.VulnAttr.Rule_Title) + "\n");
    }

    private void printSTIGValues(STIG inStig) {
        System.out.println(inStig.getSTIG_Title());
        System.out.println(inStig.getSTIG_Description());
        System.out.println(inStig.getSTIG_Version());
        System.out.println(inStig.getSTIG_notice());
        System.out.println(inStig.getSTIG_FileName());
        System.out.println(inStig.getSTIG_OverviewDoc());
        System.out.println(inStig.getSTIG_BID());
    }

    private void printSTIGProfiles(STIG inStig) {
        Map p = inStig.getSTIG_ProfileMap();
        for (Object s : p.keySet()) {
            String os = (String)s;
            ArrayList tepid = (ArrayList)p.get(s);
            System.out.println(os + " : " + tepid.size());
        }
    }
}

