/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.parser.DebugInfoParser;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInfoVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DebugInfoVisitor.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        try {
            int debugOffset = mth.getDebugInfoOffset();
            if (debugOffset > 0 && mth.dex().checkOffset(debugOffset)) {
                this.processDebugInfo(mth, debugOffset);
            }
        }
        catch (Exception e) {
            LOG.error("Error in debug info parser: {}", (Object)ErrorsCounter.formatMsg(mth, e.getMessage()), (Object)e);
        }
        finally {
            mth.unloadInsnArr();
        }
    }

    private void processDebugInfo(MethodNode mth, int debugOffset) throws DecodeException {
        InsnNode[] insnArr = mth.getInstructions();
        DebugInfoParser debugInfoParser = new DebugInfoParser(mth, debugOffset, insnArr);
        debugInfoParser.process();
        if (insnArr.length != 0) {
            this.setMethodSourceLine(mth, insnArr);
        }
        if (!mth.getReturnType().equals(ArgType.VOID)) {
            this.setLineForReturn(mth, insnArr);
        }
    }

    private void setLineForReturn(MethodNode mth, InsnNode[] insnArr) {
        for (BlockNode exit : mth.getExitBlocks()) {
            InsnNode oldRet;
            InsnNode ret = BlockUtils.getLastInsn(exit);
            if (ret == null || (oldRet = insnArr[ret.getOffset()]) == ret) continue;
            RegisterArg oldArg = (RegisterArg)oldRet.getArg(0);
            RegisterArg newArg = (RegisterArg)ret.getArg(0);
            newArg.mergeDebugInfo(oldArg.getType(), oldArg.getName());
            ret.setSourceLine(oldRet.getSourceLine());
        }
    }

    private void setMethodSourceLine(MethodNode mth, InsnNode[] insnArr) {
        for (InsnNode insn : insnArr) {
            if (insn == null) continue;
            int line = insn.getSourceLine();
            if (line != 0) {
                mth.setSourceLine(line - 1);
            }
            return;
        }
    }
}

