/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import org.openqa.selenium.Platform;

class ExecutableFinder {
    private static final ImmutableSet<String> ENDINGS = Platform.getCurrent().is(Platform.WINDOWS) ? ImmutableSet.of((Object)"", (Object)".exe", (Object)".com", (Object)".bat") : ImmutableSet.of((Object)"");
    private static final Method JDK6_CAN_EXECUTE = ExecutableFinder.findJdk6CanExecuteMethod();
    private final ImmutableSet.Builder<String> pathSegmentBuilder = new ImmutableSet.Builder();

    ExecutableFinder() {
    }

    public String find(String named) {
        File file = new File(named);
        if (ExecutableFinder.canExecute(file)) {
            return named;
        }
        this.addPathFromEnvironment();
        if (Platform.getCurrent().is(Platform.MAC)) {
            this.addMacSpecificPath();
        }
        for (String pathSegment : this.pathSegmentBuilder.build()) {
            for (String ending : ENDINGS) {
                file = new File(pathSegment, String.valueOf(named) + ending);
                if (!ExecutableFinder.canExecute(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private void addPathFromEnvironment() {
        String path;
        String pathName = "PATH";
        Map<String, String> env = System.getenv();
        if (!env.containsKey(pathName)) {
            for (String key : env.keySet()) {
                if (!pathName.equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        if ((path = env.get(pathName)) != null) {
            this.pathSegmentBuilder.add((Object[])path.split(File.pathSeparator));
        }
    }

    private void addMacSpecificPath() {
        File pathFile = new File("/etc/paths");
        if (pathFile.exists()) {
            try {
                this.pathSegmentBuilder.addAll((Iterable)Files.readLines((File)pathFile, (Charset)Charsets.UTF_8));
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean canExecute(File file) {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        if (JDK6_CAN_EXECUTE != null) {
            try {
                return (Boolean)JDK6_CAN_EXECUTE.invoke((Object)file, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return true;
    }

    private static Method findJdk6CanExecuteMethod() {
        try {
            return File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

