/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Preconditions;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.net.PortProber;

public class InternetExplorerDriverServer {
    private static final Logger log = Logger.getLogger(InternetExplorerDriverServer.class.getName());
    private static final IEServer lib = InternetExplorerDriverServer.initializeLib();
    private Pointer server;
    private int port;

    public InternetExplorerDriverServer(int port) {
        this.port = port;
    }

    public URL getUrl() {
        if (!lib.ServerIsRunning()) {
            throw new WebDriverException("Server has not yet been started");
        }
        try {
            return new URL("http://localhost:" + this.port);
        }
        catch (MalformedURLException e) {
            throw new WebDriverException(e);
        }
    }

    public void start() {
        if (lib.ServerIsRunning()) {
            this.port = lib.GetServerPort();
            return;
        }
        if (this.port == 0) {
            this.port = PortProber.findFreePort();
        }
        this.server = lib.StartServer(this.port);
        Preconditions.checkArgument((boolean)PortProber.pollPort(this.port), (Object)"Cannot connect to IE server");
    }

    public void stop() {
        if (lib != null) {
            lib.StopServer(this.server);
        }
    }

    private static IEServer initializeLib() {
        if (lib != null) {
            return lib;
        }
        log.warning("This method of starting the IE driver is deprecated and will be removed in selenium 2.26. Please download the IEDriverServer.exe from http://code.google.com/p/selenium/downloads/list and ensure that it is in your PATH.");
        File parentDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("webdriver", "libs");
        try {
            FileHandler.copyResource(parentDir, InternetExplorerDriverServer.class, "IEDriver.dll");
        }
        catch (IOException ioe) {
            try {
                if (Boolean.getBoolean("webdriver.development")) {
                    String arch = System.getProperty("os.arch", "").contains("64") ? "x64" : "Win32";
                    ArrayList<String> sourcePaths = new ArrayList<String>();
                    sourcePaths.add("build\\cpp\\" + arch + "\\Debug");
                    sourcePaths.add("..\\build\\cpp\\" + arch + "\\Debug");
                    sourcePaths.add("..\\..\\build\\cpp\\" + arch + "\\Debug");
                    sourcePaths.add("build\\cpp\\" + arch + "\\Release");
                    sourcePaths.add("..\\build\\cpp\\" + arch + "\\Release");
                    sourcePaths.add("..\\..\\build\\cpp\\" + arch + "\\Release");
                    boolean copied = false;
                    for (String path : sourcePaths) {
                        File sourceFile = new File(path, "IEDriver.dll");
                        if (!sourceFile.exists()) continue;
                        FileHandler.copy(sourceFile, new File(parentDir, "IEDriver.dll"));
                        copied = true;
                        break;
                    }
                    if (!copied) {
                        throw new WebDriverException("Couldn't find IEDriver.dll: " + arch);
                    }
                }
                throw new WebDriverException(ioe);
            }
            catch (IOException ioe2) {
                throw new WebDriverException(ioe2);
            }
        }
        System.setProperty("jna.library.path", String.valueOf(System.getProperty("jna.library.path", "")) + File.pathSeparator + parentDir);
        try {
            IEServer server = (IEServer)Native.loadLibrary((String)"IEDriver", IEServer.class);
            Runtime.getRuntime().addShutdownHook(new IEDriverDllCleaner(parentDir));
            return server;
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("new File(\".\").getAbsolutePath() = " + new File(".").getAbsolutePath());
            throw new WebDriverException(e);
        }
    }

    private static class IEDriverDllCleaner
    extends Thread {
        private final File parentDir;

        public IEDriverDllCleaner(File parentDir) {
            this.parentDir = parentDir;
        }

        @Override
        public void run() {
            ((Library.Handler)Proxy.getInvocationHandler(lib)).getNativeLibrary().dispose();
            TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(this.parentDir);
        }
    }

    private static interface IEServer
    extends StdCallLibrary {
        public Pointer StartServer(int var1);

        public void StopServer(Pointer var1);

        public int GetServerPort();

        public boolean ServerIsRunning();
    }
}

