/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.SafariLocator;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.safari.SafariDriverConnection;
import org.openqa.selenium.safari.SafariDriverServer;

class SafariDriverCommandExecutor
implements CommandExecutor {
    private final SafariDriverServer server;
    private final BrowserLocator browserLocator;
    private CommandLine commandLine;
    private SafariDriverConnection connection;

    public SafariDriverCommandExecutor(int port) {
        this.server = new SafariDriverServer(port);
        this.browserLocator = new SafariLocator();
    }

    public void start() throws IOException {
        if (this.commandLine != null) {
            return;
        }
        this.server.start();
        File connectFile = this.prepareConnectFile(this.server.getUri());
        BrowserInstallation installation = this.browserLocator.findBrowserLocationOrFail();
        this.commandLine = new CommandLine(installation.launcherFilePath(), connectFile.getAbsolutePath());
        this.commandLine.executeAsync();
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        try {
            this.connection = this.server.getConnection(45L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.stop();
            throw new WebDriverException(String.format("Failed to connect to SafariDriver after %d ms", stopwatch.elapsedMillis()));
        }
    }

    private File prepareConnectFile(String serverUri) throws IOException {
        File tmpDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("anonymous", "safaridriver");
        File launchFile = new File(tmpDir, "connect.html");
        launchFile.deleteOnExit();
        String contents = String.format("<!DOCTYPE html><script>window.location = '%s';</script>", serverUri);
        Files.write(contents, launchFile, Charsets.UTF_8);
        return launchFile;
    }

    public void stop() {
        if (this.commandLine != null) {
            this.commandLine.destroy();
            this.commandLine = null;
        }
        this.server.stop();
    }

    @Override
    public Response execute(Command command) {
        Preconditions.checkState(this.connection != null, "Executor has not been started yet");
        try {
            return this.connection.send(command);
        }
        catch (InterruptedException e) {
            throw new WebDriverException(e);
        }
    }
}

