/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.remote.CoordinatesUtils;
import org.openqa.selenium.remote.ExecuteMethod;

public class RemoteTouchScreen
implements TouchScreen {
    private final ExecuteMethod executeMethod;

    public RemoteTouchScreen(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    @Override
    public void singleTap(Coordinates where) {
        Map<String, Object> singleTapParams = CoordinatesUtils.paramsFromCoordinates(where);
        this.executeMethod.execute("touchSingleTap", singleTapParams);
    }

    @Override
    public void down(int x, int y) {
        HashMap<String, Integer> downParams = new HashMap<String, Integer>();
        downParams.put("x", x);
        downParams.put("y", y);
        this.executeMethod.execute("touchDown", downParams);
    }

    @Override
    public void up(int x, int y) {
        HashMap<String, Integer> upParams = new HashMap<String, Integer>();
        upParams.put("x", x);
        upParams.put("y", y);
        this.executeMethod.execute("touchUp", upParams);
    }

    @Override
    public void move(int x, int y) {
        HashMap<String, Integer> moveParams = new HashMap<String, Integer>();
        moveParams.put("x", x);
        moveParams.put("y", y);
        this.executeMethod.execute("touchMove", moveParams);
    }

    @Override
    public void scroll(Coordinates where, int xOffset, int yOffset) {
        Map<String, Object> scrollParams = CoordinatesUtils.paramsFromCoordinates(where);
        scrollParams.put("xoffset", xOffset);
        scrollParams.put("yoffset", yOffset);
        this.executeMethod.execute("touchScroll", scrollParams);
    }

    @Override
    public void doubleTap(Coordinates where) {
        Map<String, Object> doubleTapParams = CoordinatesUtils.paramsFromCoordinates(where);
        this.executeMethod.execute("touchDoubleTap", doubleTapParams);
    }

    @Override
    public void longPress(Coordinates where) {
        Map<String, Object> longPressParams = CoordinatesUtils.paramsFromCoordinates(where);
        this.executeMethod.execute("touchLongPress", longPressParams);
    }

    @Override
    public void scroll(int xOffset, int yOffset) {
        HashMap<String, Integer> scrollParams = new HashMap<String, Integer>();
        scrollParams.put("xoffset", xOffset);
        scrollParams.put("yoffset", yOffset);
        this.executeMethod.execute("touchScroll", scrollParams);
    }

    @Override
    public void flick(int xSpeed, int ySpeed) {
        HashMap<String, Integer> flickParams = new HashMap<String, Integer>();
        flickParams.put("xspeed", xSpeed);
        flickParams.put("yspeed", ySpeed);
        this.executeMethod.execute("touchFlick", flickParams);
    }

    @Override
    public void flick(Coordinates where, int xOffset, int yOffset, int speed) {
        Map<String, Object> flickParams = CoordinatesUtils.paramsFromCoordinates(where);
        flickParams.put("xoffset", xOffset);
        flickParams.put("yoffset", yOffset);
        flickParams.put("speed", speed);
        this.executeMethod.execute("touchFlick", flickParams);
    }
}

