/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.thoughtworks.selenium.BrowserConfigurationOptions;
import com.thoughtworks.selenium.Selenium;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.internal.selenesedriver.SeleneseFunction;

public class NewSession
implements SeleneseFunction<Map<String, Object>> {
    @Override
    public Map<String, Object> apply(Selenium selenium, Map<String, ?> args) {
        Capabilities capabilities = (Capabilities)args.get("desiredCapabilities");
        selenium.start(this.getBrowserConfigurationOptions(capabilities));
        selenium.useXpathLibrary("native");
        selenium.allowNativeXpath("true");
        HashMap<String, Object> seenCapabilities = new HashMap<String, Object>();
        seenCapabilities.put("browserName", capabilities.getBrowserName());
        seenCapabilities.put("version", capabilities.getVersion());
        seenCapabilities.put("platform", Platform.getCurrent().toString());
        seenCapabilities.put("javascriptEnabled", true);
        seenCapabilities.put("takesScreenshot", true);
        return seenCapabilities;
    }

    private String getBrowserConfigurationOptions(Capabilities capabilities) {
        BrowserConfigurationOptions options = new BrowserConfigurationOptions();
        for (Map.Entry<String, ?> capability : capabilities.asMap().entrySet()) {
            options.set(capability.getKey(), String.valueOf(capability.getValue()));
        }
        return options.serialize();
    }
}

