/*
 * Decompiled with CFR 0.152.
 */
package commandline;

import commandline.Debug;
import commandline.HaltHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xmlparser.XmlConfigReader;

public class CmdArgsParser {
    private String start_configfile;
    private String configfile;
    private String reportfile;
    private String proxyIP_port;
    private String chromedriver_file;
    private String iedriver_file;
    private boolean IE_enabled = false;
    private boolean stop_first_positive = false;
    private int delay = 0;
    private String remoteXSSVectorsRepositoryURL;
    private String usage = "snuck [-start xmlconfigfile] -config xmlconfigfile -report htmlreportfile [-d #ms_delay] [-proxy IP:port]  [-chrome chromedriver]  [-ie iedriver] [-remotevectors URL] [-stop-first] [-reflected targetURL -p parameter_toTest] [-no-multi]";

    public CmdArgsParser(String[] args) {
        this.parseArguments(args);
    }

    public void parseArguments(String[] args) {
        int i = 0;
        String targetURL = null;
        String targetParam = null;
        if (args.length == 0) {
            this.showHelpMessage();
            HaltHandler.quit_nok();
        } else {
            for (String tmp : args) {
                if (!tmp.equals("-help") && !tmp.equals("--help") && !tmp.equals("-h") && !tmp.equals("--h")) continue;
                this.showHelpMessage();
                HaltHandler.quit_ok();
            }
            while (i < args.length) {
                String arg = args[i];
                if (arg.startsWith("-")) {
                    if (arg.equals("-config")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            this.configfile = args[i + 1];
                            ++i;
                        } else {
                            Debug.printError("ERROR: -config requires a filename");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-report")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            this.reportfile = args[i + 1];
                            ++i;
                            File f = new File(this.reportfile);
                            if (f.exists()) {
                                Debug.printError("ERROR: " + this.reportfile + " already exists. ");
                                Debug.printError("Press Y and Enter to overwrite it or N and Enter to exit");
                                String input = Debug.readLine();
                                if (input != null && (input.equals("Y") || input.equals("y"))) {
                                    Debug.print("\n");
                                } else {
                                    HaltHandler.quit_nok();
                                }
                            }
                        } else {
                            Debug.printError("ERROR: -report requires a filename");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-d")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            try {
                                this.delay = Integer.valueOf(args[i + 1]);
                            }
                            catch (Exception e) {
                                Debug.printError("ERROR: provide an integer value for the delay");
                                HaltHandler.quit_nok();
                            }
                            ++i;
                        } else {
                            Debug.printError("ERROR: -d requires an integer (ms)");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-start")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            this.start_configfile = args[i + 1];
                            ++i;
                        } else {
                            Debug.printError("ERROR: -start requires a filename");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-proxy")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            this.proxyIP_port = args[i + 1];
                            ++i;
                            if (this.proxyIP_port.contains(":")) {
                                String ipAddress_Pattern = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
                                Pattern pattern = Pattern.compile(ipAddress_Pattern);
                                Matcher matcher = pattern.matcher(this.proxyIP_port.substring(0, this.proxyIP_port.indexOf(":")));
                                if (!matcher.matches()) {
                                    Debug.printError("ERROR: invalid IP address");
                                    HaltHandler.quit_nok();
                                }
                                String port = this.proxyIP_port.substring(this.proxyIP_port.indexOf(":") + 1);
                                try {
                                    Integer.parseInt(port);
                                }
                                catch (Exception e) {
                                    Debug.printError("ERROR: invalid port number");
                                    HaltHandler.quit_nok();
                                }
                            } else {
                                Debug.printError("ERROR: invalid syntax for proxy address");
                                HaltHandler.quit_nok();
                            }
                        } else {
                            Debug.printError("ERROR: -proxy requires a proxy server (IP:port)");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-chrome")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            this.chromedriver_file = args[i + 1];
                            ++i;
                        } else {
                            Debug.printError("ERROR: -chrome requires the path to chromedriver");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-ie")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            this.iedriver_file = args[i + 1];
                            ++i;
                            this.IE_enabled = true;
                        } else {
                            Debug.printError("ERROR: -ie requires the path to IEdriver");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-remotevectors")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            this.remoteXSSVectorsRepositoryURL = args[i + 1];
                            ++i;
                        } else {
                            Debug.printError("ERROR: -remotevectors requires a repository URL");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-stop-first")) {
                        this.stop_first_positive = true;
                    } else if (arg.equals("-reflected")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            if (!args[i + 1].startsWith("http://") && !args[i + 1].startsWith("https://")) {
                                Debug.printError("ERROR: -reflected requires a target URL that starts with http(s?)://");
                                HaltHandler.quit_nok();
                            }
                            targetURL = args[i + 1];
                            ++i;
                        } else {
                            Debug.printError("ERROR: -reflected requires a target URL");
                            HaltHandler.quit_nok();
                        }
                    } else if (arg.equals("-p")) {
                        if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                            targetParam = args[i + 1];
                            ++i;
                        }
                    } else if (arg.equals("-no-multi")) {
                        this.delay = 1;
                    } else {
                        Debug.printError(this.usage);
                        HaltHandler.quit_nok();
                    }
                }
                ++i;
            }
            if (targetURL != null && targetParam == null) {
                Debug.printError("INFO: -reflected should be associated to an HTTP GET parameter (-p argument).\n\tThe injection will be positioned at the end of the current path in the form of: http://target.foo/injection.\n\tNote that supplied HTTP GET parameters won't be considered.");
                this.writeXmlFile(targetURL, "");
            } else if (targetURL == null && targetParam != null) {
                Debug.printError("ERROR: -p must be associated to a target URL (-reflected argument)");
                HaltHandler.quit_nok();
            } else if (targetURL != null && targetParam != null) {
                if (this.configfile != null) {
                    Debug.printError("ERROR: -config cannot be used with -reflected");
                    HaltHandler.quit_nok();
                }
                this.writeXmlFile(targetURL, targetParam);
            }
            if (this.configfile == null || this.reportfile == null) {
                Debug.printError(this.usage);
                HaltHandler.quit_ok();
            } else {
                Debug.print("INFO: If [!] is showed during a test, then a bypass has been detected");
                Debug.print("INFO: You can stop the test through CTRL+C - if this happens, then a list of successful attack vectors will be printed in stdout\n");
                Debug.print("INFO: Starting...\n");
            }
        }
    }

    private void writeXmlFile(String targetURL, String targetParam) {
        String temp_conf_file = XmlConfigReader.generateReflectedConfigFile(targetURL, targetParam);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy-HH-mm-ss");
        Date date = new Date();
        FileWriter fstream = null;
        BufferedWriter out = null;
        this.configfile = "config_" + dateFormat.format(date).toString() + ".xml";
        try {
            fstream = new FileWriter(this.configfile);
        }
        catch (IOException e) {
            Debug.printError("ERROR: unable to create the XML config file");
            HaltHandler.quit_nok();
        }
        out = new BufferedWriter(fstream);
        try {
            out.write(temp_conf_file);
            out.close();
        }
        catch (IOException e) {
            Debug.printError("ERROR: unable to write the XML config file");
            HaltHandler.quit_nok();
        }
    }

    private void showHelpMessage() {
        Debug.print();
        Debug.print("Usage: ");
        Debug.print();
        Debug.print(this.usage);
        Debug.print();
        Debug.print("Options:");
        Debug.print();
        Debug.print(" -start\t\t path to the login use case (XML file)");
        Debug.print(" -config\t path to the injection use case (XML file)");
        Debug.print(" -report\t report file name (html extension is required)");
        Debug.print(" -d\t\t delay (ms) between each injection");
        Debug.print(" -proxy\t\t proxy server (IP:port)");
        Debug.print(" -chrome\t perform a test with Google Chrome, instead of Firefox.\n\t\t It needs the path to the chromedriver");
        Debug.print(" -ie\t\t perform a test with Internet Explorer, instead of Firefox.\n\t\t Disable the XSS filter in advance");
        Debug.print(" -remotevectors\t use an up-to-date online attack vectors' source instead of the local one");
        Debug.print(" -stop-first\t stop the test upon a successful vector is detected");
        Debug.print(" -no-multi\t deactivate multithreading for the reverse engineering process - a sequential approach will be adopted");
        Debug.print(" -reflected\t perform a reflected XSS test (without writing the XML config file)");
        Debug.print(" -p\t\t HTTP GET parameter to inject (useful if -reflected is setted)");
        Debug.print(" -help\t\t show this help menu");
    }

    public String getProxyInfo() {
        return this.proxyIP_port;
    }

    public String getStartConfigfileName() {
        return this.start_configfile;
    }

    public String getConfigfileName() {
        return this.configfile;
    }

    public String getReportfileName() {
        return this.reportfile;
    }

    public int getDelayInterval() {
        return this.delay;
    }

    public String getChromeDriverPath() {
        return this.chromedriver_file;
    }

    public boolean getEnabledIE() {
        return this.IE_enabled;
    }

    public String getAttackVectorsRepositoryURL() {
        return this.remoteXSSVectorsRepositoryURL;
    }

    public String getIEDriverPath() {
        return this.iedriver_file;
    }

    public boolean getStopFirstPositive() {
        return this.stop_first_positive;
    }
}

