/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSelectElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

public class HTMLOptionsCollection
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private HtmlSelect htmlSelect_;

    public HTMLOptionsCollection() {
    }

    public HTMLOptionsCollection(SimpleScriptable parentScope) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public void initialize(HtmlSelect select) {
        WebAssert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0) {
            throw Context.reportRuntimeError("Index or size is negative");
        }
        Object response = index >= this.htmlSelect_.getOptionSize() ? Context.getUndefinedValue() : this.getScriptableFor(this.htmlSelect_.getOption(index));
        return response;
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.htmlSelect_ == null) {
            super.put(name, start, value);
            return;
        }
        HTMLSelectElement parent = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        if (!this.has(name, start) && ScriptableObject.hasProperty((Scriptable)parent, name)) {
            ScriptableObject.putProperty((Scriptable)parent, name, value);
        } else {
            super.put(name, start, value);
        }
    }

    public Object getWithFallback(String name) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_87) && "childNodes".equals(name)) {
            return NOT_FOUND;
        }
        HTMLSelectElement select = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        return ScriptableObject.getProperty((Scriptable)select, name);
    }

    public Object jsxFunction_item(int index) {
        return this.get(index, null);
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            HTMLOptionElement option = (HTMLOptionElement)newValue;
            HtmlOption htmlOption = option.getDomNodeOrNull();
            if (index >= this.jsxGet_length()) {
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
        if (this.jsxGet_length() == 1 && !this.htmlSelect_.isMultipleSelectEnabled()) {
            ((HTMLSelectElement)this.htmlSelect_.getScriptObject()).jsxSet_selectedIndex(0);
        }
    }

    public int jsxGet_length() {
        return this.htmlSelect_.getOptionSize();
    }

    public void jsxSet_length(int newLength) {
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            for (int i = currentLength; i < newLength; ++i) {
                HtmlOption option = (HtmlOption)HTMLParser.getFactory("option").createElement(this.htmlSelect_.getPage(), "option", null);
                this.htmlSelect_.appendOption(option);
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_88)) continue;
                option.appendChild(new DomText(option.getPage(), ""));
            }
        }
    }

    public void jsxFunction_add(Object newOptionObject, Object newIndex) {
        int index = this.jsxGet_length();
        if (newIndex instanceof Number) {
            index = ((Number)newIndex).intValue();
        }
        this.put(index, null, newOptionObject);
    }

    public void jsxFunction_remove(int index) {
        if (index < 0) {
            Context.reportRuntimeError("Invalid index: " + index);
        }
        if (index < this.jsxGet_length()) {
            this.htmlSelect_.removeOption(index);
        }
    }
}

