/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

public class RowContainer
extends HTMLElement {
    private HTMLCollection rows_;

    public Object jsxGet_rows() {
        if (this.rows_ == null) {
            this.rows_ = new HTMLCollection(this.getDomNodeOrDie(), false, "rows"){

                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlTableRow && RowContainer.this.isContainedRow((HtmlTableRow)node);
                }
            };
        }
        return this.rows_;
    }

    protected boolean isContainedRow(HtmlTableRow row) {
        return row.getParentNode() == this.getDomNodeOrDie();
    }

    public void jsxFunction_deleteRow(int rowIndex) {
        boolean rowIndexValid;
        HTMLCollection rows = (HTMLCollection)this.jsxGet_rows();
        int rowCount = rows.jsxGet_length();
        if (rowIndex == -1) {
            rowIndex = rowCount - 1;
        }
        boolean bl = rowIndexValid = rowIndex >= 0 && rowIndex < rowCount;
        if (rowIndexValid) {
            SimpleScriptable row = (SimpleScriptable)rows.jsxFunction_item(rowIndex);
            ((DomNode)row.getDomNodeOrDie()).remove();
        }
    }

    public Object jsxFunction_insertRow(Object index) {
        int rowIndex = -1;
        if (index != Undefined.instance) {
            rowIndex = (int)Context.toNumber(index);
        }
        HTMLCollection rows = (HTMLCollection)this.jsxGet_rows();
        int rowCount = rows.jsxGet_length();
        int r = rowIndex == -1 || rowIndex == rowCount ? Math.max(0, rowCount - 1) : rowIndex;
        if (r < 0 || r > rowCount) {
            throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount (index: " + rowIndex + ", " + rowCount + " rows)");
        }
        return this.insertRow(r);
    }

    public Object insertRow(int index) {
        HTMLCollection rows = (HTMLCollection)this.jsxGet_rows();
        int rowCount = rows.jsxGet_length();
        HtmlElement newRow = ((HtmlPage)this.getDomNodeOrDie().getPage()).createElement("tr");
        if (rowCount == 0) {
            this.getDomNodeOrDie().appendChild(newRow);
        } else {
            SimpleScriptable row = (SimpleScriptable)rows.jsxFunction_item(index);
            if (index >= rowCount - 1) {
                ((DomNode)row.getDomNodeOrDie()).getParentNode().appendChild(newRow);
            } else {
                ((DomNode)row.getDomNodeOrDie()).insertBefore(newRow);
            }
        }
        return this.getScriptableFor(newRow);
    }

    public Object jsxFunction_moveRow(int sourceIndex, int targetIndex) {
        boolean targetIndexValid;
        HTMLCollection rows = (HTMLCollection)this.jsxGet_rows();
        int rowCount = rows.jsxGet_length();
        boolean sourceIndexValid = sourceIndex >= 0 && sourceIndex < rowCount;
        boolean bl = targetIndexValid = targetIndex >= 0 && targetIndex < rowCount;
        if (sourceIndexValid && targetIndexValid) {
            SimpleScriptable sourceRow = (SimpleScriptable)rows.jsxFunction_item(sourceIndex);
            SimpleScriptable targetRow = (SimpleScriptable)rows.jsxFunction_item(targetIndex);
            ((DomNode)targetRow.getDomNodeOrDie()).insertBefore((DomNode)sourceRow.getDomNodeOrDie());
            return sourceRow;
        }
        return null;
    }

    public String jsxGet_align() {
        return this.getAlign(true);
    }

    public void jsxSet_align(String align) {
        this.setAlign(align, false);
    }
}

