/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.oam;

import java.util.Arrays;
import java.util.Map;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.ss7.management.console.ShellExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCAPExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(TCAPExecutor.class);
    private FastMap<String, TCAPStackImpl> tcapStacks = new FastMap();
    private TCAPStackImpl tcapStack = null;

    public Map<String, TCAPStackImpl> getTcapStacks() {
        return this.tcapStacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTcapStacks(Map<String, TCAPStackImpl> mtp3UserPartsTemp) {
        if (mtp3UserPartsTemp != null) {
            TCAPExecutor tCAPExecutor = this;
            synchronized (tCAPExecutor) {
                FastMap<String, TCAPStackImpl> newMtp3UserPart = new FastMap<String, TCAPStackImpl>();
                newMtp3UserPart.putAll(mtp3UserPartsTemp);
                this.tcapStacks = newMtp3UserPart;
            }
        }
    }

    private void setDefaultValue() {
        if (this.tcapStack == null) {
            Map.Entry<String, TCAPStackImpl> sccpStacksTmp = this.tcapStacks.entrySet().iterator().next();
            this.tcapStack = sccpStacksTmp.getValue();
        }
    }

    @Override
    public String execute(String[] options) {
        if (this.tcapStacks == null || this.tcapStacks.size() == 0) {
            logger.warn("TCAPStackImpl not set. Command will not be executed ");
            return "Server Error";
        }
        if (options == null || options.length < 2) {
            return "Invalid Command";
        }
        String firstOption = options[1];
        if (firstOption == null) {
            return "Invalid Command";
        }
        try {
            if (firstOption.equals("set")) {
                return this.manageSet(options);
            }
            if (firstOption.equals("get")) {
                return this.manageGet(options);
            }
        }
        catch (Throwable t) {
            logger.error(String.format("Error while executing comand %s", Arrays.toString(options)), t);
            return t.getMessage();
        }
        return "Invalid Command";
    }

    @Override
    public boolean handles(String command) {
        return command.startsWith("tcap");
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        int count = 4;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                TCAPStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = this.tcapStacks.get(m3uaStackName = options[count++])) == null) {
                    return String.format("No TCAP stack configured for name %s", m3uaStackName);
                }
                this.tcapStack = sccpStaclImpl;
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        String parName = options[2].toLowerCase();
        if (parName.equals("dialogidletimeout")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setDialogIdleTimeout(val);
        } else if (parName.equals("invoketimeout")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setInvokeTimeout(val);
        } else if (parName.equals("maxdialogs")) {
            int val = Integer.parseInt(options[3]);
            this.tcapStack.setMaxDialogs(val);
        } else if (parName.equals("dialogidrangestart")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setDialogIdRangeStart(val);
        } else if (parName.equals("dialogidrangeend")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setDialogIdRangeEnd(val);
        } else if (parName.equals("donotsendprotocolversion")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.tcapStack.setDoNotSendProtocolVersion(val);
        } else if (parName.equals("statisticsenabled")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.tcapStack.setStatisticsEnabled(val);
        } else {
            return "Invalid Command";
        }
        return String.format("Parameter has been successfully set for stack=%s", this.tcapStack.getName());
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length < 2) {
            return "Invalid Command";
        }
        if (options.length == 3) {
            this.setDefaultValue();
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("dialogidletimeout")) {
                sb.append(this.tcapStack.getDialogIdleTimeout());
            } else if (parName.equals("invoketimeout")) {
                sb.append(this.tcapStack.getInvokeTimeout());
            } else if (parName.equals("maxdialogs")) {
                sb.append(this.tcapStack.getMaxDialogs());
            } else if (parName.equals("dialogidrangestart")) {
                sb.append(this.tcapStack.getDialogIdRangeStart());
            } else if (parName.equals("dialogidrangeend")) {
                sb.append(this.tcapStack.getDialogIdRangeEnd());
            } else if (parName.equals("previewmode")) {
                sb.append(this.tcapStack.getPreviewMode());
            } else if (parName.equals("donotsendprotocolversion")) {
                sb.append(this.tcapStack.getDoNotSendProtocolVersion());
            } else if (parName.equals("statisticsenabled")) {
                sb.append(this.tcapStack.getStatisticsEnabled());
            } else if (parName.equals("ssn")) {
                sb.append(this.tcapStack.getSubSystemNumber());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        FastCollection.Record e = this.tcapStacks.head();
        FastMap.Entry<String, TCAPStackImpl> end = this.tcapStacks.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            TCAPStackImpl tcapStackImpl = (TCAPStackImpl)((FastMap.Entry)e).getValue();
            String tcapStackname = (String)((FastMap.Entry)e).getKey();
            sb.append("Properties for ");
            sb.append(tcapStackname);
            sb.append("\n");
            sb.append("*******************\n");
            sb.append("dialogidletimeout = ");
            sb.append(tcapStackImpl.getDialogIdleTimeout());
            sb.append("\n");
            sb.append("invoketimeout = ");
            sb.append(tcapStackImpl.getInvokeTimeout());
            sb.append("\n");
            sb.append("maxdialogs = ");
            sb.append(tcapStackImpl.getMaxDialogs());
            sb.append("\n");
            sb.append("dialogidrangestart = ");
            sb.append(tcapStackImpl.getDialogIdRangeStart());
            sb.append("\n");
            sb.append("dialogidrangeend = ");
            sb.append(tcapStackImpl.getDialogIdRangeEnd());
            sb.append("\n");
            sb.append("previewmode = ");
            sb.append(tcapStackImpl.getPreviewMode());
            sb.append("\n");
            sb.append("donotsendprotocolversion = ");
            sb.append(tcapStackImpl.getDoNotSendProtocolVersion());
            sb.append("\n");
            sb.append("statisticsenabled = ");
            sb.append(tcapStackImpl.getStatisticsEnabled());
            sb.append("\n");
            sb.append("subsystemnumber = ");
            sb.append(tcapStackImpl.getSubSystemNumber());
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }
}

