/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.statistics;

import java.util.Date;
import java.util.UUID;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterCampaign;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterDefSet;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterValueSet;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueSet;

public class CounterCampaignImpl
implements CounterCampaign {
    private static final long serialVersionUID = -185667602668518572L;
    private static final String NAME = "name";
    private static final String COUNTER_SET_NAME = "counterSetName";
    private static final String DURATION = "duration";
    private static final String SHORT_CAMPAIGN = "shortCampaign";
    private String name;
    private CounterDefSet counterSet;
    private String counterSetName;
    private int duration;
    private boolean shortCampaign;
    private Date startTime;
    private UUID lastSessionId;
    private CounterValueSet lastCounterValueSet;
    private SourceValueSet lastSourceValueSet;
    protected static final XMLFormat<CounterCampaignImpl> COUNTER_CAMPAIGN_XML = new XMLFormat<CounterCampaignImpl>(CounterCampaignImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CounterCampaignImpl counterCampaign) throws XMLStreamException {
            counterCampaign.name = xml.getAttribute(CounterCampaignImpl.NAME, "");
            counterCampaign.counterSetName = xml.getAttribute(CounterCampaignImpl.COUNTER_SET_NAME, "");
            counterCampaign.shortCampaign = xml.getAttribute(CounterCampaignImpl.SHORT_CAMPAIGN, false);
            counterCampaign.duration = xml.getAttribute(CounterCampaignImpl.DURATION, 60);
        }

        @Override
        public void write(CounterCampaignImpl counterCampaign, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(CounterCampaignImpl.NAME, counterCampaign.getName());
            xml.setAttribute(CounterCampaignImpl.COUNTER_SET_NAME, counterCampaign.getCounterSetName());
            xml.setAttribute(CounterCampaignImpl.SHORT_CAMPAIGN, counterCampaign.isShortCampaign());
            xml.setAttribute(CounterCampaignImpl.DURATION, counterCampaign.getDuration());
        }
    };

    public CounterCampaignImpl() {
    }

    public CounterCampaignImpl(String name, String counterSetName, CounterDefSet counterSet, int duration, boolean shortCampaign) {
        this.name = name;
        this.counterSetName = counterSetName;
        this.counterSet = counterSet;
        this.duration = duration;
        this.shortCampaign = shortCampaign;
    }

    public String getName() {
        return this.name;
    }

    public String getCounterSetName() {
        return this.counterSetName;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isShortCampaign() {
        return this.shortCampaign;
    }

    public CounterDefSet getCounterSet() {
        return this.counterSet;
    }

    public void setCounterSet(CounterDefSet counterSet) {
        this.counterSet = counterSet;
    }

    public CounterValueSet getLastCounterValueSet() {
        return this.lastCounterValueSet;
    }

    public void setCounterValueSet(CounterValueSet val) {
        this.lastCounterValueSet = val;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public UUID getLastSessionId() {
        return this.lastSessionId;
    }

    public void setLastSessionId(UUID lastSessionId) {
        this.lastSessionId = lastSessionId;
    }

    public SourceValueSet getLastSourceValueSet() {
        return this.lastSourceValueSet;
    }

    public void setLastSourceValueSet(SourceValueSet lastSourceValueSet) {
        this.lastSourceValueSet = lastSourceValueSet;
    }
}

