/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.alarm;

import java.util.List;
import javolution.util.FastList;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListener;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMessage;

public class AlarmListenerCollection {
    private transient List<AlarmListener> alarmListeners = new FastList<AlarmListener>();
    private String alarmProviderObjectPath;
    private String alarmProviderObjectPathWithSlash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlarmListener(AlarmListener listener) {
        AlarmListenerCollection alarmListenerCollection = this;
        synchronized (alarmListenerCollection) {
            this.alarmListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAlarmListener(AlarmListener listener) {
        AlarmListenerCollection alarmListenerCollection = this;
        synchronized (alarmListenerCollection) {
            this.alarmListeners.remove(listener);
        }
    }

    public void prepareAlarm(AlarmMessage alarm) {
        if (this.alarmProviderObjectPath != null) {
            alarm.addPrefixToAlarmSource(this.alarmProviderObjectPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAlarm(AlarmMessage alarm) {
        this.prepareAlarm(alarm);
        AlarmListenerCollection alarmListenerCollection = this;
        synchronized (alarmListenerCollection) {
            for (AlarmListener listener : this.alarmListeners) {
                listener.onAlarm(alarm);
            }
        }
    }

    public String getAlarmProviderObjectPath() {
        return this.alarmProviderObjectPath;
    }

    public void setAlarmProviderObjectPath(String value) {
        this.alarmProviderObjectPath = value;
        this.alarmProviderObjectPathWithSlash = this.alarmProviderObjectPath != null && !this.alarmProviderObjectPath.equals("") ? "/" + this.alarmProviderObjectPath : null;
    }
}

