/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.GeographicalInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.TypeOfShape;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;

public class GeographicalInformationImpl
extends OctetStringBase
implements GeographicalInformation {
    private static double koef23 = Math.pow(2.0, 23.0) / 90.0;
    private static double koef24 = Math.pow(2.0, 24.0) / 360.0;
    private static double[] uncertaintyTable = GeographicalInformationImpl.initUncertaintyTable();
    private static final String TYPE_OF_SHAPE = "typeOfShape";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private static final String UNCERTAINTY = "uncertainty";
    private static final String DEFAULT_STRING_VALUE = null;
    private static final double DEFAULT_DOUBLE_VALUE = 0.0;
    protected static final XMLFormat<GeographicalInformationImpl> GEOGRAPHICAL_INFORMATION_XML = new XMLFormat<GeographicalInformationImpl>(GeographicalInformationImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, GeographicalInformationImpl geographicalInformation) throws XMLStreamException {
            String str = xml.getAttribute(GeographicalInformationImpl.TYPE_OF_SHAPE, DEFAULT_STRING_VALUE);
            TypeOfShape tos = null;
            if (str != null) {
                tos = Enum.valueOf(TypeOfShape.class, str);
            }
            double lat = xml.getAttribute(GeographicalInformationImpl.LATITUDE, 0.0);
            double lng = xml.getAttribute(GeographicalInformationImpl.LONGITUDE, 0.0);
            double unc = xml.getAttribute(GeographicalInformationImpl.UNCERTAINTY, 0.0);
            try {
                geographicalInformation.setData(tos, lat, lng, unc);
            }
            catch (MAPException e) {
                throw new XMLStreamException("MAPException when deserializing GeographicalInformation", e);
            }
        }

        @Override
        public void write(GeographicalInformationImpl geographicalInformation, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (geographicalInformation.getTypeOfShape() != null) {
                xml.setAttribute(GeographicalInformationImpl.TYPE_OF_SHAPE, geographicalInformation.getTypeOfShape().toString());
            }
            xml.setAttribute(GeographicalInformationImpl.LATITUDE, geographicalInformation.getLatitude());
            xml.setAttribute(GeographicalInformationImpl.LONGITUDE, geographicalInformation.getLongitude());
            xml.setAttribute(GeographicalInformationImpl.UNCERTAINTY, geographicalInformation.getUncertainty());
        }
    };

    private static double[] initUncertaintyTable() {
        double[] res = new double[128];
        double c = 10.0;
        double x = 0.1;
        for (int i = 1; i < 128; ++i) {
            res[i] = c * (Math.pow(1.0 + x, i) - 1.0);
        }
        return res;
    }

    public GeographicalInformationImpl() {
        super(8, 8, "GeographicalInformation");
    }

    public GeographicalInformationImpl(byte[] data) {
        super(8, 8, "GeographicalInformation", data);
    }

    public GeographicalInformationImpl(TypeOfShape typeOfShape, double latitude, double longitude, double uncertainty) throws MAPException {
        super(8, 8, "GeographicalInformation");
        this.setData(typeOfShape, latitude, longitude, uncertainty);
    }

    public void setData(TypeOfShape typeOfShape, double latitude, double longitude, double uncertainty) throws MAPException {
        if (typeOfShape != TypeOfShape.EllipsoidPointWithUncertaintyCircle) {
            throw new MAPException("typeOfShape parameter for GeographicalInformation can be only \"ellipsoid point with uncertainty circle\"");
        }
        this.data = new byte[8];
        this.data[0] = (byte)(typeOfShape.getCode() << 4);
        GeographicalInformationImpl.encodeLatitude(this.data, 1, latitude);
        GeographicalInformationImpl.encodeLongitude(this.data, 4, longitude);
        this.data[7] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertainty);
    }

    public static double decodeLatitude(byte[] data, int begin) {
        int i1 = ((data[begin] & 0xFF) << 16) + ((data[begin + 1] & 0xFF) << 8) + (data[begin + 2] & 0xFF);
        int sign = 1;
        if ((i1 & 0x800000) != 0) {
            sign = -1;
            i1 &= 0x7FFFFF;
        }
        return (double)i1 / koef23 * (double)sign;
    }

    public static double decodeLongitude(byte[] data, int begin) {
        int i1 = ((data[begin] & 0xFF) << 16) + ((data[begin + 1] & 0xFF) << 8) + (data[begin + 2] & 0xFF);
        int sign = 1;
        if ((i1 & 0x800000) != 0) {
            sign = -1;
            i1 &= 0x7FFFFF;
        }
        return (double)i1 / koef24 * (double)sign;
    }

    public static double decodeUncertainty(int data) {
        if (data < 0 || data > 127) {
            data = 0;
        }
        double d = uncertaintyTable[data];
        return d;
    }

    public static void encodeLatitude(byte[] data, int begin, double val) {
        int res;
        boolean negativeSign = false;
        if (val < 0.0) {
            negativeSign = true;
            val = -val;
        }
        if ((res = (int)(koef23 * val)) > 0x7FFFFF) {
            res = 0x7FFFFF;
        }
        if (negativeSign) {
            res |= 0x800000;
        }
        data[begin] = (byte)((res & 0xFF0000) >> 16);
        data[begin + 1] = (byte)((res & 0xFF00) >> 8);
        data[begin + 2] = (byte)(res & 0xFF);
    }

    public static void encodeLongitude(byte[] data, int begin, double val) {
        int res;
        boolean negativeSign = false;
        if (val < 0.0) {
            negativeSign = true;
            val = -val;
        }
        if ((res = (int)(koef24 * val)) > 0x7FFFFF) {
            res = 0x7FFFFF;
        }
        if (negativeSign) {
            res |= 0x800000;
        }
        data[begin] = (byte)((res & 0xFF0000) >> 16);
        data[begin + 1] = (byte)((res & 0xFF00) >> 8);
        data[begin + 2] = (byte)(res & 0xFF);
    }

    public static int encodeUncertainty(double val) {
        for (int i = 0; i < 127; ++i) {
            if (!(val < uncertaintyTable[i + 1])) continue;
            return i;
        }
        return 127;
    }

    public byte[] getData() {
        return this.data;
    }

    public TypeOfShape getTypeOfShape() {
        if (this.data == null || this.data.length != 8) {
            return null;
        }
        return TypeOfShape.getInstance((this.data[0] & 0xFF) >> 4);
    }

    public double getLatitude() {
        if (this.data == null || this.data.length != 8) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeLatitude(this.data, 1);
    }

    public double getLongitude() {
        if (this.data == null || this.data.length != 8) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeLongitude(this.data, 4);
    }

    public double getUncertainty() {
        if (this.data == null || this.data.length != 8) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeUncertainty(this.data[7]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("TypeOfShape=");
        sb.append((Object)this.getTypeOfShape());
        sb.append(", Latitude=");
        sb.append(this.getLatitude());
        sb.append(", Longitude=");
        sb.append(this.getLongitude());
        sb.append(", Uncertainty=");
        sb.append(this.getUncertainty());
        sb.append("]");
        return sb.toString();
    }
}

