/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.PivotCapability;

public class PivotCapabilityImpl
extends AbstractISUPParameter
implements PivotCapability {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private byte[] pivotCapabilities;

    public byte[] encode() throws ParameterException {
        for (int index = 0; index < this.pivotCapabilities.length; ++index) {
            this.pivotCapabilities[index] = (byte)(this.pivotCapabilities[index] & 0x7F);
        }
        this.pivotCapabilities[this.pivotCapabilities.length - 1] = (byte)(this.pivotCapabilities[this.pivotCapabilities.length - 1] | 0x80);
        return this.pivotCapabilities;
    }

    public int decode(byte[] b) throws ParameterException {
        this.setPivotCapabilities(b);
        return b.length;
    }

    public byte[] getPivotCapabilities() {
        return this.pivotCapabilities;
    }

    public void setPivotCapabilities(byte[] pivotCapabilities) {
        if (pivotCapabilities == null || pivotCapabilities.length == 0) {
            throw new IllegalArgumentException("byte[] must not be null and length must be greater than 0");
        }
        this.pivotCapabilities = pivotCapabilities;
    }

    public byte createPivotCapabilityByte(boolean itriNotAllowed, int pivotPossibility) {
        int b = (itriNotAllowed ? 1 : 0) << 6;
        return (byte)(b |= pivotPossibility & 7);
    }

    public boolean getITRINotAllowed(byte b) {
        return (b >> 6 & 1) == 1;
    }

    public int getPivotCapability(byte b) {
        return b & 7;
    }

    public int getCode() {
        return 123;
    }
}

