/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.TimerID;
import org.mobicents.protocols.ss7.cap.api.service.sms.ResetTimerSMSRequest;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.sms.SmsMessageImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class ResetTimerSMSRequestImpl
extends SmsMessageImpl
implements ResetTimerSMSRequest {
    public static final String _PrimitiveName = "ResetTimerSMSRequest";
    public static final int _ID_timerID = 0;
    public static final int _ID_timerValue = 1;
    public static final int _ID_extensions = 2;
    private TimerID timerID;
    private int timerValue;
    private CAPExtensions extensions;

    public ResetTimerSMSRequestImpl(TimerID timerID, int timerValue, CAPExtensions extensions) {
        this.timerID = timerID;
        this.timerValue = timerValue;
        this.extensions = extensions;
    }

    public ResetTimerSMSRequestImpl() {
    }

    public TimerID getTimerID() {
        return this.timerID;
    }

    public int getTimerValue() {
        return this.timerValue;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.resetTimerSMS_Request;
    }

    public int getOperationCode() {
        return 63;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ResetTimerSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ResetTimerSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ResetTimerSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ResetTimerSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ResetTimerSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ResetTimerSMSRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.timerID = null;
        this.timerValue = -1;
        this.extensions = null;
        boolean istimerValueFound = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ResetTimerSMSRequest.timerID: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.timerID = TimerID.getInstance(i1);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ResetTimerSMSRequest.timerValue: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.timerValue = (int)ais.readInteger();
                        istimerValueFound = true;
                        break;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ResetTimerSMSRequest.extensions: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (!istimerValueFound) {
            throw new CAPParsingComponentException("Error while decoding ResetTimerSMSRequest: parameter timerValue is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ResetTimerSMSRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.timerID == null) {
            throw new CAPException("Error while encoding ResetTimerSMSRequest: timerID must not be null");
        }
        try {
            asnOs.writeInteger(2, 0, this.timerID.getCode());
            asnOs.writeInteger(2, 1, this.timerValue);
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(asnOs, 2, 2);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ResetTimerSMSRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ResetTimerSMSRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.timerID != null) {
            sb.append(", timerID=");
            sb.append(this.timerID.toString());
        }
        sb.append(", timerValue=");
        sb.append(this.timerValue);
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

