/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPDialogSupplementary;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementary;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementaryListener;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.sms.MAPServiceSmsImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ActivateSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ActivateSSResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.DeactivateSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.DeactivateSSResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.EraseSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.EraseSSResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.GetPasswordRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.GetPasswordResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.InterrogateSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.InterrogateSSResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.MAPDialogSupplementaryImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ProcessUnstructuredSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ProcessUnstructuredSSResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.RegisterPasswordRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.RegisterPasswordResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.RegisterSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.RegisterSSResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSNotifyRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSNotifyResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSResponseImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceSupplementaryImpl
extends MAPServiceBaseImpl
implements MAPServiceSupplementary {
    private static final Logger loger = Logger.getLogger(MAPServiceSmsImpl.class);

    public MAPServiceSupplementaryImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogSupplementary createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        return this.createNewDialog(appCntx, origAddress, origReference, destAddress, destReference, null);
    }

    public MAPDialogSupplementary createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference, Long localTrId) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogSupplementary because MAPServiceSupplementary is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        MAPDialogSupplementaryImpl dialog = new MAPDialogSupplementaryImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.putMAPDialogIntoCollection(dialog);
        return dialog;
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogSupplementaryImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public void addMAPServiceListener(MAPServiceSupplementaryListener mapServiceListener) {
        super.addMAPServiceListener(mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceSupplementaryListener mapServiceListener) {
        super.removeMAPServiceListener(mapServiceListener);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        MAPApplicationContextName ctx = dialogApplicationContext.getApplicationContextName();
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (ctx) {
            case networkUnstructuredSsContext: {
                if (vers == 2) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 2) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 2L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case networkFunctionalSsContext: {
                if (vers == 2) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 2) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 2L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public long[] getLinkedOperationList(long operCode) {
        if (operCode == 17L) {
            return new long[]{18L};
        }
        return null;
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws MAPParsingComponentException {
        if (compType == ComponentType.Invoke && this.mapProviderImpl.isCongested()) {
            return;
        }
        MAPDialogSupplementaryImpl mapDialogSupplementaryImpl = (MAPDialogSupplementaryImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        long ocValueInt = ocValue;
        int ocValueInt2 = (int)ocValueInt;
        MAPApplicationContextName acn = mapDialog.getApplicationContext().getApplicationContextName();
        switch (ocValueInt2) {
            case 10: {
                if (acn != MAPApplicationContextName.networkFunctionalSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.registerSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.registerSSResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 11: {
                if (acn != MAPApplicationContextName.networkFunctionalSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.eraseSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.eraseSSResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 12: {
                if (acn != MAPApplicationContextName.networkFunctionalSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.activateSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.activateSSResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 13: {
                if (acn != MAPApplicationContextName.networkFunctionalSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.deactivateSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.deactivateSSResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 14: {
                if (acn != MAPApplicationContextName.networkFunctionalSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.interrogateSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.interrogateSSResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 17: {
                if (acn != MAPApplicationContextName.networkFunctionalSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.registerPasswordRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.registerPasswordResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 18: {
                if (acn != MAPApplicationContextName.networkFunctionalSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.getPasswordRequest(parameter, mapDialogSupplementaryImpl, invokeId, linkedId, linkedInvoke);
                    break;
                }
                this.getPasswordResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 59: {
                if (acn != MAPApplicationContextName.networkUnstructuredSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processUnstructuredSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.processUnstructuredSSResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 60: {
                if (acn != MAPApplicationContextName.networkUnstructuredSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.unstructuredSSRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.unstructuredSSResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 61: {
                if (acn != MAPApplicationContextName.networkUnstructuredSsContext) break;
                if (compType == ComponentType.Invoke) {
                    this.unstructuredSSNotifyRequest(parameter, mapDialogSupplementaryImpl, invokeId);
                    break;
                }
                this.unstructuredSSNotifyResponse(parameter, mapDialogSupplementaryImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            default: {
                throw new MAPParsingComponentException("MAPServiceSupplementary: unknown incoming operation code: " + ocValueInt2, MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void registerSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding registerSSRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding registerSSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        RegisterSSRequestImpl ind = new RegisterSSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onRegisterSSRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing registerSSRequest: " + e.getMessage(), e);
            }
        }
    }

    private void registerSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        RegisterSSResponseImpl ind = new RegisterSSResponseImpl();
        if (parameter != null) {
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onRegisterSSResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onRegisterSSResponse: " + e.getMessage(), e);
            }
        }
    }

    private void eraseSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding eraseSSRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding eraseSSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        EraseSSRequestImpl ind = new EraseSSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onEraseSSRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onEraseSSRequest: " + e.getMessage(), e);
            }
        }
    }

    private void eraseSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        EraseSSResponseImpl ind = new EraseSSResponseImpl();
        if (parameter != null) {
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onEraseSSResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onEraseSSResponse: " + e.getMessage(), e);
            }
        }
    }

    private void activateSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding activateSSRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding activateSSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        ActivateSSRequestImpl ind = new ActivateSSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onActivateSSRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onActivateSSRequest: " + e.getMessage(), e);
            }
        }
    }

    private void activateSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        ActivateSSResponseImpl ind = new ActivateSSResponseImpl();
        if (parameter != null) {
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onActivateSSResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onActivateSSResponse: " + e.getMessage(), e);
            }
        }
    }

    private void deactivateSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding deactivateSSRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding deactivateSSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        DeactivateSSRequestImpl ind = new DeactivateSSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onDeactivateSSRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onDeactivateSSRequest: " + e.getMessage(), e);
            }
        }
    }

    private void deactivateSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        DeactivateSSResponseImpl ind = new DeactivateSSResponseImpl();
        if (parameter != null) {
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onDeactivateSSResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onDeactivateSSResponse: " + e.getMessage(), e);
            }
        }
    }

    private void interrogateSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding interrogateSSRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding interrogateSSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        InterrogateSSRequestImpl ind = new InterrogateSSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onInterrogateSSRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onInterrogateSSRequest: " + e.getMessage(), e);
            }
        }
    }

    private void interrogateSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        InterrogateSSResponseImpl ind = new InterrogateSSResponseImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding interrogateSSResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onInterrogateSSResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onInterrogateSSResponse: " + e.getMessage(), e);
            }
        }
    }

    private void getPasswordRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, Long linkedId, Invoke linkedInvoke) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding getPasswordRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 10 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding getPasswordRequest: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        GetPasswordRequestImpl ind = new GetPasswordRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setLinkedId(linkedId);
        ind.setLinkedInvoke(linkedInvoke);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onGetPasswordRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onGetPasswordRequest: " + e.getMessage(), e);
            }
        }
    }

    private void getPasswordResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        GetPasswordResponseImpl ind = new GetPasswordResponseImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding getPasswordResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 18 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding getPasswordResponse: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onGetPasswordResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onGetPasswordResponse: " + e.getMessage(), e);
            }
        }
    }

    private void registerPasswordRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding registerPasswordRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding registerPasswordRequest: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        RegisterPasswordRequestImpl ind = new RegisterPasswordRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onRegisterPasswordRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onRegisterPasswordRequest: " + e.getMessage(), e);
            }
        }
    }

    private void registerPasswordResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        RegisterPasswordResponseImpl ind = new RegisterPasswordResponseImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding registerPasswordResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 18 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding registerPasswordResponse: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onRegisterPasswordResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing onRegisterPasswordResponse: " + e.getMessage(), e);
            }
        }
    }

    private void unstructuredSSNotifyRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding unstructuredSSNotifyIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding unstructuredSSNotifyIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        UnstructuredSSNotifyRequestImpl ind = new UnstructuredSSNotifyRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSNotifyRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing unstructuredSSNotifyIndication: " + e.getMessage(), e);
            }
        }
    }

    private void unstructuredSSNotifyResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        UnstructuredSSNotifyResponseImpl ind = new UnstructuredSSNotifyResponseImpl();
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSNotifyResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing unstructuredSSNotifyIndication: " + e.getMessage(), e);
            }
        }
    }

    private void unstructuredSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding UnstructuredSSRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        UnstructuredSSRequestImpl ind = new UnstructuredSSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing UnstructuredSSRequestIndication: " + e.getMessage(), e);
            }
        }
    }

    private void unstructuredSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        UnstructuredSSResponseImpl ind = new UnstructuredSSResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding UnstructuredSSResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onUnstructuredSSResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing UnstructuredSSResponseIndication: " + e.getMessage(), e);
            }
        }
    }

    private void processUnstructuredSSRequest(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        ProcessUnstructuredSSRequestImpl ind = new ProcessUnstructuredSSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onProcessUnstructuredSSRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing ProcessUnstructuredSSRequestIndication: " + e.getMessage(), e);
            }
        }
    }

    private void processUnstructuredSSResponse(Parameter parameter, MAPDialogSupplementaryImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProcessUnstructuredSSResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        ProcessUnstructuredSSResponseImpl ind = new ProcessUnstructuredSSResponseImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceSupplementaryListener)serLis).onProcessUnstructuredSSResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing ProcessUnstructuredSSResponseIndication: " + e.getMessage(), e);
            }
        }
    }
}

