/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancellationType;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.IMSIWithLMSI;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.TypeOfUpdate;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.IMSIWithLMSIImpl;

public class CancelLocationRequestImpl
extends MobilityMessageImpl
implements CancelLocationRequest {
    private static final int TAG_typeOfUpdate = 0;
    private static final int TAG_mtrfSupportedAndAuthorized = 1;
    private static final int TAG_mtrfSupportedAndNotAuthorized = 2;
    private static final int TAG_newMSCNumber = 3;
    private static final int TAG_newVLRNumber = 4;
    private static final int TAG_newLmsi = 5;
    public static final int TAG_cancelLocationRequest = 3;
    public static final String _PrimitiveName = "CancelLocationRequest";
    private IMSI imsi;
    private IMSIWithLMSI imsiWithLmsi;
    private CancellationType cancellationType;
    private MAPExtensionContainer extensionContainer;
    private TypeOfUpdate typeOfUpdate;
    private boolean mtrfSupportedAndAuthorized;
    private boolean mtrfSupportedAndNotAuthorized;
    private ISDNAddressString newMSCNumber;
    private ISDNAddressString newVLRNumber;
    private LMSI newLmsi;
    private long mapProtocolVersion;

    public CancelLocationRequestImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public CancelLocationRequestImpl(IMSI imsi, IMSIWithLMSI imsiWithLmsi, CancellationType cancellationType, MAPExtensionContainer extensionContainer, TypeOfUpdate typeOfUpdate, boolean mtrfSupportedAndAuthorized, boolean mtrfSupportedAndNotAuthorized, ISDNAddressString newMSCNumber, ISDNAddressString newVLRNumber, LMSI newLmsi, long mapProtocolVersion) {
        this.imsi = imsi;
        this.imsiWithLmsi = imsiWithLmsi;
        this.cancellationType = cancellationType;
        this.extensionContainer = extensionContainer;
        this.typeOfUpdate = typeOfUpdate;
        this.mtrfSupportedAndAuthorized = mtrfSupportedAndAuthorized;
        this.mtrfSupportedAndNotAuthorized = mtrfSupportedAndNotAuthorized;
        this.newMSCNumber = newMSCNumber;
        this.newVLRNumber = newVLRNumber;
        this.newLmsi = newLmsi;
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.cancelLocation_Request;
    }

    public int getOperationCode() {
        return 3;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public IMSIWithLMSI getImsiWithLmsi() {
        return this.imsiWithLmsi;
    }

    public CancellationType getCancellationType() {
        return this.cancellationType;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public TypeOfUpdate getTypeOfUpdate() {
        return this.typeOfUpdate;
    }

    public boolean getMtrfSupportedAndAuthorized() {
        return this.mtrfSupportedAndAuthorized;
    }

    public boolean getMtrfSupportedAndNotAuthorized() {
        return this.mtrfSupportedAndNotAuthorized;
    }

    public ISDNAddressString getNewMSCNumber() {
        return this.newMSCNumber;
    }

    public ISDNAddressString getNewVLRNumber() {
        return this.newVLRNumber;
    }

    public LMSI getNewLmsi() {
        return this.newLmsi;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion == 3L) {
            return 3;
        }
        if (this.imsi != null) {
            return 4;
        }
        return 16;
    }

    public int getTagClass() {
        if (this.mapProtocolVersion == 3L) {
            return 2;
        }
        return 0;
    }

    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L && this.imsi != null;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CancelLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CancelLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CancelLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CancelLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.imsiWithLmsi = null;
        this.cancellationType = null;
        this.extensionContainer = null;
        this.typeOfUpdate = null;
        this.mtrfSupportedAndAuthorized = false;
        this.mtrfSupportedAndNotAuthorized = false;
        this.newMSCNumber = null;
        this.newVLRNumber = null;
        this.newLmsi = null;
        if (this.mapProtocolVersion >= 3L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            int num = 0;
            while (ais.available() != 0) {
                int tag = ais.readTag();
                if (num == 0) {
                    if (tag == 4 && ais.getTagClass() == 0) {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.imsi: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsi = new IMSIImpl();
                        ((IMSIImpl)this.imsi).decodeAll(ais);
                    } else {
                        if (tag != 16 || ais.getTagClass() != 0 || ais.isTagPrimitive()) throw new MAPParsingComponentException("Error while decoding CancelLocationRequest: Bad tag or tag class for the parameter Identity", MAPParsingComponentExceptionReason.MistypedParameter);
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.imsiWithLmsi: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsiWithLmsi = new IMSIWithLMSIImpl();
                        ((IMSIWithLMSIImpl)this.imsiWithLmsi).decodeAll(ais);
                    }
                } else {
                    block0 : switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 10: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.cancellationType: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.cancellationType = CancellationType.getInstance((int)ais.readInteger());
                                    break block0;
                                }
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.typeOfUpdate: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.typeOfUpdate = TypeOfUpdate.getInstance((int)ais.readInteger());
                                    break block0;
                                }
                                case 1: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.mtrfSupportedAndAuthorized: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.mtrfSupportedAndAuthorized = true;
                                    break block0;
                                }
                                case 2: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.mtrfSupportedAndNotAuthorized: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.mtrfSupportedAndNotAuthorized = true;
                                    break block0;
                                }
                                case 3: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.newMSCNumber: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.newMSCNumber = new ISDNAddressStringImpl();
                                    ((ISDNAddressStringImpl)this.newMSCNumber).decodeAll(ais);
                                    break block0;
                                }
                                case 4: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.newVLRNumber: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.newVLRNumber = new ISDNAddressStringImpl();
                                    ((ISDNAddressStringImpl)this.newVLRNumber).decodeAll(ais);
                                    break block0;
                                }
                                case 5: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.newLmsi: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.newLmsi = new LMSIImpl();
                                    ((LMSIImpl)this.newLmsi).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
                ++num;
            }
            if (num >= true) return;
            throw new MAPParsingComponentException("Error while decoding CancelLocationRequest: Needs at least 1 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int tag = ansIS.getTag();
        if (tag == 4 && ansIS.getTagClass() == 0) {
            if (!ansIS.isTagPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.imsi: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            this.imsi = new IMSIImpl();
            ((IMSIImpl)this.imsi).decodeData(ansIS, length);
            return;
        } else {
            if (tag != 16 || ansIS.getTagClass() != 0) return;
            if (ansIS.isTagPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding CancelLocationRequest.imsiWithLmsi: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            this.imsiWithLmsi = new IMSIWithLMSIImpl();
            ((IMSIWithLMSIImpl)this.imsiWithLmsi).decodeData(ansIS, length);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        try {
            this.encodeAll(asnOs, this.getTagClass(), this.getTag());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPException(e);
        }
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            e.printStackTrace();
            throw new MAPException("AsnException when encoding CancelLocationRequest: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MAPException("AsnException when encoding CancelLocationRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imsi == null && this.imsiWithLmsi == null) {
            throw new MAPException("Error while encoding CancelLocationRequest the mandatory parameter imsi / imsiWithLmsi is not defined");
        }
        if (this.mapProtocolVersion >= 3L) {
            if (this.imsi != null) {
                ((IMSIImpl)this.imsi).encodeAll(asnOs);
            } else {
                ((IMSIWithLMSIImpl)this.imsiWithLmsi).encodeAll(asnOs);
            }
            if (this.cancellationType != null) {
                try {
                    asnOs.writeInteger(0, 10, this.cancellationType.getCode());
                }
                catch (IOException e) {
                    throw new MAPException("IOException while encoding CancelLocationRequest parameter cancellationType", e);
                }
                catch (AsnException e) {
                    throw new MAPException("IOException while encoding CancelLocationRequest parameter cancellationType", e);
                }
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.typeOfUpdate != null) {
                try {
                    asnOs.writeInteger(2, 0, this.typeOfUpdate.getCode());
                }
                catch (IOException e) {
                    throw new MAPException("IOException while encoding CancelLocationRequest parameter typeOfUpdate", e);
                }
                catch (AsnException e) {
                    throw new MAPException("IOException while encoding CancelLocationRequest parameter typeOfUpdate", e);
                }
            }
            if (this.mtrfSupportedAndAuthorized) {
                try {
                    asnOs.writeNull(2, 1);
                }
                catch (IOException e) {
                    throw new MAPException("IOException while encoding CancelLocationRequest parameter mtrfSupportedAndAuthorized", e);
                }
                catch (AsnException e) {
                    throw new MAPException("AsnException while encoding CancelLocationRequest parameter mtrfSupportedAndAuthorized", e);
                }
            }
            if (this.mtrfSupportedAndNotAuthorized) {
                try {
                    asnOs.writeNull(2, 2);
                }
                catch (IOException e) {
                    throw new MAPException("IOException while encoding CancelLocationRequest parameter mtrfSupportedAndNotAuthorized", e);
                }
                catch (AsnException e) {
                    throw new MAPException("AsnException while encoding CancelLocationRequest parameter mtrfSupportedAndNotAuthorized", e);
                }
            }
            if (this.newMSCNumber != null) {
                ((ISDNAddressStringImpl)this.newMSCNumber).encodeAll(asnOs, 2, 3);
            }
            if (this.newVLRNumber != null) {
                ((ISDNAddressStringImpl)this.newVLRNumber).encodeAll(asnOs, 2, 4);
            }
            if (this.newLmsi != null) {
                ((LMSIImpl)this.newLmsi).encodeAll(asnOs, 2, 5);
            }
        } else if (this.imsi != null) {
            ((IMSIImpl)this.imsi).encodeData(asnOs);
        } else {
            ((IMSIWithLMSIImpl)this.imsiWithLmsi).encodeData(asnOs);
        }
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.imsiWithLmsi != null) {
            sb.append("imsiWithLmsi=");
            sb.append(this.imsiWithLmsi.toString());
            sb.append(", ");
        }
        if (this.cancellationType != null) {
            sb.append("cancellationType=");
            sb.append(this.cancellationType.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.typeOfUpdate != null) {
            sb.append("typeOfUpdate=");
            sb.append(this.typeOfUpdate.toString());
            sb.append(", ");
        }
        if (this.mtrfSupportedAndAuthorized) {
            sb.append("mtrfSupportedAndAuthorized, ");
        }
        if (this.mtrfSupportedAndNotAuthorized) {
            sb.append("mtrfSupportedAndNotAuthorized, ");
        }
        if (this.newMSCNumber != null) {
            sb.append("newMSCNumber=");
            sb.append(this.newMSCNumber.toString());
            sb.append(", ");
        }
        if (this.newVLRNumber != null) {
            sb.append("newVLRNumber=");
            sb.append(this.newVLRNumber.toString());
            sb.append(", ");
        }
        if (this.newLmsi != null) {
            sb.append("newLmsi=");
            sb.append(this.newLmsi.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

