/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPPrivateExtension;
import org.mobicents.protocols.ss7.map.api.service.lsm.SLRArgExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.SLRArgPCSExtensions;
import org.mobicents.protocols.ss7.map.primitives.MAPPrivateExtensionImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.lsm.SLRArgPCSExtensionsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLRArgExtensionContainerImpl
extends SequenceBase
implements SLRArgExtensionContainer {
    private static final int _TAG_privateExtensionList = 0;
    private static final int _TAG_slr_Arg_PCS_Extensions = 1;
    private ArrayList<MAPPrivateExtension> privateExtensionList;
    private SLRArgPCSExtensions slrArgPcsExtensions;

    public SLRArgExtensionContainerImpl() {
        super("SLRArgExtensionContainer");
    }

    public SLRArgExtensionContainerImpl(ArrayList<MAPPrivateExtension> privateExtensionList, SLRArgPCSExtensions slrArgPcsExtensions) {
        super("SLRArgExtensionContainer");
        this.privateExtensionList = privateExtensionList;
        this.slrArgPcsExtensions = slrArgPcsExtensions;
    }

    @Override
    public ArrayList<MAPPrivateExtension> getPrivateExtensionList() {
        return this.privateExtensionList;
    }

    @Override
    public SLRArgPCSExtensions getSlrArgPcsExtensions() {
        return this.slrArgPcsExtensions;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.privateExtensionList = null;
        this.slrArgPcsExtensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while " + this._PrimitiveName + " decoding: privateExtensionList is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        if (this.privateExtensionList != null) {
                            throw new MAPParsingComponentException("Error while " + this._PrimitiveName + " decoding: More than one PrivateExtensionList has found", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream localAis2 = ais.readSequenceStream();
                        this.privateExtensionList = new ArrayList();
                        while (localAis2.available() > 0) {
                            tag = localAis2.readTag();
                            if (tag != 16 || localAis2.getTagClass() != 0 || localAis2.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while " + this._PrimitiveName + " decoding: Bad tag, tagClass or primitiveFactor of PrivateExtension", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            if (this.privateExtensionList.size() >= 10) {
                                throw new MAPParsingComponentException("More then 10 " + this._PrimitiveName + " found when PrivateExtensionList decoding", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            MAPPrivateExtensionImpl privateExtension = new MAPPrivateExtensionImpl();
                            privateExtension.decodeAll(localAis2);
                            this.privateExtensionList.add(privateExtension);
                        }
                        continue block4;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while " + this._PrimitiveName + " decoding: slrArgPcsExtensions is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        if (this.slrArgPcsExtensions != null) {
                            throw new MAPParsingComponentException("Error while " + this._PrimitiveName + " decoding: More than one slrArgPcsExtensions has found", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.slrArgPcsExtensions = new SLRArgPCSExtensionsImpl();
                        ((SLRArgPCSExtensionsImpl)this.slrArgPcsExtensions).decodeAll(ais);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.privateExtensionList == null && this.slrArgPcsExtensions == null) {
            throw new MAPException("Error when encoding " + this._PrimitiveName + ": Both PrivateExtensionList and slrArgPcsExtensions are empty when ExtensionContainer encoding");
        }
        if (this.privateExtensionList != null && (this.privateExtensionList.size() == 0 || this.privateExtensionList.size() > 10)) {
            throw new MAPException("Error when encoding " + this._PrimitiveName + ": PrivateExtensionList must contains from 1 to 10 elements when ExtensionContainer encoding");
        }
        try {
            if (this.privateExtensionList != null) {
                asnOs.writeTag(2, false, 0);
                int pos2 = asnOs.StartContentDefiniteLength();
                for (MAPPrivateExtension pe : this.privateExtensionList) {
                    ((MAPPrivateExtensionImpl)pe).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos2);
            }
            if (this.slrArgPcsExtensions != null) {
                ((SLRArgPCSExtensionsImpl)this.slrArgPcsExtensions).encodeAll(asnOs, 2, 1);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.privateExtensionList != null && this.privateExtensionList.size() > 0) {
            sb.append("privateExtensionList [");
            for (MAPPrivateExtension pe : this.privateExtensionList) {
                sb.append(pe.toString());
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.slrArgPcsExtensions != null) {
            sb.append(", slrArgPcsExtensions=");
            sb.append(this.slrArgPcsExtensions);
        }
        sb.append("]");
        return sb.toString();
    }
}

