/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.datacoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.BitSet;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncodingData;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;

public class GSMCharsetEncoder
extends CharsetEncoder {
    private int bitpos = 0;
    private int carryOver;
    private GSMCharset cs;
    private GSMCharsetEncodingData encodingData;
    byte[] mask = new byte[]{1, 2, 4, 8, 16, 32, 64};
    BitSet bitSet = new BitSet();
    static final byte ESCAPE = 27;
    byte rawData = 0;

    protected GSMCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
        super(cs, averageBytesPerChar, maxBytesPerChar);
        this.implReset();
        this.cs = (GSMCharset)cs;
    }

    public void setGSMCharsetEncodingData(GSMCharsetEncodingData encodingData) {
        this.encodingData = encodingData;
    }

    public GSMCharsetEncodingData getGSMCharsetEncodingData() {
        return this.encodingData;
    }

    protected void implReset() {
        this.bitpos = 0;
        this.carryOver = 0;
        this.bitSet.clear();
        if (this.encodingData != null) {
            this.encodingData.totalSeptetCount = 0;
            this.encodingData.leadingBufferIsEncoded = false;
        }
    }

    protected CoderResult implFlush(ByteBuffer out) {
        if (!out.hasRemaining()) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        if (this.encodingData != null && this.encodingData.leadingBuffer != null && !this.encodingData.leadingBufferIsEncoded) {
            if (out.limit() - out.position() >= this.encodingData.leadingBuffer.length) {
                if (this.encodingData.encodingStyle != Gsm7EncodingStyle.bit8_smpp_style) {
                    int septetCount = (this.encodingData.leadingBuffer.length * 8 + 6) / 7;
                    this.bitpos = septetCount % 8;
                    this.encodingData.totalSeptetCount = septetCount;
                }
                for (int ind = 0; ind < this.encodingData.leadingBuffer.length; ++ind) {
                    out.put(this.encodingData.leadingBuffer[ind]);
                }
                this.encodingData.leadingBufferIsEncoded = true;
            } else {
                return CoderResult.OVERFLOW;
            }
        }
        int lastChar = 32;
        while (in.hasRemaining()) {
            int i;
            if (out.limit() - out.position() < 3) {
                return CoderResult.OVERFLOW;
            }
            char c = in.get();
            lastChar = c;
            boolean found = false;
            for (i = 0; i < this.cs.mainTable.length; ++i) {
                if (this.cs.mainTable[i] != c) continue;
                found = true;
                this.putByte(i, out);
                break;
            }
            if (!found && this.cs.extensionTable != null) {
                for (i = 0; i < this.cs.mainTable.length; ++i) {
                    if (c == '\u0000' || this.cs.extensionTable[i] != c) continue;
                    found = true;
                    this.putByte(27, out);
                    this.putByte(i, out);
                    break;
                }
            }
            if (found) continue;
            this.putByte(32, out);
        }
        if (out.limit() - out.position() < 1) {
            return CoderResult.OVERFLOW;
        }
        if (this.encodingData == null || this.encodingData.encodingStyle != Gsm7EncodingStyle.bit8_smpp_style) {
            if (this.bitpos != 0) {
                if (this.encodingData != null && this.encodingData.encodingStyle == Gsm7EncodingStyle.bit7_ussd_style && this.bitpos == 7) {
                    this.carryOver |= 0x1A;
                }
                out.put((byte)this.carryOver);
            } else if (this.encodingData != null && this.encodingData.encodingStyle == Gsm7EncodingStyle.bit7_ussd_style && lastChar == 13) {
                out.put((byte)13);
            }
        }
        return CoderResult.UNDERFLOW;
    }

    private void putByte(int data, ByteBuffer out) {
        if (this.encodingData != null && this.encodingData.encodingStyle == Gsm7EncodingStyle.bit8_smpp_style) {
            out.put((byte)data);
        } else {
            if (this.bitpos == 0) {
                this.carryOver = data;
            } else {
                int i1 = data << 8 - this.bitpos;
                out.put((byte)(i1 | this.carryOver));
                this.carryOver = data >>> this.bitpos;
            }
            ++this.bitpos;
            if (this.bitpos == 8) {
                this.bitpos = 0;
            }
            if (this.encodingData != null) {
                ++this.encodingData.totalSeptetCount;
            }
        }
    }
}

