/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dahdi;

import java.io.IOException;
import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.Mtp1;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.Stream;
import org.mobicents.protocols.stream.api.StreamSelector;
import org.mobicents.ss7.hardware.dahdi.Channel;
import org.mobicents.ss7.hardware.dahdi.SelectorKeyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector
implements StreamSelector {
    private static final String LIB_NAME = "mobicents-dahdi-linux";
    public static final int READ = 1;
    public static final int WRITE = 2;
    private int[] fds = new int[16];
    private FastList<Mtp1> registered = new FastList();
    private int ops;
    private FastList<SelectorKey> selected = new FastList();
    private static Logger logger = Logger.getLogger(Selector.class);

    public SelectorKey register(Channel channel) {
        this.registered.add(channel);
        logger.info("Registering file descriptor:" + channel.fd);
        this.doRegister(channel.fd);
        SelectorKeyImpl key = new SelectorKeyImpl(channel, this);
        channel.selectorKey = key;
        return key;
    }

    public void unregister(Channel channel) {
        this.registered.remove(channel);
        channel.selectorKey = null;
        this.doUnregister(channel.fd);
    }

    public native void doRegister(int var1);

    public native void doUnregister(int var1);

    public native int doPoll(int[] var1, int var2, int var3);

    @Override
    public FastList<SelectorKey> selectNow(int ops, int timeout) throws IOException {
        int count = this.doPoll(this.fds, ops, 1);
        this.selected.clear();
        for (int i = 0; i < count; ++i) {
            FastCollection.Record n = this.registered.head();
            FastCollection.Record end = this.registered.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                Channel channel = (Channel)((FastList.Node)n).getValue();
                if (channel.fd != this.fds[i]) continue;
                this.selected.add(channel.selectorKey);
            }
        }
        return this.selected;
    }

    public void setOperation(int v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getOperations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isReadOperation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isWriteOperation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FastList<Stream> getRegisteredStreams() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            System.loadLibrary(LIB_NAME);
            System.out.println("Loaded library mobicents-dahdi-linux");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

