/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.RequestedInfo;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SubscriberIdentityImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.RequestedInfoImpl;

public class AnyTimeInterrogationRequestImpl
extends MobilityMessageImpl
implements AnyTimeInterrogationRequest,
MAPAsnPrimitive {
    private static final int _TAG_SUBSCRIBER_IDENTITY = 0;
    private static final int _TAG_REQUESTED_INFO = 1;
    private static final int _TAG_EXTENSION_CONTAINER = 2;
    private static final int _TAG_GSM_SCF_ADDRESS = 3;
    public static final String _PrimitiveName = "AnyTimeInterrogationRequest";
    private SubscriberIdentity subscriberIdentity;
    private RequestedInfo requestedInfo;
    private ISDNAddressString gsmSCFAddress;
    private MAPExtensionContainer extensionContainer;

    public AnyTimeInterrogationRequestImpl() {
    }

    public AnyTimeInterrogationRequestImpl(SubscriberIdentity subscriberIdentity, RequestedInfo requestedInfo, ISDNAddressString gsmSCFAddress, MAPExtensionContainer extensionContainer) {
        this.subscriberIdentity = subscriberIdentity;
        this.requestedInfo = requestedInfo;
        this.gsmSCFAddress = gsmSCFAddress;
        this.extensionContainer = extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AnyTimeInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AnyTimeInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AnyTimeInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AnyTimeInterrogationRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        this.subscriberIdentity = null;
        this.requestedInfo = null;
        this.gsmSCFAddress = null;
        this.extensionContainer = null;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationRequest: Parameter subscriberIdentity is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.subscriberIdentity = new SubscriberIdentityImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((SubscriberIdentityImpl)this.subscriberIdentity).decodeAll(ais2);
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationRequest: Parameter requestedInfo is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.requestedInfo = new RequestedInfoImpl();
                        ((RequestedInfoImpl)this.requestedInfo).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationRequest: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationRequest: Parameter gsmSCFAddress is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.gsmSCFAddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.gsmSCFAddress).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.subscriberIdentity == null || this.requestedInfo == null || this.gsmSCFAddress == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationRequest: subscriberIdentity, requestedInfo and gsmSCFAddress parameters are mandatory but some of them are not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AnyTimeInterrogationRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.subscriberIdentity == null) {
            throw new MAPException("Error while encoding AnyTimeInterrogationRequest the mandatory parameter subscriberIdentity is not defined");
        }
        if (this.requestedInfo == null) {
            throw new MAPException("Error while encoding AnyTimeInterrogationRequest the mandatory parameter requestedInfo is not defined");
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPException("Error while encoding AnyTimeInterrogationRequest the mandatory parameter gsmSCF-Address is not defined");
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            ((SubscriberIdentityImpl)this.subscriberIdentity).encodeAll(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException while encoding AnyTimeInterrogationRequest parameter subscriberIdentity [0] SubscriberIdentity");
        }
        ((RequestedInfoImpl)this.requestedInfo).encodeAll(asnOs, 2, 1);
        ((ISDNAddressStringImpl)this.gsmSCFAddress).encodeAll(asnOs, 2, 3);
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
    }

    public SubscriberIdentity getSubscriberIdentity() {
        return this.subscriberIdentity;
    }

    public RequestedInfo getRequestedInfo() {
        return this.requestedInfo;
    }

    public ISDNAddressString getGsmSCFAddress() {
        return this.gsmSCFAddress;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.anyTimeInterrogation_Request;
    }

    public int getOperationCode() {
        return 71;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.subscriberIdentity != null) {
            sb.append("subscriberIdentity=");
            sb.append(this.subscriberIdentity);
        }
        if (this.requestedInfo != null) {
            sb.append(", requestedInfo=");
            sb.append(this.requestedInfo);
        }
        if (this.gsmSCFAddress != null) {
            sb.append(", gsmSCFAddress=");
            sb.append(this.gsmSCFAddress);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        sb.append("]");
        return sb.toString();
    }
}

