/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.imei;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.EquipmentStatus;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.UESBIIu;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.imei.UESBIIuImpl;

public class CheckImeiResponseImpl
extends MobilityMessageImpl
implements CheckImeiResponse {
    public static final int _ID_extensionContainer = 0;
    public static final String _PrimitiveName = "CheckImeiResponse";
    private EquipmentStatus equipmentStatus;
    private UESBIIu bmuef;
    private MAPExtensionContainer extensionContainer;
    private long mapProtocolVersion;

    public CheckImeiResponseImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public CheckImeiResponseImpl(long mapProtocolVersion, EquipmentStatus equipmentStatus, UESBIIu bmuef, MAPExtensionContainer extensionContainer) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.equipmentStatus = equipmentStatus;
        this.bmuef = bmuef;
        this.extensionContainer = extensionContainer;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 16;
        }
        return 10;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CheckImeiResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CheckImeiResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CheckImeiResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CheckImeiResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.equipmentStatus = null;
        this.bmuef = null;
        this.extensionContainer = null;
        if (this.mapProtocolVersion >= 3L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            int num = 0;
            while (ais.available() != 0) {
                int tag = ais.readTag();
                if (ais.getTagClass() == 0) {
                    switch (tag) {
                        case 10: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding CheckImeiResponse.requestedEquipmentInfo: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int i1 = (int)ais.readInteger();
                            this.equipmentStatus = EquipmentStatus.getInstance(i1);
                            break;
                        }
                        case 16: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding CheckImeiResponse.bmuef: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.bmuef = new UESBIIuImpl();
                            ((UESBIIuImpl)this.bmuef).decodeAll(ais);
                            break;
                        }
                        default: {
                            ais.advanceElement();
                            break;
                        }
                    }
                } else if (ais.getTagClass() == 2) {
                    switch (tag) {
                        case 0: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding CheckImeiResponse.extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            break;
                        }
                        default: {
                            ais.advanceElement();
                            break;
                        }
                    }
                } else {
                    ais.advanceElement();
                }
                ++num;
            }
        } else {
            int i1 = (int)ansIS.readIntegerData(length);
            this.equipmentStatus = EquipmentStatus.getInstance(i1);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding CheckImeiResponse: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.mapProtocolVersion >= 3L) {
                if (this.equipmentStatus != null) {
                    asnOs.writeInteger(0, 10, this.equipmentStatus.getCode());
                }
                if (this.bmuef != null) {
                    ((UESBIIuImpl)this.bmuef).encodeAll(asnOs);
                }
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 0);
                }
            } else {
                if (this.equipmentStatus == null) {
                    throw new MAPException("equipmentStatus parameter must not be null at version 2");
                }
                asnOs.writeIntegerData(this.equipmentStatus.getCode());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding CheckImeiResponse: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding CheckImeiResponse: " + e.getMessage(), e);
        }
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.checkIMEI_Response;
    }

    public int getOperationCode() {
        return 43;
    }

    public EquipmentStatus getEquipmentStatus() {
        return this.equipmentStatus;
    }

    public UESBIIu getBmuef() {
        return this.bmuef;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.equipmentStatus != null) {
            sb.append("equipmentStatus=");
            sb.append(this.equipmentStatus.toString());
            sb.append(", ");
        }
        if (this.bmuef != null) {
            sb.append("bmuef=");
            sb.append(this.bmuef.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

