/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.RequestReportGPRSEventRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSEvent;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.PDPID;
import org.mobicents.protocols.ss7.cap.service.gprs.GprsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.GPRSEventImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.PDPIDImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestReportGPRSEventRequestImpl
extends GprsMessageImpl
implements RequestReportGPRSEventRequest {
    public static final String _PrimitiveName = "RequestReportGPRSEventRequest";
    public static final int _ID_gprsEvent = 0;
    public static final int _ID_pdpID = 1;
    private ArrayList<GPRSEvent> gprsEvent;
    private PDPID pdpID;

    public RequestReportGPRSEventRequestImpl() {
    }

    public RequestReportGPRSEventRequestImpl(ArrayList<GPRSEvent> gprsEvent, PDPID pdpID) {
        this.gprsEvent = gprsEvent;
        this.pdpID = pdpID;
    }

    @Override
    public ArrayList<GPRSEvent> getGPRSEvent() {
        return this.gprsEvent;
    }

    @Override
    public PDPID getPDPID() {
        return this.pdpID;
    }

    @Override
    public CAPMessageType getMessageType() {
        return CAPMessageType.requestReportGPRSEvent_Request;
    }

    @Override
    public int getOperationCode() {
        return 81;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding RequestReportGPRSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding RequestReportGPRSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding RequestReportGPRSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding RequestReportGPRSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding RequestReportGPRSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding RequestReportGPRSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.gprsEvent = null;
        this.pdpID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding RequestReportGPRSEventRequest.gprsEvent: Parameter gprsEvent is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        GPRSEventImpl event = null;
                        AsnInputStream ais2 = ais.readSequenceStream();
                        this.gprsEvent = new ArrayList();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                throw new CAPParsingComponentException("Error while decoding RequestReportGPRSEventRequestgprsEvent: bad tag or tagClass or is primitive ", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            event = new GPRSEventImpl();
                            event.decodeAll(ais2);
                            this.gprsEvent.add(event);
                        }
                        if (this.gprsEvent.size() >= 1 && this.gprsEvent.size() <= 10) continue block4;
                        throw new CAPParsingComponentException("Error while decoding RequestReportGPRSEventRequest: Parameter gprsEvent size must be from 1 to 10, found: " + this.gprsEvent.size(), CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding RequestReportGPRSEventRequest.pdpID: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpID = new PDPIDImpl();
                        ((PDPIDImpl)this.pdpID).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.gprsEvent == null) {
            throw new CAPParsingComponentException("Error while decoding RequestReportGPRSEventRequest: parameter gprsEvent is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding RequestReportGPRSEventRequest: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.gprsEvent == null) {
            throw new CAPException("Error while encoding RequestReportGPRSEventRequest: gprsEvent must not be null");
        }
        if (this.gprsEvent.size() < 1 || this.gprsEvent.size() > 10) {
            throw new CAPException("Error while encoding RequestReportGPRSEventRequest: Parameter gprsEvent size must be from 1 to 10, found: " + this.gprsEvent.size());
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            for (GPRSEvent event : this.gprsEvent) {
                ((GPRSEventImpl)event).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            if (this.pdpID != null) {
                ((PDPIDImpl)this.pdpID).encodeAll(asnOs, 2, 1);
            }
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding RequestReportGPRSEventRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestReportGPRSEventRequest [");
        this.addInvokeIdInfo(sb);
        if (this.gprsEvent != null) {
            sb.append(", gprsEvent=[");
            boolean firstItem = true;
            for (GPRSEvent be : this.gprsEvent) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("]");
        }
        if (this.pdpID != null) {
            sb.append(", pdpID=");
            sb.append(this.pdpID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

