/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.isup;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.LocationNumberCap;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.LocationNumberImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.LocationNumber;

public class LocationNumberCapImpl
implements LocationNumberCap,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "LocationNumberCap";
    private static final String ISUP_LOCATION_NUMBER = "isupLocationNumber";
    private byte[] data;
    protected static final XMLFormat<LocationNumberCapImpl> LOCATION_NUMBER_CAP_XML = new XMLFormat<LocationNumberCapImpl>(LocationNumberCapImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, LocationNumberCapImpl locationNumberCap) throws XMLStreamException {
            try {
                locationNumberCap.setLocationNumber(xml.get(LocationNumberCapImpl.ISUP_LOCATION_NUMBER, LocationNumberImpl.class));
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void write(LocationNumberCapImpl locationNumberCap, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                xml.add((LocationNumberImpl)locationNumberCap.getLocationNumber(), LocationNumberCapImpl.ISUP_LOCATION_NUMBER, LocationNumberImpl.class);
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }
    };

    public LocationNumberCapImpl() {
    }

    public LocationNumberCapImpl(byte[] data) {
        this.data = data;
    }

    public LocationNumberCapImpl(LocationNumber locationNumber) throws CAPException {
        this.setLocationNumber(locationNumber);
    }

    public void setLocationNumber(LocationNumber locationNumber) throws CAPException {
        if (locationNumber == null) {
            throw new CAPException("The locationNumber parameter must not be null");
        }
        try {
            this.data = ((LocationNumberImpl)locationNumber).encode();
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when encoding locationNumber: " + e.getMessage(), e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public LocationNumber getLocationNumber() throws CAPException {
        if (this.data == null) {
            throw new CAPException("The data has not been filled");
        }
        try {
            LocationNumberImpl ln = new LocationNumberImpl();
            ln.decode(this.data);
            return ln;
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when decoding LocationNumber: " + e.getMessage(), e);
        }
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding LocationNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding LocationNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding LocationNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding LocationNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding LocationNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding LocationNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
        if (this.data.length < 2 || this.data.length > 10) {
            throw new CAPParsingComponentException("Error while decoding LocationNumberCap: data must be from 2 to 10 bytes length, found: " + this.data.length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding LocationNumberCap: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("data field must not be null");
        }
        if (this.data.length < 2 && this.data.length > 10) {
            throw new CAPException("data field length must be from 2 to 10");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            sb.append("data=[");
            sb.append(this.printDataArr(this.data));
            sb.append("]");
            try {
                LocationNumber ln = this.getLocationNumber();
                sb.append(", ");
                sb.append(ln.toString());
            }
            catch (CAPException cAPException) {
                // empty catch block
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

