/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.isup;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.CauseCap;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.CauseIndicatorsImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.CauseIndicators;

public class CauseCapImpl
implements CauseCap,
CAPAsnPrimitive {
    private static final String CAUSE_INDICATORS = "causeIndicators";
    public static final String _PrimitiveName = "CauseCap";
    private static final String ISUP_CAUSE_INDICATORS_XML = "isupCauseIndicators";
    private byte[] data;
    protected static final XMLFormat<CauseCapImpl> CAUSE_CAP_XML = new XMLFormat<CauseCapImpl>(CauseCapImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CauseCapImpl causeCap) throws XMLStreamException {
            try {
                causeCap.setCauseIndicators(xml.get(CauseCapImpl.ISUP_CAUSE_INDICATORS_XML, CauseIndicatorsImpl.class));
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void write(CauseCapImpl causeCap, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                xml.add((CauseIndicatorsImpl)causeCap.getCauseIndicators(), CauseCapImpl.ISUP_CAUSE_INDICATORS_XML, CauseIndicatorsImpl.class);
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }
    };

    public CauseCapImpl() {
    }

    public CauseCapImpl(byte[] data) {
        this.data = data;
    }

    public CauseCapImpl(CauseIndicators causeIndicators) throws CAPException {
        this.setCauseIndicators(causeIndicators);
    }

    public void setCauseIndicators(CauseIndicators causeIndicators) throws CAPException {
        if (causeIndicators == null) {
            throw new CAPException("The causeIndicators parameter must not be null");
        }
        try {
            this.data = ((CauseIndicatorsImpl)causeIndicators).encode();
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when encoding causeIndicators: " + e.getMessage(), e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public CauseIndicators getCauseIndicators() throws CAPException {
        if (this.data == null) {
            throw new CAPException("The data has not been filled");
        }
        try {
            CauseIndicatorsImpl ln = new CauseIndicatorsImpl();
            ln.decode(this.data);
            return ln;
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when decoding locationNumber: " + e.getMessage(), e);
        }
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CauseCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CauseCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding CauseCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CauseCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CauseCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding CauseCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
        if (this.data.length < 2 || this.data.length > 32) {
            throw new CAPParsingComponentException("Error while decoding CauseCap: data must be from 2 to 32 bytes length, found: " + this.data.length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, 0, 4);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CauseCap: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("data field must not be null");
        }
        if (this.data.length < 2 && this.data.length > 32) {
            throw new CAPException("data field length must be from 2 to 32");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CauseCap [");
        if (this.data != null) {
            sb.append("data=[");
            sb.append(this.printDataArr(this.data));
            sb.append("]");
            try {
                CauseIndicators ci = this.getCauseIndicators();
                sb.append(", ");
                sb.append(ci.toString());
            }
            catch (CAPException cAPException) {
                // empty catch block
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

